/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.material.service.MdmMaterialService;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmMaterialController"})
@Api(tags={"MDM-\u7269\u6599\u7ba1\u7406"})
@CrmGlobalLog
public class MdmMaterialController {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialController.class);
    @Autowired
    private MdmMaterialService mdmMaterialService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmMaterialRespVo>> pageList(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        PageResult<MdmMaterialRespVo> result = this.mdmMaterialService.findList(mdmMaterialReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="materialCode", value="\u7269\u6599\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmMaterialRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="materialCode", required=false) String materialCode) {
        MdmMaterialRespVo respVo = this.mdmMaterialService.detail(id, materialCode);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        this.mdmMaterialService.save(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        this.mdmMaterialService.update(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmMaterialService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmMaterialService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmMaterialService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u7269\u6599")
    @PostMapping(value={"/findCurrentAndSubMaterialList"})
    public Result<List<MdmMaterialPriceRespVo>> findCurrentAndSubMaterialList(@RequestBody MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo) {
        List<MdmMaterialPriceRespVo> result = this.mdmMaterialService.findCurrentAndSubMaterialList(mdmMaterialOrgSearchReqVo);
        return Result.ok(result);
    }
}

