/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.org.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTerminalRespVo;
import com.biz.crm.org.mapper.MdmOrgTerminalMapper;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.org.service.MdmOrgTerminalService;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmOrgTerminalServiceImpl
implements MdmOrgTerminalService {
    @Resource
    private MdmOrgTerminalMapper mdmOrgTerminalMapper;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmTerminalService mdmTerminalService;

    @Override
    public PageResult<MdmOrgTerminalRespVo> findOrgTerminalList(MdmOrgTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmOrgTerminalRespVo> list = this.mdmOrgTerminalMapper.findOrgTerminalList((Page<MdmOrgTerminalRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateTerminalOrg(MdmOrgTerminalReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getTerminalCodeList(), (String)"\u7f3a\u5931\u7ec8\u7aef\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.detail(null, reqVo.getOrgCode());
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmTerminalService.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, (Collection)reqVo.getTerminalCodeList())).set(MdmTerminalEntity::getOrgCode, (Object)reqVo.getOrgCode())).update();
    }
}

