/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.icon.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.icon.mapper.MdmIconMapper;
import com.biz.crm.icon.model.MdmIconEntity;
import com.biz.crm.icon.service.IMdmIconService;
import com.biz.crm.nebular.mdm.icon.MdmIconReqVo;
import com.biz.crm.nebular.mdm.icon.MdmIconRespVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmIconServiceExpandImpl"})
public class MdmIconServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmIconMapper, MdmIconEntity>
implements IMdmIconService {
    private static final Logger log = LoggerFactory.getLogger(MdmIconServiceImpl.class);
    @Resource
    private MdmIconMapper mdmIconMapper;

    @Override
    public PageResult<MdmIconRespVo> findList(MdmIconReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmIconRespVo> list = this.mdmIconMapper.findList((Page<MdmIconRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmIconRespVo query(String id, String iconCode) {
        if (StringUtils.isEmpty((Object)id) || StringUtils.isEmpty((Object)iconCode)) {
            return null;
        }
        MdmIconEntity one = (MdmIconEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((Object)iconCode), MdmIconEntity::getIconCode, (Object)iconCode)).one());
        return (MdmIconRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmIconRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmIconReqVo reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getIconCode())) {
            reqVo.setIconCode(CodeUtil.generateCode());
        } else {
            Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmIconEntity::getIconCode, (Object)reqVo.getIconCode())).count();
            Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u56fe\u6807\u7f16\u7801\u5df2\u5b58\u5728");
        }
        reqVo.setId(null);
        this.save(CrmBeanUtil.copy((Object)reqVo, MdmIconEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmIconReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getIconCode(), (String)"\u56fe\u6807\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).count();
        Assert.isTrue((count != null && count > 0 ? 1 : 0) != 0, (String)"\u56fe\u6807\u4e0d\u5b58\u5728");
        Integer codeCount = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)reqVo.getId())).eq(MdmIconEntity::getIconCode, (Object)reqVo.getIconCode())).count();
        Assert.isTrue((codeCount == null || codeCount < 1 ? 1 : 0) != 0, (String)"\u56fe\u6807\u7f16\u7801\u91cd\u590d");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmIconEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }
}

