/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSelectReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmOrgController"})
@Api(tags={"MDM-\u7ec4\u7ec7\u7ba1\u7406"})
@CrmGlobalLog
public class MdmOrgController {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgController.class);
    @Autowired
    private MdmOrgService mdmOrgService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmOrgRespVo>> pageList(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        PageResult<MdmOrgRespVo> result = this.mdmOrgService.findList(mdmOrgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmOrgRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="orgCode", required=false) String orgCode) {
        return Result.ok((Object)this.mdmOrgService.detail(id, orgCode));
    }

    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7ec4\u7ec7\u4e3b\u8868\u4fe1\u606f")
    @PostMapping(value={"/detailBatchByIds"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> detailBatchByIds(@RequestBody List<String> ids) {
        return Result.ok(this.mdmOrgService.detailBatch(ids, null));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u7ec4\u7ec7\u4e3b\u8868\u4fe1\u606f")
    @PostMapping(value={"/detailBatchByOrgCodeList"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> detailBatchByOrgCodeList(@RequestBody List<String> orgCodeList) {
        return Result.ok(this.mdmOrgService.detailBatch(null, orgCodeList));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        this.mdmOrgService.save(mdmOrgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        this.mdmOrgService.update(mdmOrgReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmOrgService.deleteBatch(new MdmOrgReqVo().setIds(ids));
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.mdmOrgService.enableBatch(new MdmOrgReqVo().setIds(ids));
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.mdmOrgService.disableBatch(new MdmOrgReqVo().setIds(ids));
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7ec4\u7ec7\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/findOrgSelectList"})
    @CrmDictMethod
    public Result<List<MdmOrgSelectRespVo>> findOrgSelectList(@RequestBody MdmOrgSelectReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findOrgSelectList(reqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5168\u90e8\u4e0b\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findAllChildrenOrgList"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> findAllChildrenOrgList(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findAllChildrenOrgList(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0b\u7ea7\uff08\u4e0d\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findSingleChildrenOrgList"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> findSingleChildrenOrgList(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findSingleChildrenOrgList(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5168\u90e8\u4e0a\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findAllParentOrgList"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> findAllParentOrgList(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findAllParentOrgList(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0a\u7ea7\u7ec4\u7ec7")
    @PostMapping(value={"/findSingleParentOrg"})
    @CrmDictMethod
    public Result<MdmOrgRespVo> findSingleParentOrg(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok((Object)this.mdmOrgService.findSingleParentOrg(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0a\u7ea7\u7ec4\u7ec7", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="orgCode", value="\u7ec4\u7ec7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/getParentOrg"})
    @CrmDictMethod
    public Result<MdmOrgRespVo> getParentOrg(@RequestParam(value="id", required=false) String id, @RequestParam(value="orgCode", required=false) String orgCode) {
        return Result.ok((Object)this.mdmOrgService.findSingleParentOrg(id, orgCode));
    }

    @ApiOperation(value="\u91cd\u7f6e\u7ec4\u7ec7\u6811\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/resetRuleCode"})
    @CrmDictMethod
    public Result resetRuleCode() {
        this.mdmOrgService.resetRuleCode();
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u8fd9\u4e9b\u7ec4\u7ec7\u7f16\u7801\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff0c\u6bcf\u4e2a\u7ec4\u7ec7\u4e0a\u9644\u5e26\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u542b\u4e0b\u7ea7\u7ec4\u7ec7\uff09\u4e0b\u7684\u5168\u90e8\u4e3b\u804c\u4f4d")
    @PostMapping(value={"/findOrgWithAllPositionList"})
    public Result<List<MdmOrgWithPositionRespVo>> findOrgWithAllPositionList(@RequestBody List<String> orgCodeList) {
        return Result.ok(this.mdmOrgService.findOrgWithAllPositionList(orgCodeList));
    }

    @ApiOperation(value="\u67e5\u8be2\u8fd9\u4e9b\u7ec4\u7ec7\u7f16\u7801\u5bf9\u5e94\u7684\u7ec4\u7ec7\uff0c\u6bcf\u4e2a\u7ec4\u7ec7\u4e0a\u9644\u5e26\u8fd9\u4e2a\u7ec4\u7ec7\uff08\u4e0d\u542b\u4e0b\u7ea7\u7ec4\u7ec7\uff09\u4e0b\u7684\u5168\u90e8\u4e3b\u804c\u4f4d")
    @PostMapping(value={"/findOrgWithSinglePositionList"})
    public Result<List<MdmOrgWithPositionRespVo>> findOrgWithSinglePositionList(@RequestBody List<String> orgCodeList) {
        return Result.ok(this.mdmOrgService.findOrgWithSinglePositionList(orgCodeList));
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2\u7ec4\u7ec7\u53ca\u4e0b\u7ea7\u7ec4\u7ec7,\u8fd4\u56de\uff08pageSize\uff09\u5bf9\u5e94\u6761\u6570")
    @PostMapping(value={"/findOrgAndChildrenList"})
    public Result<List<MdmOrgRespVo>> findOrgAndChildrenList(@RequestBody MdmOrgSearchReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findOrgAndChildrenList(reqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/listCondition"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> listCondition(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok(this.mdmOrgService.listCondition(reqVo));
    }
}

