/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyDetailVo;
import com.biz.crm.terminal.mapper.MdmTerminalSupplyDetailMapper;
import com.biz.crm.terminal.model.MdmTerminalSupplyDetailEntity;
import com.biz.crm.terminal.service.MdmTerminalSupplyDetailService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
@ConditionalOnMissingBean(name={"mdmTerminalSupplyDetailServiceExpandImpl"})
public class MdmTerminalSupplyDetailServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalSupplyDetailMapper, MdmTerminalSupplyDetailEntity>
implements MdmTerminalSupplyDetailService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalSupplyDetailServiceImpl.class);

    @Override
    public List<MdmTerminalSupplyDetailEntity> getListBySupplyIdOrDataType(List<String> supplyIds, String dataType) {
        List list;
        if (CollectionUtils.isEmpty(supplyIds)) {
            return new ArrayList<MdmTerminalSupplyDetailEntity>();
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"supply_id", supplyIds);
        if (StringUtils.isNotEmpty((String)dataType)) {
            queryWrapper.eq((Object)"data_type", (Object)dataType);
        }
        list = (list = this.list((Wrapper)queryWrapper)) == null ? new ArrayList() : list;
        return list;
    }

    @Override
    public void saveList(List<MdmTerminalSupplyDetailVo> details) {
        if (CollectionUtil.listEmpty(details)) {
            return;
        }
        List entities = CrmBeanUtil.copyList(details, MdmTerminalSupplyDetailEntity.class);
        entities.forEach(x -> x.setId(UUID.randomUUID().toString()));
        this.saveBatch(entities);
    }

    @Override
    public void updateList(List<MdmTerminalSupplyDetailVo> details, String supplyId) {
        if (StringUtils.isEmpty((String)supplyId)) {
            throw new BusinessException("\u4f9b\u8d27\u5173\u8054\u5173\u7cfb\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.listEmpty(details)) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"supply_id", (Object)supplyId);
            this.remove((Wrapper)queryWrapper);
            return;
        }
        details.forEach(item -> item.setSupplyId(supplyId));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"supply_id", (Object)supplyId);
        List oldList = this.list((Wrapper)queryWrapper);
        ArrayList<MdmTerminalSupplyDetailVo> addList = new ArrayList<MdmTerminalSupplyDetailVo>();
        ArrayList<MdmTerminalSupplyDetailVo> updateList = new ArrayList<MdmTerminalSupplyDetailVo>();
        ArrayList deleteList = new ArrayList();
        HashMap itemMap = oldList.stream().collect(Collectors.toMap(BaseIdEntity::getId, item -> item));
        itemMap = itemMap == null ? new HashMap() : itemMap;
        for (MdmTerminalSupplyDetailVo mdmTerminalSupplyDetailVo : details) {
            if (itemMap.containsKey(mdmTerminalSupplyDetailVo.getId())) {
                updateList.add(mdmTerminalSupplyDetailVo);
                itemMap.remove(mdmTerminalSupplyDetailVo.getId());
                continue;
            }
            addList.add(mdmTerminalSupplyDetailVo);
        }
        if (!itemMap.isEmpty()) {
            for (Map.Entry entry : itemMap.entrySet()) {
                deleteList.add(entry.getValue());
            }
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(addList)) {
            List entities = CrmBeanUtil.copyList(addList, MdmTerminalSupplyDetailEntity.class);
            for (MdmTerminalSupplyDetailEntity entity : entities) {
                entity.setId(UUID.randomUUID().toString());
            }
            this.saveBatch(entities);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(updateList)) {
            List updateEntitys = CrmBeanUtil.copyList(updateList, MdmTerminalSupplyDetailEntity.class);
            this.updateBatchById(updateEntitys);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(deleteList)) {
            List ids = deleteList.stream().map(BaseIdEntity::getId).collect(Collectors.toList());
            this.removeByIds(ids);
        }
    }

    @Override
    public void deleteBySupplyIds(List<String> supplyIds) {
        if (CollectionUtil.listEmpty(supplyIds)) {
            return;
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"supply_id", supplyIds);
        this.remove((Wrapper)queryWrapper);
    }
}

