/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.logtemplate.service.impl;

import com.alibaba.druid.sql.visitor.functions.Char;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.logtemplate.entity.LogFieldEntity;
import com.biz.crm.logtemplate.entity.LogTemplateEntity;
import com.biz.crm.logtemplate.repositories.LogTemplateRepositories;
import com.biz.crm.logtemplate.service.LogTemplateService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.RedissonUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.utils.EsUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.swagger.annotations.ApiModelProperty;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.assertj.core.util.Sets;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.redisson.api.RMap;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.aggregation.AggregatedPage;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Service;

@ConditionalOnMissingBean(name={"logTemplateServiceImpl"})
@Service(value="logTemplateService")
public class LogTemplateServiceImpl
implements LogTemplateService {
    private Logger LOGGER = LoggerFactory.getLogger(LogTemplateServiceImpl.class);
    private static final String LOG_TEMPLATE_REDIS_PATH = "dms:log";
    @Resource
    private RedissonClient redissonClient;
    @Resource
    private ElasticsearchTemplate elasticsearchTemplate;
    @Resource
    private RedissonUtil redissonUtil;
    @Resource
    private LogTemplateRepositories logTemplateRepositories;

    @Override
    public Map<String, LogFieldEntity> findFieldsByType(String type) {
        TreeMap fieldVos = Maps.newTreeMap();
        try {
            Class<?> cls = Class.forName(type);
            List<Field> fields = this.getFields(cls);
            for (Field field : fields) {
                LogFieldEntity filedVo = this.buildFieldVo(field);
                fieldVos.put(filedVo.getFieldName(), filedVo);
            }
        }
        catch (ClassNotFoundException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BusinessException("\u83b7\u53d6\u5b57\u6bb5\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u4f20\u5165\u7c7b\u578b\u662f\u5426\u6b63\u786e");
        }
        return fieldVos;
    }

    @Override
    public Map<String, LogFieldEntity> findFieldsByTypeAndCode(String type, String templateCode) {
        if (StringUtils.isEmpty((String)type) || StringUtils.isEmpty((String)templateCode)) {
            return Maps.newHashMap();
        }
        Map<String, LogFieldEntity> fieldVos = this.findFieldsByType(type);
        LogTemplateEntity logTemplateVo = this.logTemplateRepositories.findByCode(templateCode);
        if (logTemplateVo == null || logTemplateVo.getFieldMap() == null) {
            return Maps.newHashMap();
        }
        Map<String, LogFieldEntity> oldFields = logTemplateVo.getFieldMap();
        TreeMap map = Maps.newTreeMap();
        fieldVos.forEach((k, v) -> {
            v.setCompare(this.hasField((LogFieldEntity)v, oldFields));
            map.put(v.getFieldName(), v);
        });
        return map;
    }

    private boolean hasField(LogFieldEntity vo, Map<String, LogFieldEntity> oldFields) {
        if (vo == null || !CollectionUtil.mapNotEmpty(oldFields)) {
            return false;
        }
        return oldFields.get(vo.getFieldName()) != null;
    }

    @Override
    public void create(LogTemplateEntity vo) {
        ValidateUtils.validate((Object)((Object)vo), (String)"\u65b0\u589e\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        LogTemplateEntity logTemplateEntity = this.logTemplateRepositories.findByCode(vo.getCode());
        ValidateUtils.isTrue((logTemplateEntity == null ? 1 : 0) != 0, (String)"\u6a21\u677f\u3010%s\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u65b0\u589e", (String[])new String[]{vo.getCode()});
        vo.setId(CodeUtil.getCode());
        vo.setCode(vo.getType());
        vo.setEnableState(true);
        vo.setCreateTime(new Date());
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            vo.setCreateAccount(user.getUsername());
        }
        Map<String, LogFieldEntity> fields = vo.getFieldMap();
        ValidateUtils.notEmpty(fields, (String)"\u4fdd\u5b58\u65e5\u5fd7\u6a21\u677f\u65f6\uff0c\u5b57\u6bb5\u5217\u8868\u5fc5\u987b\u4f20\u5165", (String[])new String[0]);
        this.removeUnCompareField(fields);
        EsUtil.indexExsit(this.elasticsearchTemplate, LogTemplateEntity.class, this.redissonUtil);
        this.logTemplateRepositories.save((Object)vo);
        RMap template = this.redissonClient.getMap(LOG_TEMPLATE_REDIS_PATH);
        template.put((Object)vo.getCode(), (Object)JSONObject.toJSONString((Object)((Object)vo)));
    }

    private void removeUnCompareField(Map<String, LogFieldEntity> fields) {
        if (!CollectionUtil.mapNotEmpty(fields)) {
            return;
        }
        HashSet codes = Sets.newHashSet();
        fields.forEach((k, v) -> {
            if (!v.isCompare()) {
                codes.add(k);
            } else {
                this.removeUnCompareField(v.getChildren());
            }
        });
        codes.forEach(c -> {
            LogFieldEntity cfr_ignored_0 = (LogFieldEntity)fields.remove(c);
        });
    }

    @Override
    public void update(LogTemplateEntity vo) {
        ValidateUtils.validate((Object)((Object)vo), (String)"\u7f16\u8f91\u65f6\uff0c\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.validate((Object)vo.getCode(), (String)"\u7f16\u8f91\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ValidateUtils.notEmpty(vo.getFieldMap(), (String)"\u7f16\u8f91\u65f6\uff0c\u5b57\u6bb5\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        LogTemplateEntity logTemplateEntity = this.logTemplateRepositories.findByCode(vo.getCode());
        ValidateUtils.validate((Object)((Object)logTemplateEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4");
        vo.setModifyTime(new Date());
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            vo.setModifyAccount(user.getUsername());
        }
        this.logTemplateRepositories.save((Object)vo);
        RMap template = this.redissonClient.getMap(LOG_TEMPLATE_REDIS_PATH);
        template.put((Object)vo.getCode(), (Object)JSONObject.toJSONString((Object)((Object)vo)));
    }

    @Override
    public LogTemplateEntity read(String templateCode) {
        ValidateUtils.validate((Object)templateCode, (String)"\u8bfb\u53d6\u65e5\u5fd7\u6a21\u677f\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        RMap template = this.redissonClient.getMap(LOG_TEMPLATE_REDIS_PATH);
        String json = (String)template.get((Object)templateCode);
        LogTemplateEntity logTemplateVo = (LogTemplateEntity)((Object)JSONObject.parseObject((String)json, LogTemplateEntity.class));
        return logTemplateVo;
    }

    @Override
    public PageResult<LogTemplateEntity> findPageByConditions(LogTemplateEntity req) {
        PageRequest page = PageRequest.of((int)req.getPageNum(), (int)req.getPageSize());
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (req.getStartTime() != null && req.getEndTime() != null) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.rangeQuery((String)"createTime").from((Object)req.getStartTime()).to((Object)req.getEndTime()));
        }
        if (StringUtils.isNotEmpty((String)req.getCode())) {
            boolQueryBuilder.filter((QueryBuilder)QueryBuilders.matchQuery((String)"code", (Object)req.getCode()));
        }
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"es_log_template_index"}).withQuery((QueryBuilder)boolQueryBuilder).withSort(SortBuilders.fieldSort((String)"createTime").unmappedType("keyword").order(SortOrder.DESC)).withPageable((Pageable)page).build();
        AggregatedPage pageResult = this.elasticsearchTemplate.queryForPage((SearchQuery)searchQuery, LogTemplateEntity.class);
        PageResult result = PageResult.builder().data(pageResult.getContent()).count(Long.valueOf(pageResult.getTotalElements())).build();
        return result;
    }

    @Override
    public void enable(String templateCode, boolean status) {
        ValidateUtils.validate((Object)templateCode, (String)"\u5220\u9664\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LogTemplateEntity logTemplateEntity = this.logTemplateRepositories.findByCode(templateCode);
        ValidateUtils.validate((Object)((Object)logTemplateEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        logTemplateEntity.setEnableState(status);
        this.update(logTemplateEntity);
    }

    @Override
    public void deleteByCode(String templateCode) {
        ValidateUtils.validate((Object)templateCode, (String)"\u5220\u9664\u64cd\u4f5c\u65f6\uff0c\u6a21\u677f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LogTemplateEntity logTemplateEntity = this.logTemplateRepositories.findByCode(templateCode);
        ValidateUtils.validate((Object)((Object)logTemplateEntity), (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u539f\u59cb\u8bb0\u5f55\uff0c\u8bf7\u786e\u8ba4\u7f16\u7801\u662f\u5426\u6b63\u786e\u4f20\u5165");
        this.logTemplateRepositories.delete((Object)logTemplateEntity);
        RMap template = this.redissonClient.getMap(LOG_TEMPLATE_REDIS_PATH);
        template.remove((Object)templateCode);
    }

    private LogFieldEntity buildFieldVo(Field field) {
        ValidateUtils.validate((Object)field, (String)"\u83b7\u53d6\u5b57\u6bb5\u5f02\u5e38");
        LogFieldEntity filedVo = new LogFieldEntity();
        filedVo.setFieldName(field.getName());
        filedVo.setType(field.getType().getName());
        ApiModelProperty apiModelProperty = field.getAnnotation(ApiModelProperty.class);
        if (apiModelProperty != null) {
            filedVo.setDesc(apiModelProperty.value());
        }
        if (this.isBasicType(field.getType())) {
            filedVo.setHostType(0);
            filedVo.setHostTypeName("\u57fa\u7840\u7c7b\u578b");
        } else if (field.getType() == Collection.class || field.getType() == List.class || field.getType() == Set.class) {
            Type fType = field.getGenericType();
            ParameterizedType pType = (ParameterizedType)fType;
            if (pType != null) {
                filedVo.setType(pType.getActualTypeArguments()[0].getTypeName());
            }
            filedVo.setHostType(2);
            filedVo.setHostTypeName("\u96c6\u5408\u7c7b\u578b");
        } else if (!this.isBasicType(field.getType()) && field.getType() != Map.class) {
            filedVo.setHostType(1);
            filedVo.setHostTypeName("\u5bf9\u8c61\u7c7b\u578b");
        } else if (field.getType() != Map.class) {
            Type fType = field.getGenericType();
            ParameterizedType pType = (ParameterizedType)fType;
            if (pType != null) {
                filedVo.setType(pType.getActualTypeArguments()[1].getTypeName());
            }
            filedVo.setHostType(3);
            filedVo.setHostTypeName("MAP\u7c7b\u578b");
        }
        return filedVo;
    }

    private boolean isBasicType(Class<?> type) {
        return type == Integer.TYPE || type == Integer.class || type == Double.TYPE || type == Double.class || type == Long.TYPE || type == Long.class || type == Float.TYPE || type == Float.class || type == Character.TYPE || type == Char.class || type == Byte.TYPE || type == Byte.class || type == String.class;
    }

    private List<Field> getFields(Class c) {
        ArrayList fields = Lists.newArrayList();
        while (c != null) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
            c = c.getSuperclass();
        }
        return fields;
    }
}

