/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSearchReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSelectReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgSelectRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgTreeRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgWithPositionRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.model.MdmOrgRegionEntity;
import com.biz.crm.org.service.MdmOrgRegionService;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.TreeRuleCodeUtil;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmOrgServiceExpandImpl"})
public class MdmOrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmOrgMapper, MdmOrgEntity>
implements MdmOrgService {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgServiceImpl.class);
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmTerminalService mdmTerminalService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmOrgRegionService mdmOrgRegionService;

    @Override
    public PageResult<MdmOrgRespVo> findList(MdmOrgReqVo reqVo) {
        MdmOrgEntity one;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (!StringUtils.isEmpty((String)reqVo.getCode()) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getCode())).one())) != null) {
            reqVo.setRuleCode(one.getRuleCode());
        }
        List<MdmOrgRespVo> list = this.mdmOrgMapper.findList((Page<MdmOrgRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmOrgRespVo detail(String id, String orgCode) {
        MdmOrgEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)orgCode)) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one())) != null) {
            MdmOrgEntity parent;
            MdmOrgRespVo org = (MdmOrgRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmOrgRespVo.class);
            if (StringUtils.isNotEmpty((String)org.getParentCode()) && (parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)org.getParentCode())).select(new SFunction[]{MdmOrgEntity::getOrgName}).one())) != null) {
                org.setParentName(parent.getOrgName());
            }
            return org;
        }
        return null;
    }

    @Override
    public List<MdmOrgRespVo> detailBatch(List<String> ids, List<String> orgCodeList) {
        List entityList;
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).or()).in(CollectionUtil.listNotEmptyNotSizeZero(orgCodeList), MdmOrgEntity::getOrgCode, orgCodeList)).list()))) {
            List parentList;
            List list = CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class);
            List parentCodeList = entityList.stream().map(MdmOrgEntity::getParentCode).distinct().filter(StringUtils::isNotEmpty).collect(Collectors.toList());
            if (CollectionUtil.listNotEmptyNotSizeZero(parentCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, parentCodeList)).select(new SFunction[]{MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName}).list()))) {
                Map<String, String> collect = parentList.stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName));
                list.forEach(item -> {
                    if (StringUtils.isNotEmpty((String)item.getParentCode())) {
                        item.setParentName((String)collect.get(item.getParentCode()));
                    }
                });
            }
            return list;
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmOrgReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgType(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getEnableStatus(), (String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        MdmOrgEntity entity = (MdmOrgEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmOrgEntity.class));
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            MdmOrgEntity parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getParentCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u88ab\u7981\u7528");
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(levelNum);
        if (StringUtils.isEmpty((String)entity.getOrgCode())) {
            entity.setOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ORG_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getOrgCode())).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u7ec4\u7ec7\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmOrgReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmOrgEntity entity = (MdmOrgEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)entity.getOrgCode().equals(reqVo.getOrgCode()), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        String entityRuleCode = entity.getRuleCode();
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getOrgCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u5f53\u524d\u7ec4\u7ec7");
            if (!parentCode.equals(entity.getParentCode())) {
                reloadRuleCode = true;
                MdmOrgEntity parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)parentCode)).one());
                Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7");
                levelNum = parent.getLevelNum() + 1;
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentCode())) {
            reloadRuleCode = true;
            reqVo.setParentCode("");
        }
        if (!entity.getEnableStatus().equals(reqVo.getEnableStatus()) && CrmEnableStatusEnum.DISABLE.getCode().equals(reqVo.getEnableStatus())) {
            this.disableBatch(new MdmOrgReqVo().setIds(Collections.singletonList(entity.getId())));
        }
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmOrgEntity.class));
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getOrgCode(), ruleCode, levelNum);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        reqVo.getIds().forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmOrgEntity one = (MdmOrgEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            List children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)children), (String)"\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u7ec4\u7ec7\u4e0d\u80fd\u88ab\u5220\u9664");
            List positionList = ((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)positionList), (String)"\u5b58\u5728\u5173\u8054\u804c\u4f4d\u65e0\u6cd5\u5220\u9664");
            List terminalList = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)terminalList), (String)"\u5b58\u5728\u5173\u8054\u7ec8\u7aef\u65e0\u6cd5\u5220\u9664");
            List customerList = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)customerList), (String)"\u5b58\u5728\u5173\u8054\u5ba2\u6237\u65e0\u6cd5\u5220\u9664");
            List orgRegionList = ((LambdaQueryChainWrapper)this.mdmOrgRegionService.lambdaQuery().eq(MdmOrgRegionEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)orgRegionList), (String)"\u5b58\u5728\u5173\u8054\u884c\u653f\u533a\u57df\u65e0\u6cd5\u5220\u9664");
            this.removeById((Serializable)((Object)id));
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        reqVo.getIds().forEach(id -> {
            MdmOrgEntity entity = (MdmOrgEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            if (!CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus())) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodesExcludeSelf(entity.getRuleCode());
                if (!parentRuleCodes.isEmpty()) {
                    List disableParentList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).in(CrmTreeTenEntity::getRuleCode, parentRuleCodes)).list();
                    Assert.isTrue((boolean)CollectionUtil.listEmpty((List)disableParentList), (String)("\u7ec4\u7ec7[" + entity.getOrgName() + "]\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u542f\u7528\u5f53\u524d\u7ec4\u7ec7"));
                }
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        List<MdmOrgRespVo> list = this.findAllChildrenOrgListByList(reqVo.getIds(), null);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)list.stream().map(UuidVo::getId).distinct().collect(Collectors.toList()))).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        }
    }

    @Override
    public List<MdmOrgSelectRespVo> findOrgSelectList(MdmOrgSelectReqVo reqVo) {
        List<MdmOrgSelectRespVo> selectedList;
        MdmOrgEntity one;
        ArrayList<MdmOrgSelectRespVo> list = new ArrayList<MdmOrgSelectRespVo>();
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        String underThisRuleCode = null;
        String notUnderThisRuleCode = null;
        if (StringUtils.isNotEmpty((String)reqVo.getUnderThisOrgCode()) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            underThisRuleCode = one.getRuleCode();
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisOrgCode()) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getNotUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            notUnderThisRuleCode = one.getRuleCode();
        }
        ArrayList<String> codeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(codeList) && CollectionUtil.listNotEmptyNotSizeZero(selectedList = this.mdmOrgMapper.findOrgSelectList((Page<MdmOrgSelectRespVo>)new Page(1L, (long)codeList.size(), false), reqVo, underThisRuleCode, notUnderThisRuleCode, codeList, null))) {
            list.addAll(selectedList);
            pageSize = pageSize - selectedList.size();
        }
        if (pageSize > 0) {
            list.addAll(this.mdmOrgMapper.findOrgSelectList((Page<MdmOrgSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, underThisRuleCode, notUnderThisRuleCode, null, codeList));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllChildrenOrgList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)org.getRuleCode())).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllChildrenOrgListByList(List<String> ids, List<String> orgCodeList) {
        List orgEntityList;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(orgCodeList), MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list()))) {
            List collect = orgEntityList.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList());
            HashSet set = new HashSet();
            for (String ruleCode : collect) {
                List childrenList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)ruleCode)).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)childrenList)) continue;
                set.addAll(childrenList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList()));
            }
            if (!set.isEmpty()) {
                List orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, set)).list();
                list.addAll(CrmBeanUtil.copyList((List)orgList, MdmOrgRespVo.class));
            }
        }
        return list;
    }

    @Override
    public List<String> findAllChildrenOrgCodeList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<String> list = new ArrayList<String>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)org.getRuleCode())).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
            list.addAll(entityList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findSingleChildrenOrgList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one())) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)org.getOrgCode())).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllParentOrgList(String orgId, String orgCode) {
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        MdmOrgEntity one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one());
        if (one != null) {
            Set<String> ruleCodes = TreeRuleCodeUtil.splitParentRuleCodes(one.getRuleCode());
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, ruleCodes)).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public MdmOrgRespVo findSingleParentOrg(String orgId, String orgCode) {
        MdmOrgEntity parent;
        MdmOrgEntity one;
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one())) != null && StringUtils.isNotEmpty((String)one.getParentCode()) && (parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)one.getParentCode())).one())) != null) {
            return (MdmOrgRespVo)CrmBeanUtil.copy((Object)((Object)parent), MdmOrgRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void resetRuleCode() {
        List all = this.lambdaQuery().list();
        all.forEach(item -> item.setRuleCode(UUID.randomUUID().toString()));
        this.updateBatchById(all);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((MdmOrgEntity)((Object)list.get(i))).getOrgCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
    }

    @Override
    public List<MdmOrgWithPositionRespVo> findOrgWithAllPositionList(List<String> orgCodeList) {
        List orgList;
        List<Object> list = new ArrayList<MdmOrgWithPositionRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).list()))) {
            list = CrmBeanUtil.copyList((List)orgList, MdmOrgWithPositionRespVo.class);
            list.forEach(item -> {
                MdmPositionUserOrgReqVo reqVo = new MdmPositionUserOrgReqVo();
                reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
                reqVo.setAllUnderThisOrgCode(item.getOrgCode());
                item.setPositionList(this.mdmPositionService.findPositionUserOrgList(reqVo));
            });
        }
        return list;
    }

    @Override
    public List<MdmOrgWithPositionRespVo> findOrgWithSinglePositionList(List<String> orgCodeList) {
        List orgList;
        List<Object> list = new ArrayList<MdmOrgWithPositionRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(orgCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, orgCodeList)).list()))) {
            MdmPositionUserOrgReqVo reqVo = new MdmPositionUserOrgReqVo();
            reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            reqVo.setOrgCodeList(orgCodeList);
            List<MdmPositionUserOrgRespVo> positionUserOrgList = this.mdmPositionService.findPositionUserOrgList(reqVo);
            list = CrmBeanUtil.copyList((List)orgList, MdmOrgWithPositionRespVo.class);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList)) {
                Map<String, List<MdmPositionUserOrgRespVo>> collect = positionUserOrgList.stream().collect(Collectors.groupingBy(MdmPositionUserOrgRespVo::getOrgCode));
                list.forEach(item -> item.setPositionList((List)collect.get(item.getOrgCode())));
            }
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findOrgAndChildrenList(MdmOrgSearchReqVo reqVo) {
        List orgList;
        ArrayList<String> rightLikeOrgRuleCodeList = new ArrayList<String>();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getUnderOrgCodeList()) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, (Collection)reqVo.getUnderOrgCodeList())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list()))) {
            rightLikeOrgRuleCodeList.addAll(orgList.stream().map(k -> k.getRuleCode() + "%").collect(Collectors.toList()));
        }
        if (reqVo.getPageSize() == null || reqVo.getPageSize() == 0) {
            reqVo.setPageSize(Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size")));
        }
        return this.mdmOrgMapper.findOrgAndChildrenList((Page<MdmOrgRespVo>)new Page(1L, (long)reqVo.getPageSize().intValue(), false), reqVo, rightLikeOrgRuleCodeList);
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmOrgEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)parentCode)).one())) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmOrgEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                Integer integer = TreeRuleCodeUtil.getCurLevelNum(item.getRuleCode());
                set.add(integer);
            }
            for (int i = 1; i < 999; ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(i);
                break;
            }
        }
        return ruleCode;
    }

    private void updateCurAndChildren(String orgCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgEntity::getOrgCode, (Object)orgCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)orgCode)).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmOrgEntity)((Object)list.get(i))).getOrgCode(), curCode + TreeRuleCodeUtil.numToSingleCode(i + 1), levelNum + 1);
            }
        }
    }

    @Override
    public List<MdmOrgRespVo> listCondition(MdmOrgReqVo reqVo) {
        if (CollectionUtil.collectionNotEmpty((Collection)reqVo.getOrgCodeList())) {
            List mdmOrgEntities = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, reqVo.getOrgCodeList())).list();
            return CrmBeanUtil.copyList((List)mdmOrgEntities, MdmOrgRespVo.class);
        }
        return Lists.emptyList();
    }

    @Override
    public List<MdmOrgRespVo> findOrgList(MdmOrgReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).eq(StringUtils.isNotEmpty((String)reqVo.getOrgType()), MdmOrgEntity::getOrgType, (Object)reqVo.getOrgType())).eq(StringUtils.isNotEmpty((String)reqVo.getParentCode()), MdmOrgEntity::getParentCode, (Object)reqVo.getParentCode())).like(StringUtils.isNotEmpty((String)reqVo.getOrgCode()), MdmOrgEntity::getOrgCode, (Object)reqVo.getOrgCode())).like(StringUtils.isNotEmpty((String)reqVo.getOrgName()), MdmOrgEntity::getOrgName, (Object)reqVo.getOrgName())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            return CrmBeanUtil.copyList((List)list, MdmOrgRespVo.class);
        }
        return new ArrayList<MdmOrgRespVo>();
    }

    @Override
    public List<MdmOrgTreeRespVo> getOrgTree() {
        List list = this.lambdaQuery().list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List totalList = CrmBeanUtil.copyList((List)list, MdmOrgTreeRespVo.class);
            ArrayList<MdmOrgTreeRespVo> treeList = new ArrayList<MdmOrgTreeRespVo>();
            ArrayList<Object> curLevelList = new ArrayList<Object>();
            ArrayList<Object> restList = new ArrayList<Object>();
            Map<String, MdmOrgTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmOrgTreeRespVo::getOrgCode, v -> v));
            for (MdmOrgTreeRespVo item : totalList) {
                if (StringUtils.isEmpty((String)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                    treeList.add(item);
                    curLevelList.add(item);
                    continue;
                }
                restList.add(item);
            }
            while (curLevelList.size() > 0 && restList.size() > 0) {
                ArrayList<MdmOrgTreeRespVo> restTempList = new ArrayList<MdmOrgTreeRespVo>();
                ArrayList<MdmOrgTreeRespVo> curLevelTempList = new ArrayList<MdmOrgTreeRespVo>();
                Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(MdmOrgTreeRespVo::getOrgCode, MdmOrgTreeRespVo::getOrgCode));
                HashMap curLevelChildrenMap = new HashMap();
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : restList) {
                    if (curLevelMap.containsKey(mdmOrgTreeRespVo.getParentCode())) {
                        curLevelTempList.add(mdmOrgTreeRespVo);
                        ArrayList<MdmOrgTreeRespVo> childrenList = new ArrayList<MdmOrgTreeRespVo>();
                        if (curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getParentCode())) {
                            childrenList.addAll((Collection)curLevelChildrenMap.get(mdmOrgTreeRespVo.getParentCode()));
                        }
                        childrenList.add(mdmOrgTreeRespVo);
                        curLevelChildrenMap.put(mdmOrgTreeRespVo.getParentCode(), childrenList);
                        continue;
                    }
                    restTempList.add(mdmOrgTreeRespVo);
                }
                for (MdmOrgTreeRespVo mdmOrgTreeRespVo : curLevelList) {
                    if (!curLevelChildrenMap.containsKey(mdmOrgTreeRespVo.getOrgCode())) continue;
                    mdmOrgTreeRespVo.setChildren((List)curLevelChildrenMap.get(mdmOrgTreeRespVo.getOrgCode()));
                }
                curLevelList.clear();
                curLevelList.addAll(curLevelTempList);
                restList.clear();
                restList.addAll(restTempList);
            }
            return treeList;
        }
        return new ArrayList<MdmOrgTreeRespVo>();
    }
}

