/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictService;
import com.biz.crm.nebular.mdm.dict.resp.DictAttrConfRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataRedisVo;
import com.biz.crm.nebular.mdm.dict.resp.DictGroupRedisVo;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MdmDictServiceImpl
implements MdmDictService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictServiceImpl.class);
    @Resource
    private MdmDictDataService mdmDictDataService;
    @Resource
    private MdmDictAttrConfService mdmDictAttrConfService;

    @Override
    public List<DictGroupRedisVo> getDictGroupRedisList(List<String> dictTypeCodeList) {
        ArrayList<DictGroupRedisVo> list = new ArrayList<DictGroupRedisVo>();
        dictTypeCodeList.forEach(dictTypeCode -> {
            DictGroupRedisVo group = this.getDictGroupRedis((String)dictTypeCode);
            if (group != null) {
                list.add(group);
            }
        });
        return list;
    }

    private DictGroupRedisVo getDictGroupRedis(String dictTypeCode) {
        DictGroupRedisVo respVo = null;
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).orderByAsc(MdmDictDataEntity::getDictSort)).list();
        if (list != null && list.size() > 0) {
            respVo = new DictGroupRedisVo();
            respVo.setDictTypeCode(dictTypeCode);
            respVo.setDataList(CrmBeanUtil.copyList((List)list, DictDataRedisVo.class));
            List confEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDictAttrConfService.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)dictTypeCode)).orderByAsc(MdmDictAttrConfEntity::getShowOrder)).list();
            if (confEntityList != null && confEntityList.size() > 0) {
                respVo.setConfList(CrmBeanUtil.copyList((List)confEntityList, DictAttrConfRedisVo.class));
            }
        }
        return respVo;
    }
}

