/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.user.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerSupplyService;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.mapper.MdmUserRelationCustomerMapper;
import com.biz.crm.user.service.MdmUserRelationCustomerService;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmUserRelationCustomerServiceImpl
implements MdmUserRelationCustomerService {
    @Resource
    private MdmUserRelationCustomerMapper mdmUserRelationCustomerMapper;
    @Resource
    private MdmPositionService mdmPositionService;
    @Resource
    private MdmCustomerSupplyService mdmCustomerSupplyService;

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateAnyUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserRelationCustomerMapper.findCustomerNotRelateAnyUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerNotRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserRelationCustomerMapper.findCustomerNotRelateCurUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmUserRelationCustomerPageRespVo> findCustomerHasRelateCurUser(MdmUserRelationCustomerPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmUserRelationCustomerPageRespVo> list = this.mdmUserRelationCustomerMapper.findCustomerHasRelateCurUser((Page<MdmUserRelationCustomerPageRespVo>)page, reqVo);
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void bindRelation(MdmUserRelationCustomerReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).one());
        Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        reqVo.getCustomerCodeList().forEach(customerCode -> this.mdmCustomerSupplyService.addRelation((String)customerCode, position.getPositionCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceCustomerPosition(MdmUserRelationCustomerReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).one());
        Assert.notNull((Object)((Object)position), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        this.mdmCustomerSupplyService.replacePosition(reqVo.getIds(), reqVo.getPositionCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindRelation(MdmUserRelationCustomerReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931id");
        this.mdmCustomerSupplyService.removeRelations(reqVo.getIds());
    }
}

