/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.PriceSettingFieldEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgSelectRespVo;
import com.biz.crm.nebular.mdm.priceconditiongroup.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchQueryVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.priceconditiongroup.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.priceconditiongroup.service.IMdmPriceConditionGroupRelFieldService;
import com.biz.crm.priceconditiontype.service.IMdmPriceConditionTypeRelGroupService;
import com.biz.crm.pricesetting.mapper.MdmPriceSettingMapper;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.pricesetting.service.impl.MdmPriceSettingServiceHelper;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DateUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPriceSettingServiceExpandImpl"})
public class MdmPriceSettingServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPriceSettingMapper, MdmPriceSettingEntity>
implements IMdmPriceSettingService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingServiceImpl.class);
    @Resource
    private MdmPriceSettingMapper mdmPriceSettingMapper;
    @Resource
    private MdmPriceSettingServiceHelper mdmPriceSettingServiceHelper;
    @Resource
    private MdmProductService mdmProductService;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private IMdmPriceConditionGroupRelFieldService mdmPriceConditionGroupRelFieldService;
    private final String DATE_REGEX = "^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))$";
    @Resource
    private IMdmPriceConditionTypeRelGroupService mdmPriceConditionTypeRelGroupService;

    @Override
    @CrmDictMethod
    public PageResult<MdmPriceSettingRespVo> findList(MdmPriceSettingReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPriceSettingRespVo> list = this.mdmPriceSettingMapper.findList((Page<MdmPriceSettingRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @CrmDictMethod
    public MdmPriceSettingRespVo query(MdmPriceSettingReqVo reqVo) {
        List list;
        MdmProductRespVo mdmProductRespVo;
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u67e5\u8be2\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPriceSettingEntity mdmPriceSettingEntity = (MdmPriceSettingEntity)((Object)this.mdmPriceSettingMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isEmpty((Object)((Object)mdmPriceSettingEntity))) {
            return null;
        }
        MdmPriceSettingRespVo mdmPriceSettingRespVo = (MdmPriceSettingRespVo)CrmBeanUtil.copy((Object)((Object)mdmPriceSettingEntity), MdmPriceSettingRespVo.class);
        if (StringUtils.isNotEmpty((String)mdmPriceSettingRespVo.getProductCode()) && !ObjectUtils.isEmpty((Object)(mdmProductRespVo = this.mdmProductService.detail(null, mdmPriceSettingRespVo.getProductCode())))) {
            mdmPriceSettingRespVo.setMdmProductRespVo(mdmProductRespVo);
        }
        ArrayList mdmPriceConditionGroupRelFieldRespVoList = new ArrayList();
        if (StringUtils.isNotEmpty((String)mdmPriceSettingEntity.getConditionGroupCode()) && (list = ((LambdaQueryChainWrapper)this.mdmPriceConditionGroupRelFieldService.lambdaQuery().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)mdmPriceSettingEntity.getConditionGroupCode())).select(new SFunction[]{MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, MdmPriceConditionGroupRelFieldEntity::getFieldCode, MdmPriceConditionGroupRelFieldEntity::getFieldName}).list()) != null) {
            mdmPriceConditionGroupRelFieldRespVoList.addAll(CrmBeanUtil.copyList((List)list, MdmPriceConditionGroupRelFieldRespVo.class));
        }
        mdmPriceSettingRespVo.setMdmPriceConditionGroupRelFieldRespVos(mdmPriceConditionGroupRelFieldRespVoList);
        return mdmPriceSettingRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    public Boolean checkDate(MdmPriceSettingReqVo mdmPriceSettingReqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(mdmPriceSettingReqVo);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"condition_type_code", (Object)mdmPriceSettingReqVo.getConditionTypeCode());
        wrapper.eq((Object)"condition_group_code", (Object)mdmPriceSettingReqVo.getConditionGroupCode());
        this.mdmPriceSettingServiceHelper.setFieldCondition((QueryWrapper<MdmPriceSettingEntity>)wrapper, mdmPriceSettingReqVo);
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectList((Wrapper)wrapper);
        boolean flag = false;
        if (CollectionUtil.listNotEmpty((List)mdmPriceSettingEntities)) {
            long dateStart = DateUtil.str2Date((String)mdmPriceSettingReqVo.getBeginDate().trim().concat(" ").concat(mdmPriceSettingReqVo.getBeginDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
            long dateEnd = DateUtil.str2Date((String)mdmPriceSettingReqVo.getEndDate().trim().concat(" ").concat(mdmPriceSettingReqVo.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
            for (MdmPriceSettingEntity entity : mdmPriceSettingEntities) {
                if (StringUtils.isNotEmpty((String)mdmPriceSettingReqVo.getId()) && mdmPriceSettingReqVo.getId().equalsIgnoreCase(entity.getId())) continue;
                long oldStart = DateUtil.str2Date((String)entity.getBeginDate().trim().concat(" ").concat(entity.getBeginDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
                long oldEnd = DateUtil.str2Date((String)entity.getEndDate().trim().concat(" ").concat(entity.getEndDateSecond()), (SimpleDateFormat)DateUtil.datetimeFormat).getTime();
                if (dateEnd < oldStart || dateStart > oldEnd) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPriceSettingReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)"\u5220\u9664\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            this.mdmPriceSettingMapper.deleteBatchIds(reqVo.getIds());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPriceSettingReqVo reqVo) {
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            mdmPriceSettingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmPriceSettingEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPriceSettingReqVo reqVo) {
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            mdmPriceSettingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmPriceSettingEntities);
    }

    @Override
    public Map<String, BigDecimal> findPriceByGoodsAndCusCode(List<String> goodsCodes, String cusCodes) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        if (org.springframework.util.CollectionUtils.isEmpty(goodsCodes)) {
            return reMap;
        }
        for (String goodsCode : goodsCodes) {
            reMap.put(goodsCode, BigDecimal.ONE);
        }
        return reMap;
    }

    @Override
    public List<MdmCustomerMsgSelectRespVo> findCustomerSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return this.mdmCustomerMsgService.list(mdmCustomerMsgReqVo);
    }

    @Override
    public List<MdmProductRespVo> findProductSelectList(MdmProductReqVo mdmProductReqVo) {
        return CrmBeanUtil.copyList((List)this.mdmProductService.list(), MdmProductRespVo.class);
    }

    @Override
    public Map<String, Map<String, MdmPriceResp>> search(MdmPriceSearchReqVo mdmPriceSearchReqVo) {
        List productCodeList = mdmPriceSearchReqVo.getProductCodeList();
        String customerCode = mdmPriceSearchReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List conditionTypeCodeList = mdmPriceSearchReqVo.getConditionTypeCodeList();
        Assert.notEmpty((Collection)conditionTypeCodeList, (String)"\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.mdmCustomerMsgService.query(null, customerCode);
        log.info("[\u4ef7\u683c\u7ef4\u62a4][\u8be2\u4ef7\u5ba2\u6237\u4fe1\u606f]:{}", (Object)mdmCustomerMsgRespVo);
        if (CollectionUtils.isEmpty((Collection)productCodeList) || mdmCustomerMsgRespVo == null || StringUtils.isEmpty((String)mdmCustomerMsgRespVo.getCustomerName())) {
            return Collections.emptyMap();
        }
        String searchTime = mdmPriceSearchReqVo.getSearchTime();
        if (StringUtils.isEmpty((String)searchTime)) {
            searchTime = LocalDate.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        } else {
            Assert.isTrue((boolean)searchTime.matches("^((([0-9]{3}[1-9]|[0-9]{2}[1-9][0-9]{1}|[0-9]{1}[1-9][0-9]{2}|[1-9][0-9]{3})-(((0[13578]|1[02])-(0[1-9]|[12][0-9]|3[01]))|((0[469]|11)-(0[1-9]|[12][0-9]|30))|(02-(0[1-9]|[1][0-9]|2[0-8]))))|((([0-9]{2})(0[48]|[2468][048]|[13579][26])|((0[48]|[2468][048]|[3579][26])00))-02-29))$"), (String)"\u65f6\u95f4\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        HashMap<String, Map<String, MdmPriceResp>> priceMap = new HashMap<String, Map<String, MdmPriceResp>>(productCodeList.size());
        for (String conditionTypeCode : conditionTypeCodeList) {
            MdmPriceSearchQueryVo mdmPriceSearchQueryVo = new MdmPriceSearchQueryVo();
            mdmPriceSearchQueryVo.setProductCodeList(productCodeList);
            mdmPriceSearchQueryVo.setConditionTypeCode(conditionTypeCode);
            mdmPriceSearchQueryVo.setSearchTime(searchTime);
            String conditionGroupCode = this.mdmPriceConditionTypeRelGroupService.groupPriorityList(conditionTypeCode);
            if (StringUtils.isEmpty((String)conditionGroupCode)) continue;
            switch (PriceSettingFieldEnum.match((String)conditionGroupCode)) {
                case CUSTOMER_CODE: {
                    mdmPriceSearchQueryVo.setCustomerCode(customerCode);
                    break;
                }
                case ORG_CODE: {
                    mdmPriceSearchQueryVo.setOrgCode(mdmCustomerMsgRespVo.getOrgCode());
                    break;
                }
                case CHANNEL: {
                    mdmPriceSearchQueryVo.setChannel(mdmCustomerMsgRespVo.getChannel());
                    break;
                }
            }
            List<MdmPriceResp> list = this.mdmPriceSettingMapper.search(mdmPriceSearchQueryVo);
            log.info("[\u4ef7\u683c\u7ef4\u62a4][\u8be2\u4ef7\u7ed3\u679c]:{}", list);
            if (CollectionUtils.isEmpty(list)) continue;
            Map<String, Map<String, MdmPriceResp>> currentPriceMap = list.stream().collect(Collectors.groupingBy(MdmPriceResp::getConditionTypeCode, Collectors.groupingBy(MdmPriceResp::getProductCode, Collectors.collectingAndThen(Collectors.toList(), x -> (MdmPriceResp)x.get(0)))));
            priceMap.putAll(currentPriceMap);
        }
        return priceMap;
    }
}

