/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.role.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionPageReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmUnbindRoleRelationPositionReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRelationPositionPageRespVo;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.role.mapper.MdmRoleRelationPositionMapper;
import com.biz.crm.role.service.MdmRoleRelationPositionService;
import com.biz.crm.util.PageUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class MdmRoleRelationPositionServiceImpl
implements MdmRoleRelationPositionService {
    @Resource
    private MdmRoleRelationPositionMapper mdmRoleRelationPositionMapper;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmPositionService mdmPositionService;

    @Override
    public PageResult<MdmRoleRelationPositionPageRespVo> findPositionNotRelateAnyRoleList(MdmRoleRelationPositionPageReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmRoleRelationPositionPageRespVo> data = this.mdmRoleRelationPositionMapper.findPositionNotRelateAnyRoleList((Page<MdmRoleRelationPositionPageRespVo>)page, reqVo);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmRoleRelationPositionPageRespVo> findPositionNotRelateCurRoleList(MdmRoleRelationPositionPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmRoleRelationPositionPageRespVo> data = this.mdmRoleRelationPositionMapper.findPositionNotRelateCurRoleList((Page<MdmRoleRelationPositionPageRespVo>)page, reqVo);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmRoleRelationPositionPageRespVo> findPositionHasRelateCurRoleList(MdmRoleRelationPositionPageReqVo reqVo) {
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmRoleRelationPositionPageRespVo> data = this.mdmRoleRelationPositionMapper.findPositionHasRelateCurRoleList((Page<MdmRoleRelationPositionPageRespVo>)page, reqVo);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void positionRelationRole(MdmRoleRelationPositionReqVo reqVo) {
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getPositionCodeList(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        this.mdmPositionRoleService.addPosition(reqVo.getPositionCodeList(), reqVo.getRoleCode());
        this.mdmPositionService.updatePositionRoleRedundancy(reqVo.getPositionCodeList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceBindRole(MdmRoleRelationPositionReqVo reqVo) {
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Assert.hasText((String)reqVo.getOriginRoleCode(), (String)"\u7f3a\u5931\u539f\u89d2\u8272\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getPositionCodeList(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        this.mdmPositionRoleService.replacePositionsRole(reqVo.getPositionCodeList(), reqVo.getOriginRoleCode(), reqVo.getRoleCode());
        this.mdmPositionService.updatePositionRoleRedundancy(reqVo.getPositionCodeList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbindRelationRole(MdmUnbindRoleRelationPositionReqVo reqVo) {
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getPositionCodeList(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        this.mdmPositionRoleService.removeRolePositions(reqVo.getRoleCode(), reqVo.getPositionCodeList());
        this.mdmPositionService.updatePositionRoleRedundancy(reqVo.getPositionCodeList());
    }
}

