/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.MdmCodeEnum;
import com.biz.crm.mdm.org.MdmOrgFeign;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeFileReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeMiniReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReadReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReceivingReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeFileRespVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeReadRespVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.notice.mapper.MdmNoticeFileMapper;
import com.biz.crm.notice.mapper.MdmNoticeMapper;
import com.biz.crm.notice.mapper.MdmNoticeReadMapper;
import com.biz.crm.notice.mapper.MdmNoticeReceivingMapper;
import com.biz.crm.notice.model.MdmNoticeEntity;
import com.biz.crm.notice.model.MdmNoticeFileEntity;
import com.biz.crm.notice.model.MdmNoticeReceivingEntity;
import com.biz.crm.notice.service.IMdmNoticeFileService;
import com.biz.crm.notice.service.IMdmNoticeReadService;
import com.biz.crm.notice.service.IMdmNoticeReceivingService;
import com.biz.crm.notice.service.IMdmNoticeService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.CrmDateUtils;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmNoticeServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class MdmNoticeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmNoticeMapper, MdmNoticeEntity>
implements IMdmNoticeService {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeServiceImpl.class);
    @Resource
    private MdmNoticeMapper mdmNoticeMapper;
    @Resource
    private MdmNoticeFileMapper noticeFileMapper;
    @Resource
    private MdmNoticeReceivingMapper noticeReceivingMapper;
    @Resource
    private MdmNoticeReadMapper mdmNoticeReadMapper;
    @Autowired
    private IMdmNoticeFileService iMdmNoticeFileService;
    @Autowired
    private IMdmNoticeReceivingService iMdmNoticeReceivingService;
    @Autowired
    private IMdmNoticeReadService iMdmNoticeReadService;
    @Resource
    private MdmOrgFeign mdmOrgFeign;

    @Override
    public PageResult<MdmNoticeRespVo> findList(MdmNoticeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmNoticeRespVo> list = this.mdmNoticeMapper.findList((Page<MdmNoticeRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List noticeCodes = list.stream().map(MdmNoticeRespVo::getNoticeCode).collect(Collectors.toList());
            MdmNoticeReadReqVo readReqVo = new MdmNoticeReadReqVo();
            readReqVo.setNoticeCodes(noticeCodes);
            readReqVo.setPageSize(Integer.valueOf(-1));
            List readRespVoList = this.iMdmNoticeReadService.findList(readReqVo).getData();
            Map<String, List<MdmNoticeReadRespVo>> readRespMap = readRespVoList.stream().collect(Collectors.groupingBy(MdmNoticeReadRespVo::getNoticeCode));
            for (MdmNoticeRespVo noticeVo : list) {
                noticeVo.setNoticeOrg(noticeVo.getCreateOrgName());
                noticeVo.setNoticeDate(noticeVo.getCreateDate());
                noticeVo.setEnableStatusName(CrmEnableStatusEnum.getDesc((String)noticeVo.getEnableStatus()));
                List<MdmNoticeReadRespVo> noticeReadRespVos = readRespMap.get(noticeVo.getNoticeCode());
                if (noticeReadRespVos != null && noticeReadRespVos.size() > 0) {
                    noticeVo.setVisitNum(Integer.valueOf(noticeReadRespVos.size()));
                    Set readusers = noticeReadRespVos.stream().map(MdmNoticeReadRespVo::getUserName).collect(Collectors.toSet());
                    noticeVo.setReadUserNum(Integer.valueOf(readusers.size()));
                    continue;
                }
                noticeVo.setVisitNum(Integer.valueOf(0));
                noticeVo.setReadUserNum(Integer.valueOf(0));
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public PageResult<MdmNoticeRespVo> findListByMiniPrg(MdmNoticeMiniReqVo reqVo) {
        Map<String, Object> map;
        UserRedis user = UserUtils.getUser();
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        reqVo.setUserName(user.getUsername());
        reqVo.setThisCode(user.getOrgcode());
        reqVo.setThisPost(user.getPoscode());
        List<MdmNoticeRespVo> miniPrgList = this.mdmNoticeMapper.findListMiniPrg((Page<MdmNoticeRespVo>)page, reqVo);
        ArrayList<String> notices = new ArrayList<String>();
        for (MdmNoticeRespVo mdmNoticeRespVo : miniPrgList) {
            notices.add(mdmNoticeRespVo.getNoticeCode());
        }
        if (!CollectionUtil.listEmpty(notices) && !(map = this.mdmNoticeReadMapper.findIsItRight(notices, reqVo.getUserName(), reqVo.getThisPost(), user.getOrgcode())).isEmpty()) {
            for (MdmNoticeRespVo mdmNoticeRespVo : miniPrgList) {
                if (map.containsKey(mdmNoticeRespVo.getNoticeCode())) {
                    mdmNoticeRespVo.setHaveRead("1");
                    continue;
                }
                mdmNoticeRespVo.setHaveRead("0");
            }
        }
        return PageResult.builder().data(miniPrgList).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmNoticeRespVo queryMiniPrgNew() {
        MdmNoticeMiniReqVo vo = new MdmNoticeMiniReqVo();
        vo.setPageNum(Integer.valueOf(0));
        vo.setPageSize(Integer.valueOf(1));
        List data = this.findListByMiniPrg(vo).getData();
        if (CollectionUtil.listEmpty((List)data)) {
            return new MdmNoticeRespVo();
        }
        return (MdmNoticeRespVo)data.get(0);
    }

    @Override
    public MdmNoticeRespVo queryMiniPrg(String id) {
        AssertUtils.isNotEmpty((String)id, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeRespVo mdmNoticeRespVo = this.mdmNoticeMapper.queyMimiPrg(id);
        String noticeCode = mdmNoticeRespVo.getNoticeCode();
        List<MdmNoticeFileRespVo> miniList = this.noticeFileMapper.findMiniList(noticeCode);
        if (!CollectionUtil.listEmpty(miniList)) {
            miniList.forEach(m -> m.setFileSuffix(StringUtils.isEmpty((String)m.getFileName()) ? "" : m.getFileName().substring(m.getFileName().lastIndexOf(".") + 1)));
        }
        mdmNoticeRespVo.setNoticeFileRespVos(miniList);
        return mdmNoticeRespVo;
    }

    @Override
    public MdmNoticeRespVo queryMiniPrgByUpBelow(String id, String upBelow) {
        AssertUtils.isNotEmpty((String)upBelow, (String)"\u7ffb\u9875\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        MdmOrgReqVo mdmOrgReqVo = new MdmOrgReqVo();
        mdmOrgReqVo.setOrgCode(user.getOrgcode());
        String noticeId = this.mdmNoticeMapper.queryMinPrgUpOrBelow(id, upBelow, user.getOrgcode());
        if (StringUtils.isEmpty((String)noticeId)) {
            if ("0".equals(upBelow)) {
                AssertUtils.isNotEmpty((String)noticeId, (String)"\u5df2\u7ecf\u662f\u6700\u540e\u4e00\u6761\u4e86");
            } else {
                AssertUtils.isNotEmpty((String)noticeId, (String)"\u5df2\u7ecf\u662f\u7b2c\u4e00\u6761\u4e86");
            }
        }
        MdmNoticeRespVo mdmNoticeRespVo = this.queryMiniPrg(noticeId);
        List<MdmNoticeFileRespVo> miniList = this.noticeFileMapper.findMiniList(mdmNoticeRespVo.getNoticeCode());
        mdmNoticeRespVo.setNoticeFileRespVos(miniList);
        return mdmNoticeRespVo;
    }

    @Override
    public MdmNoticeRespVo query(MdmNoticeReqVo reqVo) {
        if (null == reqVo || StringUtils.isEmpty((String)reqVo.getId()) && CollectionUtil.listEmpty((List)reqVo.getIds())) {
            return new MdmNoticeRespVo();
        }
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new MdmNoticeRespVo();
        }
        MdmNoticeRespVo mdmNoticeRespVo = (MdmNoticeRespVo)list.get(0);
        MdmNoticeFileReqVo fileReqVo = new MdmNoticeFileReqVo();
        fileReqVo.setNoticeCode(mdmNoticeRespVo.getNoticeCode());
        fileReqVo.setPageSize(Integer.valueOf(-1));
        List fileRespVos = this.iMdmNoticeFileService.findList(fileReqVo).getData();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)fileRespVos)) {
            mdmNoticeRespVo.setNoticeFileRespVos(fileRespVos);
        }
        MdmNoticeReceivingReqVo receivingReqVo = new MdmNoticeReceivingReqVo();
        receivingReqVo.setNoticeCode(mdmNoticeRespVo.getNoticeCode());
        receivingReqVo.setPageSize(Integer.valueOf(-1));
        List receivingRespVos = this.iMdmNoticeReceivingService.findList(receivingReqVo).getData();
        mdmNoticeRespVo.setNoticeReceivingRespVos(receivingRespVos);
        return mdmNoticeRespVo;
    }

    public void saveCheck(MdmNoticeReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getNoticeTitle(), (String)"\u8bf7\u8f93\u5165\u516c\u544a\u6807\u9898");
        AssertUtils.isNotEmpty((String)reqVo.getNoticeType(), (String)"\u8bf7\u9009\u62e9\u516c\u544a\u7c7b\u578b");
        AssertUtils.isNotEmpty((String)reqVo.getBeginDate(), (String)"\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)reqVo.getNoticeContent(), (String)"\u8bf7\u8f93\u5165\u516c\u544a\u5185\u5bb9");
        AssertUtils.isNotEmpty((Collection)reqVo.getNoticeReceivingReqVos(), (String)"\u8bf7\u9009\u62e9\u516c\u544a\u8303\u56f4");
        LocalDateTime beginDate = null;
        try {
            beginDate = LocalDateTime.parse(reqVo.getBeginDate(), CrmDateUtils.yyyyMMddHHmmss);
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        AssertUtils.isNotEmpty((String)reqVo.getEndDate(), (String)"\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a");
        LocalDateTime endDate = null;
        try {
            endDate = LocalDateTime.parse(reqVo.getEndDate(), CrmDateUtils.yyyyMMddHHmmss);
        }
        catch (Exception e) {
            throw new BusinessException("\u6709\u6548\u7ed3\u675f\u65f6\u95f4\u683c\u5f0f\u9519\u8bef");
        }
        if (!beginDate.isBefore(endDate)) {
            throw new BusinessException("\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u6709\u6548\u7ed3\u675f\u65f6\u95f4");
        }
        AssertUtils.isNotEmpty((String)reqVo.getNoticeContent(), (String)"\u516c\u544a\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmNoticeReqVo reqVo) {
        this.saveCheck(reqVo);
        MdmNoticeEntity entity = (MdmNoticeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmNoticeEntity.class));
        String code = CodeUtil.generateCode((String)MdmCodeEnum.NoticeCode.NOTICE_CODE.getVal());
        entity.setNoticeCode(code);
        entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        this.saveData(reqVo, entity);
    }

    public void saveData(MdmNoticeReqVo reqVo, MdmNoticeEntity entity) {
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getNoticeReceivingReqVos())) {
            List receivingEntityList = reqVo.getNoticeReceivingReqVos().stream().map(o -> {
                MdmNoticeReceivingEntity receivingEntity = new MdmNoticeReceivingEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)receivingEntity));
                receivingEntity.setId(null);
                receivingEntity.setNoticeCode(entity.getNoticeCode());
                return receivingEntity;
            }).collect(Collectors.toList());
            this.iMdmNoticeReceivingService.saveBatch(receivingEntityList);
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getNoticeFileReqVos())) {
            List fileEntityList = reqVo.getNoticeFileReqVos().stream().map(o -> {
                MdmNoticeFileEntity fileEntity = new MdmNoticeFileEntity();
                CrmBeanUtil.copyProperties((Object)o, (Object)((Object)fileEntity));
                fileEntity.setId(null);
                fileEntity.setNoticeCode(entity.getNoticeCode());
                return fileEntity;
            }).collect(Collectors.toList());
            this.iMdmNoticeFileService.saveBatch(fileEntityList);
        }
    }

    @Override
    public void update(MdmNoticeReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmNoticeEntity entity = (MdmNoticeEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (Objects.isNull((Object)entity)) {
            throw new BusinessException("\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.saveCheck(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.deleteBatchDate(reqVo);
        this.saveData(reqVo, entity);
    }

    @Override
    public void deleteBatch(final List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmNoticeReqVo reqVo = new MdmNoticeReqVo(){
            {
                this.setIds(ids);
            }
        };
        reqVo.setPageSize(Integer.valueOf(-1));
        List list = this.findList(reqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException("\u516c\u544a\u6570\u636e\u4e0d\u5b58\u5728");
        }
        this.mdmNoticeMapper.deleteProductsByParams(reqVo);
        List noticeCodes = list.stream().map(MdmNoticeRespVo::getNoticeCode).collect(Collectors.toList());
        reqVo.setNoticeCodes(noticeCodes);
        this.deleteBatchDate(reqVo);
    }

    public void deleteBatchDate(MdmNoticeReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getNoticeCode()) && CollectionUtil.listEmpty((List)reqVo.getNoticeCodes())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmNoticeFileReqVo mdmNoticeFileReqVo = new MdmNoticeFileReqVo();
        mdmNoticeFileReqVo.setNoticeCode(reqVo.getNoticeCode());
        mdmNoticeFileReqVo.setNoticeCodes(reqVo.getNoticeCodes());
        this.noticeFileMapper.deleteProductsByParams(mdmNoticeFileReqVo);
        MdmNoticeReceivingReqVo mdmNoticeReceivingReqVo = new MdmNoticeReceivingReqVo();
        mdmNoticeReceivingReqVo.setNoticeCode(reqVo.getNoticeCode());
        mdmNoticeReceivingReqVo.setNoticeCodes(reqVo.getNoticeCodes());
        this.noticeReceivingMapper.deleteProductsByParams(mdmNoticeReceivingReqVo);
    }

    @Override
    public void enableBatch(List<String> ids) {
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeEntities = this.mdmNoticeMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeEntities)) {
            mdmNoticeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeEntities);
    }

    @Override
    public void disableBatch(List<String> ids) {
        MdmNoticeReqVo reqVo = new MdmNoticeReqVo();
        if (!CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List mdmNoticeEntities = this.mdmNoticeMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmNoticeEntities)) {
            mdmNoticeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmNoticeEntities);
    }
}

