/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.position.mapper.MdmPositionRoleMapper;
import com.biz.crm.position.model.MdmPositionRoleEntity;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPositionRoleServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class MdmPositionRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionRoleMapper, MdmPositionRoleEntity>
implements MdmPositionRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionRoleServiceImpl.class);
    @Resource
    private MdmRoleService mdmRoleService;

    @Override
    public List<String> findRoleCodeByPosition(List<String> positionCodeList) {
        if (CollectionUtils.isEmpty(positionCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionRoleEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionRoleEntity::getRoleCode}).list().stream().map(MdmPositionRoleEntity::getRoleCode).collect(Collectors.toList());
    }

    @Override
    public List<String> findPositionCodeCodeByRole(List<String> roleCodeList) {
        if (CollectionUtils.isEmpty(roleCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionRoleEntity::getRoleCode, roleCodeList)).select(new SFunction[]{MdmPositionRoleEntity::getPositionCode}).list().stream().map(MdmPositionRoleEntity::getPositionCode).collect(Collectors.toList());
    }

    @Override
    public void addRole(List<String> roleCodeList, String positionCode) {
        Assert.notEmpty(roleCodeList, (String)"\u89d2\u8272\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)positionCode, (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List collect = roleCodeList.stream().map(x -> {
            MdmPositionRoleEntity mdmPositionRoleEntity = new MdmPositionRoleEntity();
            mdmPositionRoleEntity.setPositionCode(positionCode);
            mdmPositionRoleEntity.setRoleCode((String)x);
            mdmPositionRoleEntity.setId(x + positionCode);
            return mdmPositionRoleEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }

    @Override
    public void addPosition(List<String> positionCodeList, String roleCode) {
        Assert.notEmpty(positionCodeList, (String)"\u804c\u4f4d\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List collect = positionCodeList.stream().map(x -> {
            MdmPositionRoleEntity mdmPositionRoleEntity = new MdmPositionRoleEntity();
            mdmPositionRoleEntity.setPositionCode((String)x);
            mdmPositionRoleEntity.setRoleCode(roleCode);
            mdmPositionRoleEntity.setId(roleCode + x);
            return mdmPositionRoleEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }

    @Override
    public void removePositionCode(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removePositionCodes(Collections.singletonList(positionCode));
        }
    }

    @Override
    public void removePositionCodes(List<String> positionCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionRoleEntity::getPositionCode, positionCodes)).remove();
        }
    }

    @Override
    public void removeRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty((String)roleCode)) {
            this.removeRoleCodes(Collections.singletonList(roleCode));
        }
    }

    @Override
    public void removeRoleCodes(List<String> roleCodes) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionRoleEntity::getRoleCode, roleCodes)).remove();
        }
    }

    @Override
    public void removeRelation(List<String> ids) {
        if (CollectionUtil.listNotEmptyNotSizeZero(ids)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).remove();
        }
    }

    @Override
    public void removeRolePositions(String roleCode, List<String> positionCodeList) {
        if (StringUtils.isNotEmpty((String)roleCode) && CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionRoleEntity::getRoleCode, (Object)roleCode)).in(MdmPositionRoleEntity::getPositionCode, positionCodeList)).remove();
        }
    }

    @Override
    public void replacePositionsRole(List<String> positionCodeList, String originRoleCode, String roleCode) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && StringUtils.isNotEmpty((String)originRoleCode) && StringUtils.isNotEmpty((String)roleCode)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionRoleEntity::getPositionCode, positionCodeList)).eq(MdmPositionRoleEntity::getRoleCode, (Object)originRoleCode)).remove();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionRoleEntity::getPositionCode, positionCodeList)).eq(MdmPositionRoleEntity::getRoleCode, (Object)roleCode)).remove();
            this.addPosition(positionCodeList, roleCode);
        }
    }

    @Override
    public List<String> getRoleRelationPositionCodeList(List<String> roleCodes) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodes) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionRoleEntity::getRoleCode, roleCodes)).select(new SFunction[]{MdmPositionRoleEntity::getPositionCode}).list()))) {
            return list.stream().map(MdmPositionRoleEntity::getPositionCode).distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmRoleRespVo> getPositionRoleList(String positionCode) {
        List list;
        List positionRoleEntityList;
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionRoleEntityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionRoleEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{MdmPositionRoleEntity::getRoleCode}).list())) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)positionRoleEntityList.stream().map(MdmPositionRoleEntity::getRoleCode).collect(Collectors.toList()))).list()))) {
            return CrmBeanUtil.copyList((List)list, MdmRoleRespVo.class);
        }
        return new ArrayList<MdmRoleRespVo>();
    }

    @Override
    public Map<String, List<String>> getPositionRoleCodeGroupByPositionCodeList(List<String> positionCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionRoleEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionRoleEntity::getPositionCode, MdmPositionRoleEntity::getRoleCode}).list()))) {
            return list.stream().collect(Collectors.groupingBy(MdmPositionRoleEntity::getPositionCode, Collectors.mapping(MdmPositionRoleEntity::getRoleCode, Collectors.toList())));
        }
        return new HashMap<String, List<String>>(16);
    }

    @Override
    public Map<String, List<MdmRoleRespVo>> getPositionRoleGroupByPositionCodeList(List<String> positionCodeList) {
        List list;
        HashMap<String, List<MdmRoleRespVo>> map = new HashMap<String, List<MdmRoleRespVo>>(16);
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionRoleEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionRoleEntity::getPositionCode, MdmPositionRoleEntity::getRoleCode}).list()))) {
            List bpmRoleCodeList = list.stream().map(MdmPositionRoleEntity::getRoleCode).collect(Collectors.toList());
            List bpmRoleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, bpmRoleCodeList)).list();
            Map<String, MdmRoleRespVo> bpmRoleMap = bpmRoleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, v -> (MdmRoleRespVo)CrmBeanUtil.copy((Object)v, MdmRoleRespVo.class)));
            Map groupMap = list.stream().collect(Collectors.groupingBy(MdmPositionRoleEntity::getPositionCode, Collectors.mapping(MdmPositionRoleEntity::getRoleCode, Collectors.toList())));
            for (Map.Entry entry : groupMap.entrySet()) {
                ArrayList<MdmRoleRespVo> roleList = new ArrayList<MdmRoleRespVo>();
                for (String item : entry.getValue()) {
                    if (!bpmRoleMap.containsKey(item)) continue;
                    roleList.add(bpmRoleMap.get(item));
                }
                map.put(entry.getKey(), roleList);
            }
        }
        return map;
    }
}

