/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.region.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.constant.RegionLevelEnum;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectTransportRespVo;
import com.biz.crm.region.mapper.MdmRegionMapper;
import com.biz.crm.region.model.MdmRegionEntity;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmRegionServiceExpandImpl"})
public class MdmRegionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmRegionMapper, MdmRegionEntity>
implements MdmRegionService {
    private static final Logger log = LoggerFactory.getLogger(MdmRegionServiceImpl.class);
    @Resource
    private MdmRegionMapper mdmRegionMapper;

    @Override
    public PageResult<MdmRegionRespVo> pageList(MdmRegionReqVo mdmRegionReqVo) {
        if (StringUtils.isNotEmpty((String)mdmRegionReqVo.getParentCode())) {
            List<MdmRegionRespVo> list = this.mdmRegionMapper.pageList(null, new MdmRegionReqVo().setParentCode(mdmRegionReqVo.getParentCode()));
            return PageResult.builder().data(list).count(Long.valueOf(list != null ? (long)list.size() : 0L)).build();
        }
        if (StringUtils.isEmpty((String)mdmRegionReqVo.getRegionCode()) && StringUtils.isEmpty((String)mdmRegionReqVo.getRegionName())) {
            List topRegion = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmRegionEntity::getParentCode)).or()).eq(MdmRegionEntity::getParentCode, (Object)"")).list();
            ArrayList list = new ArrayList();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)topRegion)) {
                list.addAll(CrmBeanUtil.copyList((List)topRegion, MdmRegionRespVo.class));
            }
            return PageResult.builder().data(list).count(Long.valueOf(list != null ? (long)list.size() : 0L)).build();
        }
        Page page = PageUtil.buildPage((Integer)mdmRegionReqVo.getPageNum(), (Integer)mdmRegionReqVo.getPageSize());
        List<MdmRegionRespVo> list = this.mdmRegionMapper.pageList((Page<MdmRegionRespVo>)page, mdmRegionReqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setHasChild(Boolean.valueOf(false)));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmRegionRespVo> findList(MdmRegionReqVo reqVo) {
        return this.mdmRegionMapper.findList(reqVo);
    }

    @Override
    public MdmRegionRespVo query(String id, String regionCode) {
        return this.mdmRegionMapper.query(id, regionCode);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmRegionReqVo reqVo) {
        String regionCode = this.valid(reqVo);
        reqVo.setHasChild(Boolean.valueOf(false));
        MdmRegionEntity one = (MdmRegionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getRegionCode, (Object)regionCode)).last(DatabaseTypeUtil.SEGMENT)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u5f53\u524d\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
            MdmRegionEntity parent = (MdmRegionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getRegionCode, (Object)reqVo.getParentCode())).select(new SFunction[]{BaseIdEntity::getId, MdmRegionEntity::getHasChild}).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u533a\u57df\u4e0d\u5b58\u5728");
            Boolean hasChild = parent.getHasChild();
            if (hasChild == null || !hasChild.booleanValue()) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)parent.getId())).set(MdmRegionEntity::getHasChild, (Object)true)).update();
            }
        }
        MdmRegionEntity entity = (MdmRegionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmRegionEntity.class));
        this.save((Object)entity);
    }

    protected String valid(MdmRegionReqVo reqVo) {
        String regionCode = reqVo.getRegionCode();
        Assert.hasText((String)regionCode, (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String regionName = reqVo.getRegionName();
        Assert.hasText((String)regionName, (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        return regionCode;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmRegionReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmRegionEntity entity = (MdmRegionEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u533a\u57df\u4e0d\u5b58\u5728");
        MdmRegionEntity one = (MdmRegionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)id)).eq(MdmRegionEntity::getRegionCode, (Object)reqVo.getRegionCode())).last(DatabaseTypeUtil.SEGMENT)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u5f53\u524d\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        this.updateChildMark(reqVo, entity);
        this.updateSubRegionLevel(reqVo, entity);
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmRegionEntity.class));
    }

    protected void updateSubRegionLevel(MdmRegionReqVo reqVo, MdmRegionEntity entity) {
        String regionLevel = reqVo.getRegionLevel();
        if (!regionLevel.equals(entity.getRegionLevel())) {
            int level = Integer.parseInt(regionLevel);
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)reqVo.getRegionCode())).select(new SFunction[]{BaseIdEntity::getId, MdmRegionEntity::getHasChild, CrmBaseEntity::getEnableStatus}).list();
            while (!CollectionUtils.isEmpty((Collection)list)) {
                ++level;
                for (MdmRegionEntity mdmRegionEntity : list) {
                    mdmRegionEntity.setRegionLevel(String.valueOf(level));
                }
                this.updateBatchById(list);
                list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmRegionEntity::getParentCode, (Collection)list.stream().map(MdmRegionEntity::getRegionCode).collect(Collectors.toList()))).select(new SFunction[]{BaseIdEntity::getId, MdmRegionEntity::getHasChild, CrmBaseEntity::getEnableStatus}).list();
            }
        }
    }

    protected void updateChildMark(MdmRegionReqVo reqVo, MdmRegionEntity entity) {
        String id = reqVo.getId();
        String parentCode = entity.getParentCode();
        if (StringUtils.isEmpty((String)parentCode)) {
            if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
                reqVo.setHasChild(Boolean.valueOf(true));
            }
        } else if (!StringUtils.isEmpty((String)reqVo.getParentCode()) && !reqVo.getParentCode().equals(parentCode)) {
            Integer newCount;
            Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)parentCode)).ne(BaseIdEntity::getId, (Object)id)).count();
            if (count == null || count == 0) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRegionEntity::getRegionCode, (Object)parentCode)).set(MdmRegionEntity::getHasChild, (Object)false)).update();
            }
            if ((newCount = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)reqVo.getParentCode())).count()) != null && newCount > 0) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRegionEntity::getRegionCode, (Object)reqVo.getParentCode())).set(MdmRegionEntity::getHasChild, (Object)true)).update();
            }
        } else {
            Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmRegionEntity::getParentCode, (Object)parentCode)).ne(BaseIdEntity::getId, (Object)id)).count();
            if (count == null || count == 0) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmRegionEntity::getRegionCode, (Object)parentCode)).set(MdmRegionEntity::getHasChild, (Object)false)).update();
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmRegionReqVo reqVo) {
        List currentRegionCodeList;
        log.info("[\u884c\u653f\u533a\u57df][\u5220\u9664]:{}", (Object)reqVo.getIds());
        List ids = reqVo.getIds();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            return;
        }
        ArrayList regionCodeList = new ArrayList();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).select(new SFunction[]{MdmRegionEntity::getRegionCode}).list();
        while (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty(currentRegionCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getRegionCode())).map(MdmRegionEntity::getRegionCode).collect(Collectors.toList()))) {
            regionCodeList.addAll(currentRegionCodeList);
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmRegionEntity::getParentCode, currentRegionCodeList)).select(new SFunction[]{MdmRegionEntity::getRegionCode}).list();
        }
        if (!CollectionUtils.isEmpty(regionCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmRegionEntity::getRegionCode, regionCodeList)).remove();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmRegionSelectRespVo> select(MdmRegionReqVo mdmRegionReqVo) {
        String currentRegionLevel = mdmRegionReqVo.getCurrentRegionLevel();
        if (!StringUtils.isEmpty((String)currentRegionLevel)) {
            Assert.isTrue((boolean)currentRegionLevel.matches("^[0-9]+$"), (String)"\u533a\u57df\u5c42\u7ea7\u5fc5\u987b\u662f\u6570\u5b57");
            mdmRegionReqVo.setRegionLevel(String.valueOf(Integer.parseInt(currentRegionLevel) - 1));
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getId()), BaseIdEntity::getId, (Object)mdmRegionReqVo.getId())).in(!CollectionUtils.isEmpty((Collection)mdmRegionReqVo.getIds()), BaseIdEntity::getId, new Object[]{mdmRegionReqVo.getId()})).in(!CollectionUtils.isEmpty((Collection)mdmRegionReqVo.getRegionCodeList()), MdmRegionEntity::getRegionCode, (Collection)mdmRegionReqVo.getRegionCodeList())).like(!StringUtils.isEmpty((String)mdmRegionReqVo.getRegionCode()), MdmRegionEntity::getRegionCode, (Object)mdmRegionReqVo.getRegionCode())).like(!StringUtils.isEmpty((String)mdmRegionReqVo.getRegionName()), MdmRegionEntity::getRegionName, (Object)mdmRegionReqVo.getRegionName())).eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getRegionLevel()), MdmRegionEntity::getRegionLevel, (Object)mdmRegionReqVo.getRegionLevel())).eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getParentCode()), MdmRegionEntity::getParentCode, (Object)mdmRegionReqVo.getParentCode())).eq(!StringUtils.isEmpty((String)mdmRegionReqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)mdmRegionReqVo.getEnableStatus())).list();
        return CrmBeanUtil.copyList((List)list, MdmRegionSelectRespVo.class);
    }

    @Override
    public List<MdmRegionSelectRespVo> selectStartWithCountry(MdmRegionSelectReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            reqVo.setRegionLevel(null);
        } else {
            reqVo.setRegionLevel(RegionLevelEnum.COUNTRY.getCode());
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getRegionLevel()), MdmRegionEntity::getRegionLevel, (Object)reqVo.getRegionLevel())).eq(StringUtils.isNotEmpty((String)reqVo.getParentCode()), MdmRegionEntity::getParentCode, (Object)reqVo.getParentCode())).like(StringUtils.isNotEmpty((String)reqVo.getRegionName()), MdmRegionEntity::getRegionName, (Object)reqVo.getRegionName())).select(new SFunction[]{MdmRegionEntity::getRegionCode, MdmRegionEntity::getRegionName}).list();
        return CrmBeanUtil.copyList((List)list, MdmRegionSelectRespVo.class);
    }

    @Override
    public List<MdmRegionSelectRespVo> selectStartWithProvince(MdmRegionSelectReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            reqVo.setRegionLevel(null);
        } else {
            reqVo.setRegionLevel(RegionLevelEnum.PROVINCE.getCode());
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getRegionLevel()), MdmRegionEntity::getRegionLevel, (Object)reqVo.getRegionLevel())).eq(StringUtils.isNotEmpty((String)reqVo.getParentCode()), MdmRegionEntity::getParentCode, (Object)reqVo.getParentCode())).like(StringUtils.isNotEmpty((String)reqVo.getRegionName()), MdmRegionEntity::getRegionName, (Object)reqVo.getRegionName())).select(new SFunction[]{MdmRegionEntity::getRegionCode, MdmRegionEntity::getRegionName}).list();
        return CrmBeanUtil.copyList((List)list, MdmRegionSelectRespVo.class);
    }

    @Override
    public List<MdmRegionSelectRespVo> regionSelect(MdmRegionSelectReqVo reqVo) {
        List<MdmRegionSelectTransportRespVo> selectedList;
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getChildrenLevel())) {
            String regionLevel = RegionLevelEnum.getParentRegionLevel((String)reqVo.getChildrenLevel());
            if (StringUtils.isEmpty((String)regionLevel)) {
                return new ArrayList<MdmRegionSelectRespVo>();
            }
            reqVo.setRegionLevel(regionLevel);
        }
        ArrayList<MdmRegionSelectTransportRespVo> transportRespList = new ArrayList<MdmRegionSelectTransportRespVo>();
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedRegionCode()) && CollectionUtil.listNotEmptyNotSizeZero(selectedList = this.mdmRegionMapper.regionSelect((Page<MdmRegionSelectTransportRespVo>)new Page(1L, 1L, false), reqVo))) {
            pageSize = pageSize - 1;
            transportRespList.add(selectedList.get(0));
        }
        if (pageSize > 0) {
            if (CollectionUtil.listNotEmptyNotSizeZero(transportRespList)) {
                reqVo.setExcludeCode(reqVo.getSelectedRegionCode());
                reqVo.setSelectedRegionCode(null);
            }
            transportRespList.addAll(this.mdmRegionMapper.regionSelect((Page<MdmRegionSelectTransportRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(transportRespList)) {
            return transportRespList.stream().map(item -> {
                MdmRegionSelectRespVo respVo = new MdmRegionSelectRespVo();
                respVo.setRegionCode(item.getRegionCode());
                respVo.setRegionName(item.getRegionName());
                String unionName = "";
                if (StringUtils.isNotEmpty((String)item.getThirdParentRegionName())) {
                    unionName = unionName + item.getThirdParentRegionName() + "/";
                }
                if (StringUtils.isNotEmpty((String)item.getSecondParentRegionName())) {
                    unionName = unionName + item.getSecondParentRegionName() + "/";
                }
                if (StringUtils.isNotEmpty((String)item.getFirstParentRegionName())) {
                    unionName = unionName + item.getFirstParentRegionName() + "/";
                }
                unionName = unionName + item.getRegionName();
                respVo.setUnionName(unionName);
                return respVo;
            }).collect(Collectors.toList());
        }
        return new ArrayList<MdmRegionSelectRespVo>();
    }
}

