/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.service.BaseLazyTreeService;
import com.biz.crm.nebular.mdm.permission.BaseLazyTreeReqVo;
import com.biz.crm.nebular.mdm.permission.BaseLazyTreeRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.TreeRuleCodeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BaseLazyTreeServiceImpl
implements BaseLazyTreeService {
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmOrgMapper mdmOrgMapper;

    @Override
    public List<BaseLazyTreeRespVo> orgLazyTree(BaseLazyTreeReqVo reqVo) {
        ArrayList<BaseLazyTreeRespVo> list = new ArrayList<BaseLazyTreeRespVo>();
        if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
            list.addAll(this.mdmOrgMapper.findOrgLazyTreeList(null, reqVo.getParentCode(), null, null));
        } else if (!StringUtils.isEmpty((String)reqVo.getName())) {
            List orgList = ((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().like(MdmOrgEntity::getOrgName, (Object)reqVo.getName())).select(new SFunction[]{MdmOrgEntity::getOrgCode, CrmTreeTenEntity::getRuleCode}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)orgList)) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(orgList.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(this.mdmOrgMapper.findOrgLazyTreeList(null, null, null, new ArrayList<String>(parentRuleCodes)));
            }
        } else {
            list.addAll(this.mdmOrgMapper.findOrgLazyTreeList(true, null, null, null));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return this.generateTreeByParentCode(list);
        }
        return new ArrayList<BaseLazyTreeRespVo>();
    }

    private List<BaseLazyTreeRespVo> generateTreeByParentCode(List<BaseLazyTreeRespVo> totalList) {
        ArrayList<BaseLazyTreeRespVo> treeList = new ArrayList<BaseLazyTreeRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, BaseLazyTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(BaseLazyTreeRespVo::getCode, v -> v));
        for (BaseLazyTreeRespVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<BaseLazyTreeRespVo> restTempList = new ArrayList<BaseLazyTreeRespVo>();
            ArrayList<BaseLazyTreeRespVo> curLevelTempList = new ArrayList<BaseLazyTreeRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(BaseLazyTreeRespVo::getCode, BaseLazyTreeRespVo::getCode));
            HashMap curLevelChildrenMap = new HashMap(16);
            for (BaseLazyTreeRespVo baseLazyTreeRespVo : restList) {
                if (curLevelMap.containsKey(baseLazyTreeRespVo.getParentCode())) {
                    curLevelTempList.add(baseLazyTreeRespVo);
                    ArrayList<BaseLazyTreeRespVo> childrenList = new ArrayList<BaseLazyTreeRespVo>();
                    if (curLevelChildrenMap.containsKey(baseLazyTreeRespVo.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(baseLazyTreeRespVo.getParentCode()));
                    }
                    childrenList.add(baseLazyTreeRespVo);
                    curLevelChildrenMap.put(baseLazyTreeRespVo.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(baseLazyTreeRespVo);
            }
            for (BaseLazyTreeRespVo baseLazyTreeRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(baseLazyTreeRespVo.getCode())) continue;
                baseLazyTreeRespVo.setChildren((List)curLevelChildrenMap.get(baseLazyTreeRespVo.getCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

