/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.logtemplate.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.logtemplate.entity.LogFieldEntity;
import com.biz.crm.logtemplate.entity.LogTemplateEntity;
import com.biz.crm.logtemplate.service.LogTemplateService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ba1\u7406\u7aef-\u65e5\u5fd7\u6a21\u677f\u7ba1\u7406\u7aef\u63a5\u53e3\u7ba1\u7406\u7c7b", tags={"\u7ba1\u7406\u7aef-\u65e5\u5fd7\u6a21\u677f\u7ba1\u7406\u7aef\u63a5\u53e3\u7ba1\u7406\u7c7b"})
@RestController
@RequestMapping(value={"/m/log/"})
public class LogTemplatemController {
    @Resource
    private LogTemplateService logTemplateService;

    @CrmLog
    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u67e5\u8be2\u5b57\u6bb5")
    @GetMapping(value={"findFieldsByType"})
    public Result<Map<String, LogFieldEntity>> findFieldsByType(@RequestParam(value="type") String type) {
        Map<String, LogFieldEntity> logFieldEntities = this.logTemplateService.findFieldsByType(type);
        return Result.ok(logFieldEntities);
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636e\u7c7b\u578b\u548c\u6a21\u677f\u7f16\u7801\u67e5\u8be2\u5b57\u6bb5")
    @GetMapping(value={"findFieldsByTypeAndCode"})
    public Result<Map<String, LogFieldEntity>> findFieldsByTypeAndCode(@RequestParam(value="type") String type, @RequestParam(value="templateCode") String templateCode, @RequestParam(value="tree") @ApiParam(value="\u5c42\u7ea7\uff0c\u5982\uff1arepFeePool.repFeePoolItems.repFeePoolDetails") String tree) {
        Map<String, LogFieldEntity> logFieldEntities = this.logTemplateService.findFieldsByTypeAndCode(type, templateCode, tree);
        return Result.ok(logFieldEntities);
    }

    @CrmLog
    @ApiOperation(value="\u521b\u5efa\u6a21\u677f")
    @PostMapping(value={"create"})
    public Result create(@RequestBody LogTemplateEntity logTemplateVo) {
        this.logTemplateService.create(logTemplateVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u4fee\u6539\u6a21\u677f")
    @PostMapping(value={"update"})
    public Result update(@RequestBody LogTemplateEntity logTemplateVo) {
        this.logTemplateService.update(logTemplateVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u8bfb\u53d6\u6a21\u677f")
    @PostMapping(value={"read"})
    public Result<LogTemplateEntity> read(@RequestParam(value="templateCode") String templateCode) {
        LogTemplateEntity logTemplateVo = this.logTemplateService.read(templateCode);
        return Result.ok((Object)((Object)logTemplateVo));
    }

    @CrmLog
    @ApiOperation(value="\u5206\u9875\u6761\u4ef6\u67e5\u8be2\u65e5\u5fd7\u6a21\u677f")
    @PostMapping(value={"findPageByConditions"})
    public Result<PageResult<LogTemplateEntity>> findPageByConditions(@RequestBody LogTemplateEntity req) {
        PageResult<LogTemplateEntity> pageResult = this.logTemplateService.findPageByConditions(req);
        return Result.ok(pageResult);
    }

    @CrmLog
    @ApiOperation(value="\u542f\u7528\u7981\u7528\u65e5\u5fd7\u6a21\u677f")
    @GetMapping(value={"enable"})
    public Result enable(@RequestParam(name="templateCode") String templateCode, @RequestParam(name="status") boolean status) {
        this.logTemplateService.enable(templateCode, status);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u5220\u9664\u65e5\u5fd7\u6a21\u677f")
    @DeleteMapping(value={"deleteByCode"})
    public Result deleteByCode(@RequestParam(name="templateCode") String templateCode) {
        this.logTemplateService.deleteByCode(templateCode);
        return Result.ok();
    }
}

