/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.nebular.mdm.org.req.MdmOrgRegionReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRegionRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.org.mapper.MdmOrgRegionMapper;
import com.biz.crm.org.model.MdmOrgRegionEntity;
import com.biz.crm.org.service.MdmOrgRegionService;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.region.model.MdmRegionEntity;
import com.biz.crm.region.service.MdmRegionService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmOrgRegionServiceExpandImpl"})
public class MdmOrgRegionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmOrgRegionMapper, MdmOrgRegionEntity>
implements MdmOrgRegionService {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgRegionServiceImpl.class);
    @Resource
    private MdmOrgRegionMapper mdmOrgRegionMapper;
    @Resource
    private MdmRegionService mdmRegionService;
    @Resource
    private MdmOrgService mdmOrgService;

    @Override
    public List<MdmOrgRegionRespVo> findOrgRegionList(MdmOrgRegionReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.mdmOrgRegionMapper.findOrgRegionList(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrgRegion(MdmOrgRegionReqVo reqVo) {
        this.verify(reqVo);
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgRegionEntity::getOrgCode, (Object)reqVo.getOrgCode())).remove();
        List list = CrmBeanUtil.copyList((List)reqVo.getRegionList(), MdmOrgRegionEntity.class);
        this.saveBatch(list);
    }

    private void verify(MdmOrgRegionReqVo reqVo) {
        List list;
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.detail(null, reqVo.getOrgCode());
        Assert.notNull((Object)org, (String)"\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548");
        List regionList = reqVo.getRegionList();
        Assert.notEmpty((Collection)regionList, (String)"\u5173\u8054\u884c\u653f\u533a\u57df\u4e0d\u80fd\u4e3a\u7a7a");
        Map<Object, Object> regionMap = new HashMap(16);
        HashSet regionCodeList = new HashSet(16);
        regionCodeList.addAll(regionList.stream().map(MdmOrgRegionReqVo::getProvinceCode).collect(Collectors.toList()));
        regionCodeList.addAll(regionList.stream().map(MdmOrgRegionReqVo::getCityCode).collect(Collectors.toList()));
        regionCodeList.addAll(regionList.stream().map(MdmOrgRegionReqVo::getDistrictCode).collect(Collectors.toList()));
        regionCodeList.addAll(regionList.stream().map(MdmOrgRegionReqVo::getTownshipCode).collect(Collectors.toList()));
        if (!regionCodeList.isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.mdmRegionService.lambdaQuery().in(MdmRegionEntity::getRegionCode, regionCodeList)).list()))) {
            regionMap = list.stream().collect(Collectors.toMap(MdmRegionEntity::getRegionCode, v -> v));
        }
        for (int i = 0; i < regionList.size(); ++i) {
            try {
                Map<String, MdmOrgRegionEntity> collect;
                MdmOrgRegionReqVo item = (MdmOrgRegionReqVo)regionList.get(i);
                Assert.hasText((String)item.getProvinceCode(), (String)"\u7701\u4efd\u5fc5\u586b");
                if (StringUtils.isNotEmpty((String)item.getCityCode())) {
                    Assert.isTrue((boolean)regionMap.containsKey(item.getCityCode()), (String)"\u5e02\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isNotEmpty((String)item.getDistrictCode())) {
                    Assert.isTrue((boolean)regionMap.containsKey(item.getDistrictCode()), (String)"\u533a\u53bf\u4e0d\u5b58\u5728");
                }
                if (StringUtils.isNotEmpty((String)item.getTownshipCode())) {
                    Assert.isTrue((boolean)regionMap.containsKey(item.getTownshipCode()), (String)"\u4e61\u9547\u4e0d\u5b58\u5728");
                }
                List list2 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(MdmOrgRegionEntity::getOrgCode, (Object)reqVo.getOrgCode())).eq(MdmOrgRegionEntity::getProvinceCode, (Object)item.getProvinceCode())).eq(StringUtils.isNotEmpty((String)item.getCityCode()), MdmOrgRegionEntity::getCityCode, (Object)item.getCityCode())).eq(StringUtils.isNotEmpty((String)item.getDistrictCode()), MdmOrgRegionEntity::getDistrictCode, (Object)item.getDistrictCode())).eq(StringUtils.isNotEmpty((String)item.getTownshipCode()), MdmOrgRegionEntity::getTownshipCode, (Object)item.getTownshipCode())).list();
                String key = item.getProvinceCode() + "_" + item.getCityCode() + "_" + item.getDistrictCode() + "_" + item.getTownshipCode();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list2) && (collect = list2.stream().collect(Collectors.toMap(k -> k.getProvinceCode() + "_" + k.getCityCode() + "_" + k.getDistrictCode() + "_" + k.getTownshipCode(), v -> v))).containsKey(key)) {
                    MdmOrgRegionEntity orgRegion = collect.get(key);
                    String name = ((MdmRegionEntity)((Object)regionMap.get(orgRegion.getProvinceCode()))).getRegionName() + (StringUtils.isEmpty((String)orgRegion.getCityCode()) ? "" : ((MdmRegionEntity)((Object)regionMap.get(orgRegion.getCityCode()))).getRegionName()) + (StringUtils.isEmpty((String)orgRegion.getDistrictCode()) ? "" : ((MdmRegionEntity)((Object)regionMap.get(orgRegion.getDistrictCode()))).getRegionName()) + (StringUtils.isEmpty((String)orgRegion.getTownshipCode()) ? "" : ((MdmRegionEntity)((Object)regionMap.get(orgRegion.getTownshipCode()))).getRegionName());
                    throw new BusinessException(name + "\u5df2\u7ecf\u88ab\u5176\u5b83\u7ec4\u7ec7\u5173\u8054");
                }
                for (int j = 0; j < i; ++j) {
                    MdmOrgRegionReqVo yet = (MdmOrgRegionReqVo)regionList.get(j);
                    String yetKey = yet.getProvinceCode() + "_" + yet.getCityCode() + "_" + yet.getDistrictCode() + "_" + yet.getTownshipCode();
                    if (!key.equals(yetKey)) continue;
                    throw new BusinessException("\u4e0e\u7b2c" + (j + 1) + "\u884c\u91cd\u590d");
                }
                item.setOrgCode(reqVo.getOrgCode());
                continue;
            }
            catch (BusinessException e) {
                throw new BusinessException("\u7b2c" + (i + 1) + "\u884c\uff1a" + e.getMsg());
            }
        }
    }
}

