/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalContactVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.terminal.model.MdmTerminalContactEntity;
import com.biz.crm.terminal.service.MdmTerminalContactService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalContactServiceExpandImpl"})
public class MdmTerminalContactServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalContactMapper, MdmTerminalContactEntity>
implements MdmTerminalContactService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalContactServiceImpl.class);

    @Override
    public void deleteByCodes(List<String> terminalCodes) {
        if (CollectionUtils.isEmpty(terminalCodes)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalContactEntity::getTerminalCode, terminalCodes)).remove();
    }

    @Override
    public void setUpContact(MdmTerminalVo mdmTerminalVo) {
        List contacts = mdmTerminalVo.getContacts();
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalContactEntity::getTerminalCode, (Object)terminalCode)).remove();
        if (!CollectionUtils.isEmpty((Collection)contacts)) {
            long count = contacts.stream().filter(x -> !StringUtils.isEmpty((String)x.getContactMain()) && x.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue())).count();
            Assert.isTrue((count == 1L ? 1 : 0) != 0, (String)"\u7ec8\u7aef\u7ba1\u7406\uff1a\u4e3b\u8054\u7cfb\u4eba\u6709\u4e14\u53ea\u6709\u4e00\u4e2a");
            for (MdmTerminalContactVo contact : contacts) {
                contact.setId(UUID.randomUUID().toString());
                contact.setTerminalCode(terminalCode);
            }
            this.saveBatch(CrmBeanUtil.copyList((List)contacts, MdmTerminalContactEntity.class));
        }
    }

    @Override
    public List<MdmTerminalContactVo> findByTerminalCode(String terminalCode) {
        long count;
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalContactEntity::getTerminalCode, (Object)terminalCode)).list();
        List mdmTerminalContactVos = CrmBeanUtil.copyList((List)list, MdmTerminalContactVo.class);
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactVos) && (count = mdmTerminalContactVos.stream().filter(x -> !StringUtils.isEmpty((String)x.getContactMain()) && x.getContactMain().equals(YesNoEnum.yesNoEnum.ONE.getValue())).count()) != 1L) {
            mdmTerminalContactVos = mdmTerminalContactVos.stream().peek(x -> x.setContactMain(YesNoEnum.yesNoEnum.ZERO.getValue())).collect(Collectors.toList());
            ((MdmTerminalContactVo)mdmTerminalContactVos.get(0)).setContactMain(YesNoEnum.yesNoEnum.ONE.getValue());
        }
        return mdmTerminalContactVos;
    }
}

