/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.bpmrole.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.bpmrole.mapper.MdmBpmRoleMapper;
import com.biz.crm.bpmrole.model.MdmBpmRoleEntity;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.bpmrole.req.MdmBpmRoleReqVo;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.position.service.MdmPositionBpmRoleService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmBpmRoleServiceExpandImpl"})
public class MdmBpmRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmBpmRoleMapper, MdmBpmRoleEntity>
implements MdmBpmRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmBpmRoleServiceImpl.class);
    @Resource
    private MdmBpmRoleMapper mdmBpmRoleMapper;
    @Resource
    private MdmPositionBpmRoleService mdmPositionBpmRoleService;

    @Override
    public PageResult<MdmBpmRoleRespVo> findList(MdmBpmRoleReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmBpmRoleRespVo> list = this.mdmBpmRoleMapper.findList((Page<MdmBpmRoleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmBpmRoleRespVo detail(String id, String bpmRoleCode) {
        MdmBpmRoleEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)bpmRoleCode)) && (one = (MdmBpmRoleEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)bpmRoleCode), MdmBpmRoleEntity::getBpmRoleCode, (Object)bpmRoleCode)).one())) != null) {
            return (MdmBpmRoleRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmBpmRoleRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmBpmRoleReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getBpmRoleName(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u540d\u79f0");
        MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmBpmRoleEntity.class));
        if (StringUtils.isEmpty((String)entity.getBpmRoleCode())) {
            entity.setBpmRoleCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_BPM_ROLE_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmBpmRoleEntity::getBpmRoleCode, (Object)reqVo.getBpmRoleCode())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleCode}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5f53\u524d\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        }
        List nameList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmBpmRoleEntity::getBpmRoleName, (Object)reqVo.getBpmRoleName())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleName}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)nameList), (String)"\u5f53\u524d\u6d41\u7a0b\u89d2\u8272\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002");
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmBpmRoleReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        Assert.hasText((String)reqVo.getBpmRoleCode(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        Assert.hasText((String)reqVo.getBpmRoleName(), (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u540d\u79f0");
        MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
        Assert.isTrue((boolean)entity.getBpmRoleCode().equals(reqVo.getBpmRoleCode()), (String)"\u6d41\u7a0b\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        List nameList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmBpmRoleEntity::getBpmRoleName, (Object)reqVo.getBpmRoleName())).ne(BaseIdEntity::getId, (Object)reqVo.getId())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleName}).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)nameList), (String)"\u540d\u79f0\u5df2\u7ecf\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmBpmRoleEntity entity = (MdmBpmRoleEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            this.mdmPositionBpmRoleService.removeByBpmRole(entity.getBpmRoleCode());
        });
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmBpmRoleRespVo> selectList(MdmBpmRoleReqVo reqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(StringUtils.isNotEmpty((String)reqVo.getBpmRoleCode()), MdmBpmRoleEntity::getBpmRoleCode, (Object)reqVo.getBpmRoleCode())).like(StringUtils.isNotEmpty((String)reqVo.getBpmRoleName()), MdmBpmRoleEntity::getBpmRoleName, (Object)reqVo.getBpmRoleName())).select(new SFunction[]{MdmBpmRoleEntity::getBpmRoleCode, MdmBpmRoleEntity::getBpmRoleName}).list();
        return CrmBeanUtil.copyList((List)list, MdmBpmRoleRespVo.class);
    }
}

