/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.position.mapper.MdmPositionUserMapper;
import com.biz.crm.position.model.MdmPositionUserEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUserService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPositionUserServiceExpandImpl"})
@Transactional(rollbackFor={Exception.class})
public class MdmPositionUserServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionUserMapper, MdmPositionUserEntity>
implements MdmPositionUserService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionUserServiceImpl.class);
    @Resource
    private MdmPositionUserMapper mdmPositionUserMapper;
    @Resource
    private MdmPositionService mdmPositionService;

    @Override
    public void addUserPosition(String userName, String positionCode) {
        List list;
        if (StringUtils.isNotEmpty((String)userName) && StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionUserEntity::getUserName, (Object)userName)).eq(MdmPositionUserEntity::getPositionCode, (Object)positionCode)).list()))) {
            MdmPositionUserEntity entity = new MdmPositionUserEntity();
            entity.setPositionCode(positionCode);
            entity.setUserName(userName);
            this.save((Object)entity);
        }
    }

    @Override
    public void addUserPosition(String userName, List<String> positionCodeList) {
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            positionCodeList.forEach(positionCode -> this.addUserPosition(userName, (String)positionCode));
        }
    }

    @Override
    public void removeByPositionCode(String positionCode) {
        if (StringUtils.isNotEmpty((String)positionCode)) {
            this.removeByPositionCodes(Collections.singletonList(positionCode));
        }
    }

    @Override
    public void removeByPositionCodes(List<String> positionCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionUserEntity::getPositionCode, positionCodeList)).remove();
            this.setPositionNotPrimary(positionCodeList);
        }
    }

    @Override
    public void removeByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            this.removeByUserNames(Collections.singletonList(userName));
        }
    }

    @Override
    public void removeByUserNames(List<String> userNameList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionUserEntity::getUserName, userNameList)).select(new SFunction[]{MdmPositionUserEntity::getPositionCode}).list()))) {
            this.setPositionNotPrimary(list.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList()));
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionUserEntity::getUserName, userNameList)).remove();
        }
    }

    @Override
    public List<String> getPositionCodeListByUserName(String userName) {
        List list;
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionUserEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmPositionUserEntity::getPositionCode}).list()))) {
            return list.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<String> getPositionCodeListByUserNameList(List<String> userNameList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionUserEntity::getUserName, userNameList)).select(new SFunction[]{MdmPositionUserEntity::getPositionCode}).list()))) {
            return list.stream().map(MdmPositionUserEntity::getPositionCode).distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, List<String>> getPositionCodeListGroupByUserNameList(List<String> userNameList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(userNameList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionUserEntity::getUserName, userNameList)).select(new SFunction[]{MdmPositionUserEntity::getPositionCode, MdmPositionUserEntity::getUserName}).list()))) {
            return list.stream().collect(Collectors.groupingBy(MdmPositionUserEntity::getUserName, Collectors.collectingAndThen(Collectors.toList(), x -> x.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList()))));
        }
        return new HashMap<String, List<String>>();
    }

    @Override
    public String getUserNameByPositionCode(String positionCode) {
        MdmPositionUserEntity one;
        if (StringUtils.isNotEmpty((String)positionCode) && (one = (MdmPositionUserEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionUserEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{MdmPositionUserEntity::getUserName}).one())) != null) {
            return one.getUserName();
        }
        return null;
    }

    @Override
    public List<String> getUserNameListByPositionCodeList(List<String> positionCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionUserEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionUserEntity::getUserName}).list()))) {
            return list.stream().map(MdmPositionUserEntity::getUserName).distinct().collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public Map<String, String> getUserNameGroupByPositionCodeList(List<String> positionCodeList) {
        List list;
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionUserEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionUserEntity::getPositionCode, MdmPositionUserEntity::getUserName}).list()))) {
            return list.stream().collect(Collectors.toMap(MdmPositionUserEntity::getPositionCode, MdmPositionUserEntity::getUserName));
        }
        return new HashMap<String, String>();
    }

    private void setPositionNotPrimary(List<String> positionCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) {
            // empty if block
        }
    }
}

