/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positionlevel.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelSelectReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelSelectRespVo;
import com.biz.crm.positionlevel.service.MdmPositionLevelService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmPositionLevelController"})
@Api(tags={"MDM-\u804c\u4f4d\u7ea7\u522b"})
public class MdmPositionLevelController {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelController.class);
    @Autowired
    private MdmPositionLevelService mdmPositionLevelService;

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u7ea7\u522b\u5217\u8868\uff08\u5206\u9875\uff09")
    @PostMapping(value={"/pageList"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmPositionLevelRespVo>> pageList(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        PageResult<MdmPositionLevelRespVo> result = this.mdmPositionLevelService.findList(mdmPositionLevelReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="positionLevelCode", value="\u804c\u4f4d\u7ea7\u522b\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmLog
    @CrmDictMethod
    public Result<MdmPositionLevelRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="positionLevelCode", required=false) String positionLevelCode) {
        return Result.ok((Object)this.mdmPositionLevelService.detail(id, positionLevelCode));
    }

    @ApiOperation(value="\u65b0\u589e\u804c\u4f4d\u7ea7\u522b")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        this.mdmPositionLevelService.save(mdmPositionLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636eid\u66f4\u65b0\u804c\u4f4d\u7ea7\u522b")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        this.mdmPositionLevelService.update(mdmPositionLevelReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmPositionLevelService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.mdmPositionLevelService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.mdmPositionLevelService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u804c\u4f4d\u7ea7\u522b\u4e0b\u62c9\u6846\u9009\u62e9\u6570\u636e")
    @PostMapping(value={"/selectList"})
    @CrmLog
    public Result<List<MdmPositionLevelSelectRespVo>> selectList(@RequestBody MdmPositionLevelSelectReqVo reqVo) {
        List<MdmPositionLevelSelectRespVo> result = this.mdmPositionLevelService.selectList(reqVo);
        return Result.ok(result);
    }
}

