/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataSelectReqVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataSelectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmdictdata"})
@Api(tags={"MDM-\u6570\u636e\u5b57\u5178-\u660e\u7ec6\u8868"})
@CrmGlobalLog
public class MdmDictDataController {
    private static final Logger log = LoggerFactory.getLogger(MdmDictDataController.class);
    @Autowired
    private MdmDictDataService mdmDictDataService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\uff08\u6811\u5f62\uff09\uff0c\u4ece\u6570\u636e\u5e93\u67e5\uff0c\u4ec5\u5b57\u5178\u7ef4\u62a4\u9875\u9762\u4f7f\u7528", notes="dictTypeCode\u5fc5\u4f20")
    @PostMapping(value={"/tree"})
    public Result<List<MdmDictDataRespVo>> tree(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        return Result.ok(this.mdmDictDataService.tree(mdmDictDataReqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\uff08\u6811\u5f62\uff09\uff0c\u4ece\u7f13\u5b58\u67e5\uff0c\u4e1a\u52a1\u4f7f\u7528", httpMethod="GET", notes="dictTypeCode\u5fc5\u4f20")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictTypeCode", value="\u5b57\u5178\u7c7b\u578b\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/dictTree"})
    public Result<List<DictDataVo>> dictTree(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        return Result.ok(this.mdmDictDataService.dictTree(dictTypeCode));
    }

    @ApiOperation(value="\u6279\u91cf\u83b7\u53d6\u6570\u636e\u5b57\u5178\u4e0b\u62c9\u6846", notes="\u4ece\u7f13\u5b58\u67e5\u8be2\uff0c\u8fd4\u56de\u503c\u6ca1\u6709\u6269\u5c55\u5b57\u6bb5\uff0c\u4f20\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u96c6\u5408\u6570\u7ec4", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="dictTypeCodeList", value="\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/batchDictSelect"})
    public Result<Map<String, List<MdmDictDataSelectRespVo>>> batchDictSelect(@RequestBody List<String> dictTypeCodeList) {
        return Result.ok(this.mdmDictDataService.batchDictSelect(dictTypeCodeList));
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\uff08\u5206\u9875\uff09")
    @PostMapping(value={"/page"})
    public Result<PageResult<MdmDictDataRespVo>> page(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        PageResult<MdmDictDataRespVo> result = this.mdmDictDataService.findList(mdmDictDataReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178\u4e0b\u62c9\u6846", notes="\u4ece\u7f13\u5b58\u67e5\u8be2\uff0cdictTypeCode\u5fc5\u4f20\uff0c\u8fd4\u56de\u503c\u91ccdictCode:\u7f16\u7801\uff1bdictValue:\u503c\uff08\u6a21\u7cca\u67e5\u8be2\uff09\uff0c\u5176\u4f59\u4e3a\u6269\u5c55\u5b57\u6bb5")
    @PostMapping(value={"/list"})
    public Result<List<JSONObject>> list(@RequestBody MdmDictDataSelectReqVo reqVo) {
        return Result.ok(this.mdmDictDataService.list(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5", httpMethod="GET", notes="\u53ea\u67e5\u8be2\u6570\u636e\u5b57\u5178\u7c7b\u578b")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/query"})
    public Result<MdmDictDataEntity> query(String id) {
        MdmDictDataEntity respVo = this.mdmDictDataService.query(id);
        return Result.ok((Object)((Object)respVo));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        this.mdmDictDataService.save(mdmDictDataReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        this.mdmDictDataService.update(mdmDictDataReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmDictDataService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }
}

