/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.login.service.MdmSystemLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CookiesUtil;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmSystemLoginServiceExpandImpl"})
public class MdmSystemLoginServiceImpl
implements MdmSystemLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmSystemLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Autowired
    private PasswordEncoder passwordEncoder;
    @Autowired
    private MdmOrgService orgService;

    @Override
    public MdmLoginRespVo systemLogin(MdmLoginReqVo mdmLoginReqVo) {
        MdmUserRespVo mdmUserRespVo = this.validUser(mdmLoginReqVo);
        MdmPositionRespVo mdmPositionRespVo = this.validPosition(mdmUserRespVo);
        MdmOrgRespVo mdmOrgRespVo = this.validOrg(mdmPositionRespVo);
        String token = UUID.randomUUID().toString();
        this.storeRedis(mdmUserRespVo, mdmPositionRespVo, mdmOrgRespVo, token);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(mdmUserRespVo.getUserName());
        mdmLoginRespVo.setFullName(mdmUserRespVo.getFullName());
        mdmLoginRespVo.setPositionCode(mdmPositionRespVo.getPositionCode());
        mdmLoginRespVo.setPositionName(mdmPositionRespVo.getPositionName());
        mdmLoginRespVo.setOrgCode(mdmOrgRespVo.getOrgCode());
        mdmLoginRespVo.setOrgName(mdmOrgRespVo.getOrgName());
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        HttpServletResponse response = HttpServletRequestUtil.getResponse();
        CookiesUtil.doCoke((HttpServletRequest)request, (HttpServletResponse)response, (String)token, (String)"loginUserToken");
        return mdmLoginRespVo;
    }

    @Override
    public void systemLogout() {
        UserUtils.remove();
    }

    protected void storeRedis(MdmUserRespVo mdmUserRespVo, MdmPositionRespVo mdmPositionRespVo, MdmOrgRespVo mdmOrgRespVo, String token) {
        UserRedis userRedis = new UserRedis();
        userRedis.setOrgcode(mdmOrgRespVo.getOrgCode());
        userRedis.setOrgname(mdmOrgRespVo.getOrgName());
        userRedis.setPoscode(mdmPositionRespVo.getPositionCode());
        userRedis.setPosname(mdmPositionRespVo.getPositionName());
        userRedis.setUsername(mdmUserRespVo.getUserName());
        userRedis.setRealname(mdmUserRespVo.getFullName());
        UserUtils.setUser((String)token, (UserRedis)userRedis);
    }

    protected MdmOrgRespVo validOrg(MdmPositionRespVo mdmPositionRespVo) {
        MdmOrgRespVo mdmOrgRespVo = this.orgService.detail(null, mdmPositionRespVo.getOrgCode());
        Assert.notNull((Object)mdmOrgRespVo, (String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7ec4\u7ec7\u4fe1\u606f:{}", (Object)mdmOrgRespVo);
        return mdmOrgRespVo;
    }

    protected MdmPositionRespVo validPosition(MdmUserRespVo mdmUserRespVo) {
        MdmPositionRespVo mdmPositionRespVo = this.mdmPositionService.getUserCurrentPositionForLogin(mdmUserRespVo.getUserName());
        Assert.notNull((Object)mdmPositionRespVo, (String)"\u4e3b\u804c\u4f4d\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u4e3b\u804c\u4f4d:{}", (Object)mdmPositionRespVo);
        Assert.hasText((String)mdmPositionRespVo.getOrgCode(), (String)"\u804c\u4f4d\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        return mdmPositionRespVo;
    }

    protected MdmUserRespVo validUser(MdmLoginReqVo mdmLoginReqVo) {
        String userName = mdmLoginReqVo.getUserName();
        String password = mdmLoginReqVo.getPassword();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(userName);
        mdmUserReqVo.setUserType(UserTypeEnum.USER.getCode());
        MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryBasic(mdmUserReqVo);
        Assert.notNull((Object)mdmUserRespVo, (String)"\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7528\u6237\u4fe1\u606f:{}", (Object)mdmUserRespVo);
        String encryPwd = Md5EncryptionAndDecryption.encryPwd((String)password);
        Assert.isTrue((!StringUtils.isEmpty((Object)encryPwd) && encryPwd.equals(mdmUserRespVo.getUserPassword()) ? 1 : 0) != 0, (String)"\u5bc6\u7801\u4e0d\u6b63\u786e");
        String enableStatus = mdmUserRespVo.getEnableStatus();
        Assert.isTrue((!StringUtils.isEmpty((Object)enableStatus) && CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus) ? 1 : 0) != 0, (String)"\u7528\u6237\u6ca1\u6709\u542f\u7528");
        String startTime = mdmUserRespVo.getStartTime();
        String endTime = mdmUserRespVo.getEndTime();
        if (!StringUtils.isEmpty((Object)startTime) && !StringUtils.isEmpty((Object)endTime)) {
            String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            Assert.isTrue((format.compareTo(startTime) >= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u751f\u6548");
            Assert.isTrue((format.compareTo(endTime) <= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u5df2\u5931\u6548");
        }
        return mdmUserRespVo;
    }
}

