/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceProductUnitRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductAndProductLevelReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductSelectReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAndProductLevelRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductSelectRespVo;
import com.biz.crm.product.service.MdmProductService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmProductController"})
@Api(tags={"MDM-\u5546\u54c1\u7ba1\u7406"})
@CrmGlobalLog
public class MdmProductController {
    private static final Logger log = LoggerFactory.getLogger(MdmProductController.class);
    @Resource
    private MdmProductService mdmProductService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmProductRespVo>> pageList(@RequestBody MdmProductReqVo mdmProductReqVo) {
        PageResult<MdmProductRespVo> result = this.mdmProductService.findList(mdmProductReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u516c\u7528\u5206\u9875\u5f39\u6846")
    @PostMapping(value={"/commonPageList"})
    @CrmDictMethod
    public Result<PageResult<MdmProductRespVo>> commonPageList(@RequestBody MdmProductReqVo mdmProductReqVo) {
        mdmProductReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        mdmProductReqVo.setIsShelf(IsShelfEnum.UP.getCode());
        PageResult<MdmProductRespVo> result = this.mdmProductService.findList(mdmProductReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="productCode", value="\u5546\u54c1\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmProductRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="productCode", required=false) String productCode) {
        MdmProductRespVo respVo = this.mdmProductService.detail(id, productCode);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u901a\u8fc7id\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e3b\u8868\u4fe1\u606f", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/queryBatchByIds"})
    public Result<List<MdmProductRespVo>> queryBatchByIds(@RequestBody List<String> ids) {
        return Result.ok(this.mdmProductService.queryBatch(ids, null));
    }

    @ApiOperation(value="\u901a\u8fc7\u5546\u54c1\u7f16\u7801\u96c6\u5408\u6279\u91cf\u67e5\u8be2\u5546\u54c1\u4e3b\u8868\u4fe1\u606f", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="productCodeList", value="\u5546\u54c1\u7f16\u7801\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/queryBatchByProductCodeList"})
    public Result<List<MdmProductRespVo>> queryBatchByProductCodeList(@RequestBody List<String> productCodeList) {
        return Result.ok(this.mdmProductService.queryBatch(null, productCodeList));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.save(mdmProductReqVo);
        return Result.ok((String)"\u65b0\u589e\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.update(mdmProductReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmProductService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmProductService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmProductService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u67b6", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/upShelf"})
    public Result upShelf(@RequestBody List<String> ids) {
        this.mdmProductService.upShelf(ids);
        return Result.ok((String)"\u4e0a\u67b6\u6210\u529f");
    }

    @ApiOperation(value="\u4e0b\u67b6", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/downShelf"})
    public Result downShelf(@RequestBody List<String> ids) {
        this.mdmProductService.downShelf(ids);
        return Result.ok((String)"\u4e0b\u67b6\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u548c\u4ea7\u54c1\u5c42\u7ea7\u96c6\u5408\u7684\u4e0b\u62c9\u6846\uff08\u53ea\u67e5\u542f\u7528\uff09\uff0c\u5546\u54c1\u548c\u4ea7\u54c1\u5c42\u7ea7\u5e76\u5217\u8fd4\u56de\uff0c\u8c28\u614e\u4f7f\u7528")
    @PostMapping(value={"/findProductAndProductLevel"})
    public Result<List<MdmProductAndProductLevelRespVo>> findProductAndProductLevelByCodeOrName(@RequestBody MdmProductAndProductLevelReqVo reqVo) {
        List<MdmProductAndProductLevelRespVo> result = this.mdmProductService.findProductAndProductLevelByCodeOrName(reqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5546\u54c1\u4e0b\u62c9\u6846\u9009\u9879")
    @PostMapping(value={"/productSelectList"})
    @CrmDictMethod
    public Result<List<MdmProductSelectRespVo>> productSelectList(@RequestBody MdmProductSelectReqVo reqVo) {
        return Result.ok(this.mdmProductService.productSelectList(reqVo));
    }

    @ApiOperation(value="\u67e5\u8be2\u5546\u54c1\u5355\u4f4d")
    @PostMapping(value={"/findProductUnit"})
    public Result<List<MdmPriceProductUnitRespVo>> findProductUnit(@RequestBody String productCode) {
        List<MdmPriceProductUnitRespVo> mdmPriceProductUnitRespVos = this.mdmProductService.findProductUnit(productCode);
        return Result.ok(mdmPriceProductUnitRespVos);
    }
}

