/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.shoppingcart.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.nebular.mdm.shoppingcart.ShoppingCartVo;
import com.biz.crm.shoppingcart.service.ShoppingCartService;
import com.biz.crm.util.Result;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u524d\u7aef-\u8d2d\u7269\u8f66-\u5ba2\u6237", tags={"\u524d\u7aef-\u8d2d\u7269\u8f66-\u5ba2\u6237"})
@RestController
@RequestMapping(value={"/p/shoppingcart"})
public class ShoppingCartpController {
    @Resource
    private ShoppingCartService shoppingCartService;

    @CrmLog
    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"add"})
    public Result add(@RequestBody ShoppingCartVo shoppingCartVo) {
        UserRedis userRedis = UserUtils.getUser();
        shoppingCartVo.setCusCode(userRedis.getCustcode());
        shoppingCartVo.setAccount(userRedis.getUsername());
        this.shoppingCartService.add(shoppingCartVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u8c03\u6574\u8d2d\u7269\u8f66\u5546\u54c1\u6570\u91cf")
    @PostMapping(value={"adjustNum"})
    public Result adjustNum(@RequestBody ShoppingCartVo shoppingCartVo) {
        shoppingCartVo.setCusCode(UserUtils.getUser().getCustcode());
        this.shoppingCartService.adjustNum(shoppingCartVo);
        return Result.ok();
    }

    @CrmLog
    @ApiOperation(value="\u5217\u8868\u5c55\u793a\uff08\u6309\u53d1\u8d27\u516c\u53f8\u5206\u7ec4\uff09")
    @PostMapping(value={"list"})
    public Result<Map<String, List<ShoppingCartVo>>> list() {
        UserRedis userRedis = UserUtils.getUser();
        ShoppingCartVo shoppingCartVo = new ShoppingCartVo();
        shoppingCartVo.setCusCode(userRedis.getCustcode());
        return Result.ok(this.shoppingCartService.list(shoppingCartVo));
    }

    @CrmLog
    @ApiOperation(value="\u6839\u636eid\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"delByIds"})
    public Result delByIds(@RequestBody List<String> ids) {
        this.shoppingCartService.delByIds(ids, UserUtils.getUser().getCustcode());
        return Result.ok();
    }
}

