/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalVo;
import com.biz.crm.terminal.mapper.MdmTerminalROrgMapper;
import com.biz.crm.terminal.model.MdmTerminalROrgEntity;
import com.biz.crm.terminal.service.MdmTerminalROrgService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmTerminalROrgServiceExpandImpl"})
public class MdmTerminalROrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmTerminalROrgMapper, MdmTerminalROrgEntity>
implements MdmTerminalROrgService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalROrgServiceImpl.class);

    @Override
    public void setUpTerminalRelationOrg(MdmTerminalVo mdmTerminalVo) {
        List<String> orgCodeList;
        String terminalCode = mdmTerminalVo.getTerminalCode();
        Assert.hasText((String)terminalCode, (String)"\u7ec8\u7aef\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String orgCode = mdmTerminalVo.getOrgCode();
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmTerminalROrgEntity::getTerminalCode, (Object)terminalCode)).remove();
        if (!StringUtils.isEmpty((Object)orgCode) && !CollectionUtils.isEmpty(orgCodeList = Arrays.asList(orgCode.split(",")))) {
            ArrayList<MdmTerminalROrgEntity> list = new ArrayList<MdmTerminalROrgEntity>();
            for (String currentOrgCode : orgCodeList) {
                MdmTerminalROrgEntity mdmTerminalROrgEntity = new MdmTerminalROrgEntity();
                mdmTerminalROrgEntity.setOrgCode(currentOrgCode);
                mdmTerminalROrgEntity.setTerminalCode(terminalCode);
                list.add(mdmTerminalROrgEntity);
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.saveBatch(list);
            }
        }
    }

    @Override
    public List<String> findTerminalCodeByOrg(List<String> orgCodeList) {
        if (CollectionUtils.isEmpty(orgCodeList)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalROrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{MdmTerminalROrgEntity::getTerminalCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getTerminalCode())).map(MdmTerminalROrgEntity::getTerminalCode).distinct().collect(Collectors.toList());
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalROrgEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalROrgEntity::getTerminalCode, MdmTerminalROrgEntity::getOrgCode}).list().stream().collect(Collectors.toMap(MdmTerminalROrgEntity::getTerminalCode, MdmTerminalROrgEntity::getOrgCode, (x1, x2) -> x1));
    }

    @Override
    public void setUp(List<String> terminalCodeList, String orgCode) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return;
        }
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalROrgEntity::getTerminalCode, terminalCodeList)).remove();
        if (StringUtils.isEmpty((Object)orgCode)) {
            return;
        }
        List<String> orgCodeList = Arrays.asList(orgCode.split(","));
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            ArrayList<MdmTerminalROrgEntity> list = new ArrayList<MdmTerminalROrgEntity>();
            for (String terminalCode : terminalCodeList) {
                for (String currentOrgCode : orgCodeList) {
                    MdmTerminalROrgEntity mdmTerminalROrgEntity = new MdmTerminalROrgEntity();
                    mdmTerminalROrgEntity.setTerminalCode(terminalCode);
                    mdmTerminalROrgEntity.setOrgCode(currentOrgCode);
                    list.add(mdmTerminalROrgEntity);
                }
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.saveBatch(list);
            }
        }
    }

    @Override
    public Map<String, List<String>> findOrgCodeList(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalROrgEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalROrgEntity::getTerminalCode, MdmTerminalROrgEntity::getOrgCode}).list().stream().collect(Collectors.groupingBy(MdmTerminalROrgEntity::getTerminalCode, Collectors.mapping(MdmTerminalROrgEntity::getOrgCode, Collectors.toList())));
    }

    public List<String> findOrgCodeListByCustomerCode(String terminalCode) {
        if (StringUtils.isEmpty((Object)terminalCode)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmTerminalROrgEntity::getTerminalCode, (Object)terminalCode)).select(new SFunction[]{MdmTerminalROrgEntity::getOrgCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getTerminalCode())).map(MdmTerminalROrgEntity::getTerminalCode).collect(Collectors.toList());
    }
}

