/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.MdmCustomerAddressMapper;
import com.biz.crm.customer.model.MdmCustomerAddressEntity;
import com.biz.crm.customer.service.MdmCustomerAddressService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerAddressServiceExpandImpl"})
public class MdmCustomerAddressServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerAddressMapper, MdmCustomerAddressEntity>
implements MdmCustomerAddressService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerAddressServiceImpl.class);
    @Resource
    private MdmCustomerAddressMapper mdmCustomerAddressMapper;

    @Override
    public PageResult<MdmCustomerAddressRespVo> findList(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        Page page = new Page((long)mdmCustomerAddressReqVo.getPageNum().intValue(), (long)mdmCustomerAddressReqVo.getPageSize().intValue());
        List<MdmCustomerAddressRespVo> list = this.mdmCustomerAddressMapper.findList((Page<MdmCustomerAddressRespVo>)page, mdmCustomerAddressReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmCustomerAddressRespVo query(String id) {
        return this.mdmCustomerAddressMapper.query(id);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        Assert.hasText((String)mdmCustomerAddressReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerAddressReqVo.getDistrictCode(), (String)"\u9001\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        mdmCustomerAddressReqVo.setId(null);
        MdmCustomerAddressEntity entity = (MdmCustomerAddressEntity)((Object)CrmBeanUtil.copy((Object)mdmCustomerAddressReqVo, MdmCustomerAddressEntity.class));
        String defaultAddress = mdmCustomerAddressReqVo.getDefaultAddress();
        if (!StringUtils.isEmpty((String)defaultAddress) && YesNoEnum.yesNoEnum.ONE.getValue().equals(defaultAddress)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerAddressEntity::getCustomerCode, (Object)mdmCustomerAddressReqVo.getCustomerCode())).eq(MdmCustomerAddressEntity::getDefaultAddress, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).set(MdmCustomerAddressEntity::getDefaultAddress, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
        }
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        Assert.hasText((String)mdmCustomerAddressReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerAddressReqVo.getId(), (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerAddressReqVo.getDistrictCode(), (String)"\u9001\u8fbe\u65b9\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)mdmCustomerAddressReqVo.getId())).count();
        Assert.isTrue((count != null && count > 0 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u5730\u5740\u4e0d\u5b58\u5728");
        Integer count1 = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)mdmCustomerAddressReqVo.getId())).eq(MdmCustomerAddressEntity::getCustomerCode, (Object)mdmCustomerAddressReqVo.getCustomerCode())).eq(MdmCustomerAddressEntity::getDistrictCode, (Object)mdmCustomerAddressReqVo.getDistrictCode())).count();
        Assert.isTrue((count1 == null || count1 < 1 ? 1 : 0) != 0, (String)"\u9001\u8fbe\u65b9\u7f16\u7801\u5df2\u5b58\u5728");
        String defaultAddress = mdmCustomerAddressReqVo.getDefaultAddress();
        if (!StringUtils.isEmpty((String)defaultAddress) && YesNoEnum.yesNoEnum.ONE.getValue().equals(defaultAddress)) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerAddressEntity::getCustomerCode, (Object)mdmCustomerAddressReqVo.getCustomerCode())).eq(MdmCustomerAddressEntity::getDefaultAddress, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).set(MdmCustomerAddressEntity::getDefaultAddress, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
        }
        this.updateById(CrmBeanUtil.copy((Object)mdmCustomerAddressReqVo, MdmCustomerAddressEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        this.removeByIds(ids);
    }
}

