/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.notice.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeMiniReqVo;
import com.biz.crm.nebular.mdm.notice.req.MdmNoticeReqVo;
import com.biz.crm.nebular.mdm.notice.resp.MdmNoticeRespVo;
import com.biz.crm.notice.service.IMdmNoticeService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmNoticeController"})
@Api(tags={"\u516c\u544a\u7ba1\u7406 "})
public class MdmNoticeController {
    private static final Logger log = LoggerFactory.getLogger(MdmNoticeController.class);
    @Autowired
    private IMdmNoticeService mdmNoticeService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmNoticeRespVo>> list(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        PageResult<MdmNoticeRespVo> result = this.mdmNoticeService.findList(mdmNoticeReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u5c0f\u7a0b\u5e8f\u5217\u8868")
    @PostMapping(value={"/miniList"})
    @CrmLog
    public Result<PageResult<MdmNoticeRespVo>> miniList(@RequestBody MdmNoticeMiniReqVo mdmNoticeMiniReqVo) {
        PageResult<MdmNoticeRespVo> result = this.mdmNoticeService.findListByMiniPrg(mdmNoticeMiniReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2\u516c\u544a\u5355\u6761\u6700\u65b0")
    @GetMapping(value={"/miniNewNotice"})
    @CrmLog
    public Result<MdmNoticeRespVo> miniNewNotice() {
        MdmNoticeRespVo respVo = this.mdmNoticeService.queryMiniPrgNew();
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/miniQuery"})
    @CrmLog
    public Result<MdmNoticeRespVo> miniQuery(@RequestParam(value="id") String id) {
        MdmNoticeRespVo result = this.mdmNoticeService.queryMiniPrg(id);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u5c0f\u7a0b\u5e8f\u8be6\u60c5\uff08\u4e0a\u4e00\u9875/\u4e0b\u4e00\u9875\uff09", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="id", required=true, dataType="String", paramType="query"), @ApiImplicitParam(name="upBelow", value="\u7ffb\u9875\u72b6\u6001(1:\u4e0a\u4e00\u9875,0:\u4e0b\u4e00\u9875)", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/miniQueryUpBelow"})
    @CrmLog
    public Result<MdmNoticeRespVo> miniQueryUpBelow(@RequestParam(value="id") String id, @RequestParam(value="upBelow") String upBelow) {
        MdmNoticeRespVo result = this.mdmNoticeService.queryMiniPrgByUpBelow(id, upBelow);
        return Result.ok((Object)result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<MdmNoticeRespVo> query(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        MdmNoticeRespVo respVo = this.mdmNoticeService.query(mdmNoticeReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u67e5\u8be2\u516c\u544a\u8be6\u60c5")
    @GetMapping(value={"/queryNoticeDetail"})
    @CrmLog
    public Result<MdmNoticeRespVo> queryNoticeDetail(final @RequestParam String id) {
        AssertUtils.isNotEmpty((String)id, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmNoticeReqVo mdmNoticeReqVo = new MdmNoticeReqVo(){
            {
                this.setId(id);
            }
        };
        MdmNoticeRespVo respVo = this.mdmNoticeService.query(mdmNoticeReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        this.mdmNoticeService.save(mdmNoticeReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmNoticeReqVo mdmNoticeReqVo) {
        this.mdmNoticeService.update(mdmNoticeReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody List<String> ids) {
        this.mdmNoticeService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody List<String> ids) {
        this.mdmNoticeService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody List<String> ids) {
        this.mdmNoticeService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }
}

