/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionReqVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmListConfigRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.permission.mapper.MdmDataPermissionMapper;
import com.biz.crm.permission.model.MdmDataPermissionEntity;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDataPermissionServiceExpandImpl"})
public class MdmDataPermissionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDataPermissionMapper, MdmDataPermissionEntity>
implements IMdmDataPermissionService {
    private static final Logger log = LoggerFactory.getLogger(MdmDataPermissionServiceImpl.class);
    @Resource
    private MdmDataPermissionMapper mdmDataPermissionMapper;
    @Autowired
    private MdmFunctionService mdmFunctionService;
    @Autowired
    private MdmFunctionRoleService mdmFunctionRoleService;
    @Autowired
    private MdmRoleService mdmRoleService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;

    @Override
    @CrmDictMethod
    public PageResult<MdmDataPermissionRespVo> findList(MdmDataPermissionReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmDataPermissionRespVo> list = this.mdmDataPermissionMapper.findList((Page<MdmDataPermissionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmDataPermissionRespVo query(MdmDataPermissionReqVo reqVo) {
        MdmDataPermissionEntity one = (MdmDataPermissionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (MdmDataPermissionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDataPermissionRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDataPermissionReqVo reqVo) {
        String listConfigCode = reqVo.getListConfigCode();
        Assert.hasText((String)listConfigCode, (String)"\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String permissionDimension = reqVo.getPermissionDimension();
        Assert.hasText((String)permissionDimension, (String)"\u6743\u9650\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        switch (permissionDimension) {
            case "role": {
                String roleCode = reqVo.getRoleCode();
                Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                reqVo.setId(roleCode + permissionDimension + listConfigCode + functionCode);
                break;
            }
            case "org": {
                String orgCode = reqVo.getOrgCode();
                Assert.hasText((String)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                reqVo.setId(orgCode + permissionDimension + listConfigCode + functionCode);
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b");
            }
        }
        MdmDataPermissionEntity entity = (MdmDataPermissionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDataPermissionEntity.class));
        this.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDataPermissionReqVo reqVo) {
        this.save(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmDataPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmDataPermissionReqVo reqVo) {
        List<String> ids = this.valid(reqVo);
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    private List<String> valid(MdmDataPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        String id = (String)ids.get(0);
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmDataPermissionReqVo reqVo) {
        List<String> ids = this.valid(reqVo);
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public MdmDataPermissionRespVo queryCondition(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        String competenceCode = mdmDataPermissionReqVo.getFunctionCode();
        Assert.hasText((String)competenceCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String listConfigCode = mdmDataPermissionReqVo.getListConfigCode();
        String permissionDimension = mdmDataPermissionReqVo.getPermissionDimension();
        Assert.hasText((String)permissionDimension, (String)"\u6743\u9650\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)listConfigCode, (String)"\u5217\u8868\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmDataPermissionEntity::getPermissionDimension, (Object)permissionDimension)).eq(MdmDataPermissionEntity::getListConfigCode, (Object)listConfigCode)).eq(MdmDataPermissionEntity::getFunctionCode, (Object)competenceCode)).last(DatabaseTypeUtil.SEGMENT);
        switch (permissionDimension) {
            case "role": {
                String roleCode = mdmDataPermissionReqVo.getRoleCode();
                Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq(MdmDataPermissionEntity::getRoleCode, (Object)roleCode);
                break;
            }
            case "org": {
                String orgCode = mdmDataPermissionReqVo.getOrgCode();
                Assert.hasText((String)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq(MdmDataPermissionEntity::getOrgCode, (Object)orgCode);
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b");
            }
        }
        MdmDataPermissionEntity one = (MdmDataPermissionEntity)((Object)this.getOne((Wrapper)wrapper));
        return (MdmDataPermissionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDataPermissionRespVo.class);
    }

    @Override
    public MdmCurrentPermissionRespVo currentUserDataPermission(String competenceCode, String listConfigCode) {
        MdmCurrentPermissionRespVo mdmCurrentPermissionRespVo = new MdmCurrentPermissionRespVo();
        Assert.hasText((String)competenceCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)listConfigCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u6570\u636e\u6743\u9650]\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6743\u9650,\u7528\u6237\u4fe1\u606f:{}", (Object)user);
        String username = user.getUsername();
        Assert.hasText((String)username, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        if ("admin".equals(username)) {
            mdmCurrentPermissionRespVo.setUserPermissionList(Collections.emptyList());
            mdmCurrentPermissionRespVo.setPermissionObjCodeList(Collections.emptyList());
            return mdmCurrentPermissionRespVo;
        }
        List permissionEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDataPermissionEntity::getFunctionCode, (Object)competenceCode)).eq(MdmDataPermissionEntity::getListConfigCode, (Object)listConfigCode)).list();
        if (CollectionUtils.isEmpty((Collection)permissionEntities)) {
            mdmCurrentPermissionRespVo.setUserPermissionList(Collections.emptyList());
            mdmCurrentPermissionRespVo.setPermissionObjCodeList(Collections.emptyList());
            return mdmCurrentPermissionRespVo;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDataPermissionEntity::getFunctionCode, (Object)competenceCode)).eq(MdmDataPermissionEntity::getListConfigCode, (Object)listConfigCode)).select(new SFunction[]{MdmDataPermissionEntity::getPermissionObjCode}).list().stream().map(MdmDataPermissionEntity::getPermissionObjCode).distinct().collect(Collectors.toList());
        mdmCurrentPermissionRespVo.setPermissionObjCodeList(list);
        MdmCurrentUserPermissionRespVo mdmCurrentUserPermissionRespVo = new MdmCurrentUserPermissionRespVo();
        mdmCurrentUserPermissionRespVo.setPermissionObjCode("position");
        mdmCurrentUserPermissionRespVo.setPermissionValueList(Collections.singletonMap("position", Collections.singletonList("ZW00000015")));
        MdmCurrentUserPermissionRespVo mdmCurrentUserPermissionRespVo1 = new MdmCurrentUserPermissionRespVo();
        mdmCurrentUserPermissionRespVo1.setPermissionObjCode("org");
        mdmCurrentUserPermissionRespVo1.setPermissionValueList(Collections.singletonMap("org", Collections.singletonList("ZW00000015")));
        ArrayList mdmCurrentUserPermissionRespVos = Lists.newArrayList((Object[])new MdmCurrentUserPermissionRespVo[]{mdmCurrentUserPermissionRespVo});
        mdmCurrentUserPermissionRespVos.add(mdmCurrentUserPermissionRespVo1);
        mdmCurrentPermissionRespVo.setUserPermissionList((List)mdmCurrentUserPermissionRespVos);
        return mdmCurrentPermissionRespVo;
    }

    @Override
    public List<MdmPermissionObjRespVo> objList(String functionCode, String listConfigCode) {
        List permissionTree = DictUtil.tree((String)"permission_obj");
        if (CollectionUtils.isEmpty((Collection)permissionTree)) {
            return Collections.emptyList();
        }
        MdmFunctionSubEntity mdmFunctionSubEntity = (MdmFunctionSubEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)functionCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)listConfigCode)).select(new SFunction[]{MdmFunctionSubEntity::getPermissionObj}).one());
        log.info("[\u529f\u80fd\u5217\u8868][\u5df2\u914d\u7f6e\u7684\u6743\u9650\u5bf9\u8c61]:{}", (Object)mdmFunctionSubEntity);
        if (mdmFunctionSubEntity == null) {
            return Collections.emptyList();
        }
        String permissionObj = mdmFunctionSubEntity.getPermissionObj();
        if (StringUtils.isEmpty((String)permissionObj)) {
            return Collections.emptyList();
        }
        List<String> permissionObjList = Arrays.asList(permissionObj.split(","));
        return permissionTree.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getDictCode()) && permissionObjList.contains(x.getDictCode())).map(x -> {
            MdmPermissionObjRespVo mdmPermissionObjRespVo = new MdmPermissionObjRespVo();
            mdmPermissionObjRespVo.setPermissionObjCode(x.getDictCode());
            mdmPermissionObjRespVo.setPermissionObjName(x.getDictValue());
            return mdmPermissionObjRespVo;
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> searchTypeList(String permissionObjCode) {
        return DictUtil.getChildrenMap((String)"permission_obj", (String)permissionObjCode);
    }

    @Override
    public List<MdmFunctionRespVo> functionSelect(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        MdmFunctionReqVo mdmFunctionReqVo = new MdmFunctionReqVo();
        if (!StringUtils.isEmpty((String)mdmDataPermissionReqVo.getRoleCode())) {
            List<String> relationFunctionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(mdmDataPermissionReqVo.getRoleCode());
            mdmFunctionReqVo.setFunctionCodeList(relationFunctionCodeList);
        }
        return this.mdmFunctionService.systemList(mdmFunctionReqVo);
    }

    @Override
    public List<MdmRoleRespVo> roleSelectList(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        MdmRoleReqVo mdmRoleReqVo = new MdmRoleReqVo();
        if (!StringUtils.isEmpty((String)mdmDataPermissionReqVo.getFunctionCode())) {
            List<String> roleCodeList = this.mdmFunctionRoleService.findRoleCodeByFunction(mdmDataPermissionReqVo.getFunctionCode());
            mdmRoleReqVo.setRoleCodeList(roleCodeList);
        }
        return this.mdmRoleService.roleSelectList(mdmRoleReqVo);
    }

    @Override
    public List<MdmListConfigRespVo> configList(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        String functionCode = mdmDataPermissionReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubReqVo mdmFunctionSubReqVo = new MdmFunctionSubReqVo();
        mdmFunctionSubReqVo.setParentCode(functionCode);
        List<MdmFunctionSubRespVo> subList = this.mdmFunctionSubService.findSubList(mdmFunctionSubReqVo);
        if (CollectionUtils.isEmpty(subList)) {
            return Collections.emptyList();
        }
        return subList.stream().map(x -> {
            MdmListConfigRespVo mdmListConfigRespVo = new MdmListConfigRespVo();
            mdmListConfigRespVo.setListConfigCode(x.getFunctionCode());
            mdmListConfigRespVo.setListConfigName(x.getFunctionName());
            return mdmListConfigRespVo;
        }).collect(Collectors.toList());
    }
}

