/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.IService;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.nebular.mdm.base.MdmRuleReqVo;
import com.biz.crm.util.DatabaseTypeUtil;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RuleCodeConvertUtil {
    public static <T extends MdmRuleReqVo, M extends CrmTreeEntity<M>, E extends IService<M>> void convert(T t, E e) {
        if (!StringUtils.isEmpty((Object)t.getParentId())) {
            QueryWrapper parentWrapper = (QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((Object)t.getParentId()), (Object)"id", (Object)t.getParentId());
            CrmTreeEntity parent = (CrmTreeEntity)e.getOne((Wrapper)parentWrapper, false);
            if (parent == null) {
                throw new BusinessException("\u4e0a\u7ea7\u4e0d\u5b58\u5728");
            }
            t.setParentId(parent.getId());
            QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((Object)t.getParentId()), (Object)"parent_id", (Object)t.getParentId())).last(DatabaseTypeUtil.SEGMENT_ITEM);
            List list = e.list((Wrapper)wrapper);
            if (!CollectionUtils.isEmpty((Collection)list)) {
                list.stream().max(Comparator.comparing(x -> {
                    String ruleCode = x.getRuleCode();
                    return Integer.parseInt(ruleCode.substring(ruleCode.lastIndexOf("-") + 1));
                })).ifPresent(maxBrother -> {
                    String ruleCode = maxBrother.getRuleCode();
                    String result = RuleCodeConvertUtil.getAndIncrementRuleCode(ruleCode);
                    t.setRuleCode(result);
                    t.setLevelNum(maxBrother.getLevelNum());
                });
            } else {
                t.setLevelNum(Integer.valueOf(parent.getLevelNum() + 1));
                t.setRuleCode(parent.getRuleCode() + "-1");
            }
        } else {
            t.setLevelNum(Integer.valueOf(1));
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((Object)t.getParentId()), (Object)"parent_id", (Object)t.getParentId());
            List list = e.list((Wrapper)wrapper);
            list.stream().max(Comparator.comparing(x -> {
                String ruleCode = x.getRuleCode();
                return Integer.parseInt(ruleCode.substring(ruleCode.lastIndexOf("-") + 1));
            })).ifPresent(maxBrother -> {
                String ruleCode = maxBrother.getRuleCode();
                String result = RuleCodeConvertUtil.getAndIncrementRuleCode(ruleCode);
                t.setRuleCode(result);
                t.setRuleCode(RuleCodeConvertUtil.getAndIncrementRuleCode(ruleCode));
            });
        }
    }

    private static String getAndIncrementRuleCode(String ruleCode) {
        if (StringUtils.isEmpty((Object)ruleCode)) {
            return "1";
        }
        if (!ruleCode.contains("-")) {
            return Integer.parseInt(ruleCode) + 1 + "";
        }
        String last = ruleCode.substring(ruleCode.lastIndexOf("-") + 1);
        String prefix = ruleCode.substring(0, ruleCode.lastIndexOf("-"));
        int max = Integer.parseInt(last);
        return prefix + "-" + (max + 1);
    }
}

