/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cusorg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.mapper.MdmCusOrgMapper;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.CrmTreeVo;
import com.biz.crm.nebular.mdm.common.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgConditionReqVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.MdmTerminalService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.TreeRuleCodeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCusOrgServiceExpandImpl"})
public class MdmCusOrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCusOrgMapper, MdmCusOrgEntity>
implements MdmCusOrgService {
    @Resource
    private MdmCusOrgMapper cusOrgMapper;
    @Resource
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private MdmTerminalService mdmTerminalService;

    @Override
    @Klock(leaseTime=1L, keys={"customer_org"})
    @Transactional(rollbackFor={Exception.class})
    public void add(CusOrgVo cusOrgVo) {
        Assert.hasText((String)cusOrgVo.getCustomerOrgName(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode())) {
            cusOrgVo.setCustomerOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_CUSTOMER_ORG.getCode()));
        } else {
            MdmCusOrgEntity one = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).one());
            Assert.isNull((Object)((Object)one), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
        }
        MdmCusOrgEntity name = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgName, (Object)cusOrgVo.getCustomerOrgName())).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)name), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
        MdmCusOrgEntity entity = (MdmCusOrgEntity)((Object)CrmBeanUtil.copy((Object)cusOrgVo, MdmCusOrgEntity.class));
        CrmTreeVo treeVo = this.generateRuleCodeByParentCode(entity.getParentCode());
        this.updateCurAndChildren(entity.getCustomerOrgCode(), treeVo.getRuleCode(), treeVo.getLevelNum());
        entity.setRuleCode(treeVo.getRuleCode());
        entity.setLevelNum(treeVo.getLevelNum());
        this.save((Object)entity);
    }

    @Override
    public CusOrgVo query(String id, String customerOrgCode) {
        MdmCusOrgEntity one = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)customerOrgCode), MdmCusOrgEntity::getCustomerOrgCode, (Object)customerOrgCode)).eq(!StringUtils.isEmpty((Object)id), BaseIdEntity::getId, (Object)id)).last(DatabaseTypeUtil.SEGMENT)).one());
        return (CusOrgVo)CrmBeanUtil.copy((Object)((Object)one), CusOrgVo.class);
    }

    @Override
    @Klock(leaseTime=1L, keys={"customer_org"})
    @Transactional(rollbackFor={Exception.class})
    public void edit(CusOrgVo cusOrgVo) {
        String id = cusOrgVo.getId();
        Assert.hasText((String)id, (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u5ba2\u6237\u7ec4\u7ec7!");
        MdmCusOrgEntity entity = (MdmCusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u8be5\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664");
        MdmCusOrgEntity one = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).ne(BaseIdEntity::getId, (Object)id)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
        MdmCusOrgEntity name = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgName, (Object)cusOrgVo.getCustomerOrgName())).ne(BaseIdEntity::getId, (Object)id)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)name), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
        String entityRuleCode = entity.getRuleCode();
        Assert.hasText((String)entityRuleCode, (String)"\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.isEmpty((Object)cusOrgVo.getParentCode())) {
            Assert.isTrue((!cusOrgVo.getParentCode().equals(cusOrgVo.getCustomerOrgCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u4e0e\u5ba2\u6237\u7ec4\u7ec7\u76f8\u540c");
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"customer_org_code", (Object)cusOrgVo.getParentCode());
            MdmCusOrgEntity parent = (MdmCusOrgEntity)((Object)this.getOne((Wrapper)wrapper, false));
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            if (!parent.getCustomerOrgCode().equals(entity.getParentCode())) {
                String ruleCode = parent.getRuleCode();
                Assert.hasText((String)ruleCode, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!ruleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7\u6216\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u5ba2\u6237\u7ec4\u7ec7");
            }
        }
        CrmBeanUtil.copyProperties((Object)cusOrgVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        CrmTreeVo treeVo = this.generateRuleCodeByParentCode(entity.getParentCode());
        this.updateCurAndChildren(entity.getCustomerOrgCode(), treeVo.getRuleCode(), treeVo.getLevelNum());
    }

    @Override
    public PageResult<CusOrgVo> list(CusOrgVo cusOrgVo) {
        MdmCusOrgEntity one;
        Page page = PageUtil.buildPage((Integer)cusOrgVo.getPageNum(), (Integer)cusOrgVo.getPageSize());
        if (!StringUtils.isEmpty((Object)cusOrgVo.getCode()) && (one = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCode())).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one())) != null) {
            cusOrgVo.setRuleCode(one.getRuleCode());
        }
        List<CusOrgVo> list = this.cusOrgMapper.list(page, cusOrgVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public CusOrgVo findById(String id) {
        return (CusOrgVo)CrmBeanUtil.copy((Object)this.getById((Serializable)((Object)id)), CusOrgVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void ableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, CrmTreeEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List<String> ruleCodeList = list.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList());
            Set<String> parentRuleCodesExcludeSelf = TreeRuleCodeUtil.splitParentRuleCodesExcludeAnySelf(ruleCodeList);
            if (!parentRuleCodesExcludeSelf.isEmpty()) {
                List parentList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeEntity::getRuleCode, parentRuleCodesExcludeSelf)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)parentList), (String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7");
            }
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
    }

    @Override
    @Klock(leaseTime=1L, keys={"customer_org"})
    @Transactional(rollbackFor={Exception.class})
    public void stateBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List customerOrgCodeList = list.stream().map(MdmCusOrgEntity::getCustomerOrgCode).collect(Collectors.toList());
            List childrenExcludeSelf = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmCusOrgEntity::getParentCode, customerOrgCodeList)).notIn(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)childrenExcludeSelf), (String)"\u5b58\u5728\u4e0b\u7ea7\u5ba2\u6237\u7ec4\u7ec7\uff0c\u4e0d\u80fd\u5220\u9664");
            List customerList = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().in(MdmCustomerEntity::getCustomerOrgCode, customerOrgCodeList)).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)customerList), (String)"\u5ba2\u6237\u7ec4\u7ec7\u5df2\u7ecf\u5173\u8054\u5ba2\u6237\uff0c\u4e0d\u80fd\u5220\u9664");
            List terminalList = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().in(MdmTerminalEntity::getCustomerOrgCode, customerOrgCodeList)).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)terminalList), (String)"\u5ba2\u6237\u7ec4\u7ec7\u5df2\u7ecf\u5173\u8054\u7ec8\u7aef\uff0c\u4e0d\u80fd\u5220\u9664");
            this.removeByIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, CrmTreeEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            List<String> ruleCodeList = list.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList());
            ruleCodeList.forEach(ruleCode -> ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().likeRight(CrmTreeEntity::getRuleCode, ruleCode)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update());
        }
    }

    @Override
    public List<MdmCustomerOrgSelectRespVo> customerOrgSelect(CusOrgVo cusOrgVo) {
        String currentCustomerOrgCode = cusOrgVo.getCurrentCustomerOrgCode();
        if (!StringUtils.isEmpty((Object)currentCustomerOrgCode)) {
            cusOrgVo.setCustomerOrgCode(currentCustomerOrgCode);
            return CrmBeanUtil.copyList(this.findUnSubList(cusOrgVo), MdmCustomerOrgSelectRespVo.class);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), MdmCusOrgEntity::getCustomerOrgName, (Object)cusOrgVo.getCustomerOrgName())).eq(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgLevel()), MdmCusOrgEntity::getCustomerOrgLevel, (Object)cusOrgVo.getCustomerOrgLevel())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId, MdmCusOrgEntity::getCustomerOrgCode, MdmCusOrgEntity::getCustomerOrgName}).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerOrgSelectRespVo.class);
    }

    @Override
    public List<BaseTreeRespVo> findBaseTreeConditionList(BaseTreeReqVo baseTreeReqVo) {
        return this.cusOrgMapper.findBaseTreeConditionList(baseTreeReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void setUpRuleCode() {
        this.cusOrgMapper.copyIdToRuleCode();
        this.cusOrgMapper.setNullNotExistParentCode();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmCusOrgEntity::getParentCode)).or()).eq(MdmCusOrgEntity::getParentCode, (Object)"")).select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode}).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((MdmCusOrgEntity)((Object)list.get(i))).getCustomerOrgCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
    }

    @Override
    public List<CusOrgVo> findUnSubList(CusOrgVo cusOrgVo) {
        String customerOrgCode = cusOrgVo.getCustomerOrgCode();
        if (StringUtils.isEmpty((Object)customerOrgCode)) {
            return Collections.emptyList();
        }
        String ruleCode = this.getRuleCode(customerOrgCode);
        Assert.hasText((String)ruleCode, (String)"ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        cusOrgVo.setRuleCode(ruleCode);
        return this.cusOrgMapper.ruleNotLikeRight(cusOrgVo);
    }

    @Override
    public List<CusOrgVo> findAllParentList(String customerOrgCode) {
        if (StringUtils.isEmpty((Object)customerOrgCode)) {
            return Collections.emptyList();
        }
        String ruleCode = this.getRuleCode(customerOrgCode);
        Assert.hasText((String)ruleCode, (String)"ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        Set<String> split = TreeRuleCodeUtil.splitParentRuleCodes(ruleCode);
        return this.listCondition(new MdmCustomerOrgConditionReqVo().setRuleCodeList(new ArrayList<String>(split)));
    }

    private String getRuleCode(String customerOrgCode) {
        if (StringUtils.isEmpty((Object)customerOrgCode)) {
            return customerOrgCode;
        }
        MdmCusOrgEntity one = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)customerOrgCode)).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one());
        Assert.notNull((Object)((Object)one), (String)("\u5ba2\u6237\u7ec4\u7ec7[" + customerOrgCode + "]\u4e0d\u5b58\u5728"));
        return one.getRuleCode();
    }

    @Override
    public List<CusOrgVo> listCondition(MdmCustomerOrgConditionReqVo mdmCustomerOrgConditionReqVo) {
        return this.cusOrgMapper.listCondition(mdmCustomerOrgConditionReqVo);
    }

    private CrmTreeVo generateRuleCodeByParentCode(String parentCode) {
        MdmCusOrgEntity parent;
        String ruleCode = "";
        int levelNum = 1;
        boolean top = true;
        String prefix = "";
        if (!StringUtils.isEmpty((Object)parentCode) && (parent = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)parentCode)).one())) != null) {
            top = false;
            prefix = parent.getRuleCode();
            levelNum = parent.getLevelNum() + 1;
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmCusOrgEntity::getParentCode)).or()).eq(MdmCusOrgEntity::getParentCode, (Object)"")).select(new SFunction[]{CrmTreeEntity::getRuleCode}).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmCusOrgEntity item : list) {
                if (StringUtils.isEmpty((Object)item.getRuleCode())) continue;
                Integer integer = Integer.valueOf(item.getRuleCode().substring(item.getRuleCode().length() - 3));
                set.add(integer);
            }
            for (int i = 1; i <= TreeRuleCodeUtil.getMaxRuleCodeValueInLevel(); ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(i);
                break;
            }
        }
        CrmTreeVo treeVo = new CrmTreeVo();
        treeVo.setRuleCode(ruleCode);
        treeVo.setLevelNum(Integer.valueOf(levelNum));
        return treeVo;
    }

    private void updateCurAndChildren(String customerOrgCode, String ruleCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)customerOrgCode)).set(CrmTreeEntity::getRuleCode, (Object)ruleCode)).set(CrmTreeEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmCusOrgEntity::getParentCode, (Object)customerOrgCode)).select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmCusOrgEntity)((Object)list.get(i))).getCustomerOrgCode(), ruleCode + TreeRuleCodeUtil.numToSingleCode(i + 1), levelNum + 1);
            }
        }
    }
}

