/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.login.service.impl;

import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.customer.service.MdmCustomerROrgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.login.service.MdmDmsMallLoginService;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.login.MdmLoginReqVo;
import com.biz.crm.nebular.mdm.login.MdmLoginRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.Md5EncryptionAndDecryption;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDmsMallLoginServiceExpandImpl"})
public class MdmDmsMallLoginServiceImpl
implements MdmDmsMallLoginService {
    private static final Logger log = LoggerFactory.getLogger(MdmDmsMallLoginServiceImpl.class);
    @Autowired
    private MdmUserService mdmUserService;
    @Autowired
    private MdmCustomerMsgService mdmCustomerMsgService;
    @Autowired
    private MdmCustomerROrgService mdmCustomerROrgService;

    protected void storeRedis(MdmUserRespVo mdmUserRespVo, MdmCustomerMsgRespVo mdmCustomerMsgRespVo, String token, List<String> orgCodeList) {
        UserRedis userRedis = new UserRedis();
        userRedis.setUsername(mdmUserRespVo.getUserName());
        userRedis.setRealname(mdmUserRespVo.getFullName());
        userRedis.setCustname(mdmCustomerMsgRespVo.getCustomerName());
        userRedis.setCustcode(mdmCustomerMsgRespVo.getCustomerCode());
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            userRedis.setOrgcode(String.join((CharSequence)",", orgCodeList));
        }
        UserUtils.setUser((String)token, (UserRedis)userRedis);
    }

    protected MdmUserRespVo validUser(MdmLoginReqVo mdmLoginReqVo) {
        String enableStatus;
        String userName = mdmLoginReqVo.getUserName();
        String password = mdmLoginReqVo.getPassword();
        Assert.hasText((String)userName, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)password, (String)"\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmUserReqVo mdmUserReqVo = new MdmUserReqVo();
        mdmUserReqVo.setUserName(userName);
        MdmUserRespVo mdmUserRespVo = this.mdmUserService.queryBasic(mdmUserReqVo);
        Assert.notNull((Object)mdmUserRespVo, (String)"\u5ba2\u6237\u7528\u6237\u4e0d\u5b58\u5728");
        String userType = mdmUserRespVo.getUserType();
        Assert.hasText((String)userType, (String)"\u7528\u6237\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)UserTypeEnum.CUSTOMER.getCode().equals(userType), (String)"\u5ba2\u6237\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u7cfb\u7edf\u767b\u5f55]\u7528\u6237\u4fe1\u606f:{}", (Object)mdmUserRespVo);
        String encryPwd = Md5EncryptionAndDecryption.encryPwd((String)password);
        String startTime = mdmUserRespVo.getStartTime();
        String endTime = mdmUserRespVo.getEndTime();
        if (!StringUtils.isEmpty((Object)startTime) && !StringUtils.isEmpty((Object)endTime)) {
            String format = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            Assert.isTrue((format.compareTo(startTime) >= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u751f\u6548");
            Assert.isTrue((format.compareTo(endTime) <= 0 ? 1 : 0) != 0, (String)"\u7528\u6237\u5df2\u5931\u6548");
        }
        Assert.isTrue((!StringUtils.isEmpty((Object)(enableStatus = mdmUserRespVo.getEnableStatus())) && CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus) ? 1 : 0) != 0, (String)"\u7528\u6237\u672a\u542f\u7528");
        Assert.isTrue((!StringUtils.isEmpty((Object)encryPwd) && encryPwd.equals(mdmUserRespVo.getUserPassword()) ? 1 : 0) != 0, (String)"\u5bc6\u7801\u4e0d\u6b63\u786e");
        return mdmUserRespVo;
    }

    @Override
    public MdmLoginRespVo dmsMallLogin(MdmLoginReqVo mdmLoginReqVo) {
        MdmUserRespVo mdmUserRespVo = this.validUser(mdmLoginReqVo);
        MdmCustomerMsgRespVo mdmCustomerMsgRespVo = this.validCustomer(mdmUserRespVo);
        List<String> orgCodeList = this.mdmCustomerROrgService.findOrgCodeByCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
        String token = UUID.randomUUID().toString();
        this.storeRedis(mdmUserRespVo, mdmCustomerMsgRespVo, token, orgCodeList);
        MdmLoginRespVo mdmLoginRespVo = new MdmLoginRespVo();
        mdmLoginRespVo.setUserCode(mdmUserRespVo.getUserCode());
        mdmLoginRespVo.setLoginUserToken(token);
        mdmLoginRespVo.setUserName(mdmUserRespVo.getUserName());
        mdmLoginRespVo.setFullName(mdmUserRespVo.getFullName());
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            mdmLoginRespVo.setOrgCode(String.join((CharSequence)",", orgCodeList));
        }
        mdmLoginRespVo.setCustomerCode(mdmCustomerMsgRespVo.getCustomerCode());
        mdmLoginRespVo.setCustomerName(mdmCustomerMsgRespVo.getCustomerName());
        MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.query(null, mdmCustomerMsgRespVo.getCustomerCode());
        Assert.isTrue((customer != null && CrmEnableStatusEnum.ENABLE.getCode().equals(customer.getEnableStatus()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u4e0d\u5b58\u5728\u6216\u88ab\u7981\u7528");
        mdmLoginRespVo.setMdmCustomerMsgRespVo(customer);
        return mdmLoginRespVo;
    }

    @Override
    public void dmsMallLogout() {
        UserUtils.remove();
    }

    protected MdmCustomerMsgRespVo validCustomer(MdmUserRespVo mdmUserRespVo) {
        MdmCustomerMsgRespVo customer = this.mdmCustomerMsgService.getUserCurrentCustomer(mdmUserRespVo.getUserName());
        Assert.notNull((Object)customer, (String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u5173\u8054\u5ba2\u6237");
        log.info("[dms\u5546\u57ce\u767b\u5f55]\u5ba2\u6237\u4fe1\u606f\uff1a{}", (Object)customer);
        return customer;
    }
}

