/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.dict.mapper.MdmDictDataMapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.MdmDictAttrConfService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataSelectReqVo;
import com.biz.crm.nebular.mdm.dict.resp.DictDataVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataSelectRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.ReflectUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmDictDataServiceExpandImpl"})
public class MdmDictDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDictDataMapper, MdmDictDataEntity>
implements MdmDictDataService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictDataServiceImpl.class);
    @Resource
    private MdmDictDataMapper mdmDictDataMapper;
    @Resource
    private MdmDictTypeService mdmDictTypeService;
    @Resource
    private MdmDictAttrConfService mdmDictAttrConfService;

    @Override
    public List<MdmDictDataRespVo> treeList(MdmDictDataReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u7f3a\u5931\u5b57\u5178\u7c7b\u578b\u7f16\u7801");
        ArrayList<MdmDictDataRespVo> result = new ArrayList<MdmDictDataRespVo>();
        List<MdmDictDataRespVo> list = this.mdmDictDataMapper.findList(null, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<MdmDictDataRespVo> allList = this.getAllParentList(reqVo.getDictTypeCode(), list);
            List<MdmDictAttrConfRespVo> confList = this.mdmDictAttrConfService.findList(reqVo.getDictTypeCode());
            HashMap<String, Map> map = new HashMap<String, Map>(16);
            for (MdmDictAttrConfRespVo filed : confList) {
                Map dictMap;
                if (!StringUtils.isNotEmpty((String)filed.getSelectDictTypeCode()) || (dictMap = DictUtil.getDictValueMapsByCodes((String)filed.getSelectDictTypeCode())).isEmpty()) continue;
                map.put(filed.getExtField(), dictMap);
            }
            if (!map.isEmpty()) {
                allList.forEach(item -> map.forEach((k, v) -> {
                    Object fieldKy = ReflectUtil.getFiledValueByName((Object)item, (String)k);
                    if (fieldKy != null && v.containsKey(fieldKy.toString())) {
                        ReflectUtil.setFieldValue((Object)item, (String)k, v.get(fieldKy.toString()));
                    }
                }));
            }
            result.addAll(this.generateTree(allList));
            this.setPath(reqVo.getDictTypeCode(), result);
        }
        return result;
    }

    @Override
    public List<DictDataVo> tree(MdmDictDataReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u7f3a\u5931\u5b57\u5178\u7c7b\u578b\u7f16\u7801");
        List tree = DictUtil.tree((String)reqVo.getDictTypeCode());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)tree)) {
            return tree;
        }
        return new ArrayList<DictDataVo>();
    }

    @Override
    public Map<String, List<MdmDictDataSelectRespVo>> batchDictSelect(List<String> dictTypeCodeList) {
        HashMap<String, List<MdmDictDataSelectRespVo>> map = new HashMap<String, List<MdmDictDataSelectRespVo>>(16);
        if (CollectionUtil.listNotEmptyNotSizeZero(dictTypeCodeList)) {
            for (String dictTypeCode : dictTypeCodeList) {
                List list = DictUtil.list((String)dictTypeCode);
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)list)) continue;
                map.put(dictTypeCode, CrmBeanUtil.copyList((List)list, MdmDictDataSelectRespVo.class));
            }
        }
        return map;
    }

    @Override
    public List<JSONObject> list(MdmDictDataSelectReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u7f3a\u5931\u5b57\u5178\u7c7b\u578b\u7f16\u7801");
        ArrayList list = new ArrayList();
        if (StringUtils.isNotEmpty((String)reqVo.getParentDictCode())) {
            list.addAll(DictUtil.getChildrenList((String)reqVo.getDictTypeCode(), (String)reqVo.getParentDictCode()));
        } else {
            list.addAll(DictUtil.list((String)reqVo.getDictTypeCode()));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return list.stream().filter(item -> {
                if (StringUtils.isNotEmpty((String)reqVo.getDictValue())) {
                    return item.getDictValue().contains(reqVo.getDictValue());
                }
                return true;
            }).map(item -> {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("dictCode", (Object)item.getDictCode());
                jsonObject.put("dictValue", (Object)item.getDictValue());
                Map extendMap = item.getExtendMap();
                if (!extendMap.isEmpty()) {
                    for (Map.Entry entry : extendMap.entrySet()) {
                        jsonObject.put((String)entry.getKey(), entry.getValue());
                    }
                }
                return jsonObject;
            }).collect(Collectors.toList());
        }
        return new ArrayList<JSONObject>();
    }

    @Override
    public MdmDictDataRespVo query(String id) {
        MdmDictDataEntity entity;
        if (StringUtils.isNotEmpty((String)id) && (entity = (MdmDictDataEntity)((Object)this.getById((Serializable)((Object)id)))) != null) {
            MdmDictDataEntity parent;
            MdmDictDataRespVo copy = (MdmDictDataRespVo)CrmBeanUtil.copy((Object)((Object)entity), MdmDictDataRespVo.class);
            if (StringUtils.isNotEmpty((String)copy.getParentDictCode()) && (parent = (MdmDictDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)entity.getDictTypeCode())).eq(MdmDictDataEntity::getDictCode, (Object)entity.getDictCode())).select(new SFunction[]{BaseIdEntity::getId}).one())) != null) {
                copy.setParentId(parent.getId());
            }
            return copy;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDictDataReqVo reqVo) {
        MdmDictDataEntity parent;
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getDictCode(), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((!reqVo.getDictCode().contains("/") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c/\u201d");
        Assert.isTrue((!reqVo.getDictCode().contains(",") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c,\u201d");
        Assert.hasText((String)reqVo.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u5bf9\u5e94\u5b57\u5178\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDictTypeEntity dict = (MdmDictTypeEntity)((Object)((LambdaQueryChainWrapper)this.mdmDictTypeService.lambdaQuery().eq(MdmDictTypeEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).one());
        Assert.notNull((Object)((Object)dict), (String)"\u5bf9\u5e94\u5b57\u5178\u4e0d\u5b58\u5728");
        List uniqueList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).eq(MdmDictDataEntity::getDictCode, (Object)reqVo.getDictCode())).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)uniqueList), (String)"\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728");
        if (StringUtils.isNotEmpty((String)reqVo.getParentDictCode())) {
            parent = (MdmDictDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dict.getDictTypeCode())).eq(MdmDictDataEntity::getDictCode, (Object)reqVo.getParentDictCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728");
        } else if (StringUtils.isNotEmpty((String)reqVo.getParentId())) {
            parent = (MdmDictDataEntity)((Object)this.getById((Serializable)((Object)reqVo.getParentId())));
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)parent.getDictTypeCode().equals(reqVo.getDictTypeCode()), (String)"\u4e0a\u7ea7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5b57\u5178");
            reqVo.setParentDictCode(parent.getDictCode());
        }
        List confList = ((LambdaQueryChainWrapper)this.mdmDictAttrConfService.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)confList)) {
            for (MdmDictAttrConfEntity conf : confList) {
                Object filedValueByName;
                if (!YesNoEnum.yesNoEnum.ZERO.getValue().equals(conf.getRequired()) || (filedValueByName = ReflectUtil.getFiledValueByName((Object)reqVo, (String)conf.getExtField())) != null && !StringUtils.isEmpty((String)filedValueByName.toString())) continue;
                throw new BusinessException(conf.getFieldName() + "\u662f\u5fc5\u586b\u9879");
            }
        }
        MdmDictDataEntity entity = (MdmDictDataEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDictDataEntity.class));
        this.save((Object)entity);
        DictUtil.deleteRedisCache((String)dict.getDictTypeCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDictDataReqVo reqVo) {
        MdmDictDataEntity parent;
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        MdmDictDataEntity entity = (MdmDictDataEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
        Assert.hasText((String)reqVo.getDictCode(), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u5bf9\u5e94\u5b57\u5178\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)entity.getDictCode().equals(reqVo.getDictCode()), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        Assert.isTrue((boolean)entity.getDictTypeCode().equals(reqVo.getDictTypeCode()), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        List uniqueList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).eq(MdmDictDataEntity::getDictCode, (Object)reqVo.getDictCode())).ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)uniqueList), (String)"\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728");
        if (StringUtils.isNotEmpty((String)reqVo.getParentDictCode())) {
            parent = (MdmDictDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)entity.getDictTypeCode())).eq(MdmDictDataEntity::getDictCode, (Object)reqVo.getParentDictCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728");
        } else if (StringUtils.isNotEmpty((String)reqVo.getParentId())) {
            parent = (MdmDictDataEntity)((Object)this.getById((Serializable)((Object)reqVo.getParentId())));
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)parent.getDictTypeCode().equals(reqVo.getDictTypeCode()), (String)"\u4e0a\u7ea7\u4e0d\u5c5e\u4e8e\u5f53\u524d\u5b57\u5178");
            reqVo.setParentDictCode(parent.getDictCode());
        }
        List confList = ((LambdaQueryChainWrapper)this.mdmDictAttrConfService.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)confList)) {
            for (MdmDictAttrConfEntity conf : confList) {
                Object filedValueByName;
                if (!YesNoEnum.yesNoEnum.ZERO.getValue().equals(conf.getRequired()) || (filedValueByName = ReflectUtil.getFiledValueByName((Object)reqVo, (String)conf.getExtField())) != null && !StringUtils.isEmpty((String)filedValueByName.toString())) continue;
                throw new BusinessException(conf.getFieldName() + "\u662f\u5fc5\u586b\u9879");
            }
        }
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        DictUtil.deleteRedisCache((String)reqVo.getDictTypeCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u7a7a\u53c2\u6570");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).select(new SFunction[]{BaseIdEntity::getId, MdmDictDataEntity::getDictTypeCode, MdmDictDataEntity::getDictCode}).list();
        if (list != null) {
            List dictCodeList = list.stream().map(MdmDictDataEntity::getDictCode).collect(Collectors.toList());
            List children = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmDictDataEntity::getParentDictCode, dictCodeList)).select(new SFunction[]{BaseIdEntity::getId}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)children)) {
                HashSet<String> idsSet = new HashSet<String>(ids);
                List collect = children.stream().map(BaseIdEntity::getId).filter(idsSet::contains).collect(Collectors.toList());
                Assert.isTrue((boolean)CollectionUtil.listEmpty(collect), (String)"\u5b57\u5178\u5b58\u5728\u4e0b\u7ea7\u4e0d\u80fd\u5220\u9664");
            }
            list.stream().map(MdmDictDataEntity::getDictTypeCode).distinct().collect(Collectors.toList()).forEach(DictUtil::deleteRedisCache);
            this.removeByIds(ids);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteByDictTypeCode(String dictTypeCode) {
        Assert.hasText((String)dictTypeCode, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteExtFieldVal(String dictTypeCode, List<String> extList) {
        List list;
        if (StringUtils.isNotEmpty((String)dictTypeCode) && CollectionUtil.listNotEmptyNotSizeZero(extList) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).list()))) {
            list.forEach(item -> {
                for (String extField : extList) {
                    ReflectUtil.setFieldValue((Object)item, (String)extField, (Object)"");
                }
            });
            this.updateBatchById(list);
        }
    }

    private List<MdmDictDataRespVo> getAllParentList(String dictTypeCode, List<MdmDictDataRespVo> list) {
        ArrayList<MdmDictDataRespVo> result = new ArrayList<MdmDictDataRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            HashSet<String> dictCodeSet = new HashSet<String>();
            for (MdmDictDataRespVo item : list) {
                dictCodeSet.add(item.getDictCode());
                this.setParent(dictTypeCode, item.getParentDictCode(), dictCodeSet);
            }
            if (!dictCodeSet.isEmpty()) {
                List parentList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).in(MdmDictDataEntity::getDictCode, dictCodeSet)).list();
                result.addAll(CrmBeanUtil.copyList((List)parentList, MdmDictDataRespVo.class));
            }
        }
        return result;
    }

    private void setParent(String dictTypeCode, String parentDictCode, Set<String> dictCodeSet) {
        if (StringUtils.isNotEmpty((String)parentDictCode)) {
            if (dictCodeSet.contains(parentDictCode)) {
                return;
            }
            MdmDictDataEntity one = (MdmDictDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).eq(MdmDictDataEntity::getDictCode, (Object)parentDictCode)).select(new SFunction[]{MdmDictDataEntity::getDictCode, MdmDictDataEntity::getParentDictCode}).one());
            if (one != null) {
                dictCodeSet.add(parentDictCode);
                this.setParent(dictTypeCode, one.getParentDictCode(), dictCodeSet);
            }
        }
    }

    private List<MdmDictDataRespVo> generateTree(List<MdmDictDataRespVo> totalList) {
        totalList = totalList.stream().sorted(Comparator.comparing(MdmDictDataRespVo::getDictSort)).collect(Collectors.toList());
        ArrayList<MdmDictDataRespVo> treeList = new ArrayList<MdmDictDataRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, MdmDictDataRespVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmDictDataRespVo::getDictCode, v -> v));
        for (MdmDictDataRespVo mdmDictDataRespVo : totalList) {
            if (StringUtils.isEmpty((String)mdmDictDataRespVo.getParentDictCode()) || !totalMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                treeList.add(mdmDictDataRespVo);
                curLevelList.add(mdmDictDataRespVo);
                continue;
            }
            restList.add(mdmDictDataRespVo);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<MdmDictDataRespVo> restTempList = new ArrayList<MdmDictDataRespVo>();
            ArrayList<MdmDictDataRespVo> arrayList = new ArrayList<MdmDictDataRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(MdmDictDataRespVo::getDictCode, MdmDictDataRespVo::getDictCode));
            LinkedHashMap curLevelChildrenMap = new LinkedHashMap(16);
            for (MdmDictDataRespVo mdmDictDataRespVo : restList) {
                if (curLevelMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                    arrayList.add(mdmDictDataRespVo);
                    ArrayList<MdmDictDataRespVo> childrenList = new ArrayList<MdmDictDataRespVo>();
                    if (curLevelChildrenMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(mdmDictDataRespVo.getParentDictCode()));
                    }
                    childrenList.add(mdmDictDataRespVo);
                    curLevelChildrenMap.put(mdmDictDataRespVo.getParentDictCode(), childrenList);
                    continue;
                }
                restTempList.add(mdmDictDataRespVo);
            }
            for (MdmDictDataRespVo mdmDictDataRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(mdmDictDataRespVo.getDictCode())) continue;
                mdmDictDataRespVo.setChildren((List)curLevelChildrenMap.get(mdmDictDataRespVo.getDictCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(arrayList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

    private void setPath(String dictTypeCode, List<MdmDictDataRespVo> list) {
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            for (MdmDictDataRespVo item : list) {
                item.setPath(dictTypeCode + "/" + item.getDictCode());
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)item.getChildren())) continue;
                this.setPath(item.getPath(), item.getChildren());
            }
        }
    }
}

