/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.alibaba.fastjson.JSON;
import com.biz.crm.utils.Demo;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TreeUtil {
    public static <T> List<T> convert(List<T> origList, String idFieldName, String parentIdFieldName, String childrenFieldName) {
        HashMap<String, T> idMaps = new HashMap<String, T>();
        ArrayList<T> tempList = new ArrayList<T>();
        ArrayList<T> result = new ArrayList<T>();
        for (Object entity : origList) {
            String id = Objects.toString(TreeUtil.getFieldValue(entity, idFieldName), "");
            String parentId = Objects.toString(TreeUtil.getFieldValue(entity, parentIdFieldName), "");
            if (StringUtils.isEmpty((Object)id)) {
                throw new Exception("\u5b58\u5728id\u4e3a\u7a7a\u7684\u8d44\u6599");
            }
            idMaps.put(id, entity);
            if (StringUtils.isEmpty((Object)parentId)) {
                result.add(entity);
                continue;
            }
            Object parentEntity = idMaps.get(parentId);
            if (parentEntity == null) {
                tempList.add(entity);
                continue;
            }
            TreeUtil.setChildrenValue(childrenFieldName, entity, parentEntity);
        }
        for (Object entity : tempList) {
            String parentId = Objects.toString(TreeUtil.getFieldValue(entity, parentIdFieldName), "");
            Object parentEntity = idMaps.get(parentId);
            if (parentEntity == null) {
                throw new Exception("\u5b58\u5728\u5b64\u7acb\u7684\u5b50\u8282\u70b9");
            }
            TreeUtil.setChildrenValue(childrenFieldName, entity, parentEntity);
        }
        return result;
    }

    private static <T> void setChildrenValue(String childrenFieldName, T entity, T parentEntity) throws Exception {
        Object children = TreeUtil.getFieldValue(parentEntity, childrenFieldName);
        if (children == null) {
            ArrayList<T> childrenList = new ArrayList<T>();
            childrenList.add(entity);
            TreeUtil.setFieldValue(parentEntity, childrenFieldName, childrenList);
        } else {
            List childrenReal = (List)children;
            childrenReal.add(entity);
        }
    }

    private static <T> Object getFieldValue(T entity, String fieldName) throws Exception {
        Field field = ReflectionUtils.findField(entity.getClass(), (String)fieldName);
        if (field == null) {
            throw new Exception(String.format("\u5b57\u6bb5\u540d\u79f0[%s]\u4e0d\u5b58\u5728", fieldName));
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        Object result = ReflectionUtils.getField((Field)field, entity);
        field.setAccessible(accessible);
        return result;
    }

    private static <T> void setFieldValue(T entity, String fieldName, Object value) throws Exception {
        Field field = ReflectionUtils.findField(entity.getClass(), (String)fieldName);
        if (field == null) {
            throw new Exception(String.format("\u5b57\u6bb5\u540d\u79f0[%s]\u4e0d\u5b58\u5728", fieldName));
        }
        boolean accessible = field.isAccessible();
        field.setAccessible(true);
        ReflectionUtils.setField((Field)field, entity, (Object)value);
        field.setAccessible(accessible);
    }

    public static void main(String[] args) throws Exception {
        Demo demo;
        int i;
        ArrayList<Demo> list = new ArrayList<Demo>();
        for (i = 0; i < 5; ++i) {
            demo = new Demo(i, "\u4e00\u7ea7\u8282\u70b9" + i);
            list.add(demo);
        }
        for (i = 5; i < 15; ++i) {
            demo = new Demo(i, i % 5, "\u4e8c\u7ea7\u8282\u70b9" + i);
            list.add(demo);
        }
        for (i = 15; i < 100; ++i) {
            demo = new Demo(i, i % 10 + 5, "\u4e09\u7ea7\u8282\u70b9" + i);
            list.add(demo);
        }
        Demo demo2 = new Demo(100, 102, "\u975e\u6cd5\u8282\u70b9");
        list.add(demo2);
        List convert = TreeUtil.convert(list, "id", "pid", "children");
        String s = JSON.toJSONString(convert);
        System.out.println(s);
    }
}

