/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.button.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.button.mapper.MdmButtonRoleMapper;
import com.biz.crm.button.model.MdmButtonRoleEntity;
import com.biz.crm.button.service.MdmButtonRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleReqVo;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSubButtonVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmButtonRoleServiceExpandImpl"})
public class MdmButtonRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmButtonRoleMapper, MdmButtonRoleEntity>
implements MdmButtonRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmButtonRoleServiceImpl.class);
    @Resource
    private MdmButtonRoleMapper mdmButtonRoleMapper;

    @Override
    public PageResult<MdmButtonRoleRespVo> findList(MdmButtonRoleReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmButtonRoleRespVo> list = this.mdmButtonRoleMapper.findList((Page<MdmButtonRoleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmButtonRoleRespVo query(MdmButtonRoleReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmButtonRoleReqVo reqVo) {
        MdmButtonRoleEntity entity = (MdmButtonRoleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmButtonRoleEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmButtonRoleReqVo reqVo) {
        MdmButtonRoleEntity entity = (MdmButtonRoleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmButtonRoleReqVo reqVo) {
    }

    @Override
    public List<String> findButtonCodeByRole(List<String> roleCodeList, String parentCode, String functionCode) {
        Assert.notEmpty(roleCodeList, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmButtonRoleEntity::getRoleCode, roleCodeList)).eq(MdmButtonRoleEntity::getParentCode, (Object)parentCode)).eq(MdmButtonRoleEntity::getFunctionCode, (Object)functionCode)).select(new SFunction[]{MdmButtonRoleEntity::getButtonCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getButtonCode())).map(MdmButtonRoleEntity::getButtonCode).collect(Collectors.toList());
    }

    @Override
    public List<String> findButtonCodeByRole(String roleCode, String parentCode, String functionCode) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)parentCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)functionCode, (String)"\u529f\u80fd\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmButtonRoleEntity::getRoleCode, (Object)roleCode)).eq(MdmButtonRoleEntity::getParentCode, (Object)parentCode)).eq(MdmButtonRoleEntity::getFunctionCode, (Object)functionCode)).select(new SFunction[]{MdmButtonRoleEntity::getButtonCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getButtonCode())).map(MdmButtonRoleEntity::getButtonCode).collect(Collectors.toList());
    }

    @Override
    public void setUp(String roleCode, List<MdmRoleSubButtonVo> mdmRoleSubButtonVos) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (CollectionUtils.isEmpty(mdmRoleSubButtonVos)) {
            return;
        }
        List menuCodeList = mdmRoleSubButtonVos.stream().filter(x -> !StringUtils.isEmpty((Object)x.getParentCode())).map(MdmRoleSubButtonVo::getParentCode).distinct().collect(Collectors.toList());
        List functionCodeList = mdmRoleSubButtonVos.stream().filter(x -> !StringUtils.isEmpty((Object)x.getParentCode())).map(MdmRoleSubButtonVo::getFunctionCode).distinct().collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmButtonRoleEntity::getRoleCode, (Object)roleCode)).in(!CollectionUtils.isEmpty(menuCodeList), MdmButtonRoleEntity::getParentCode, menuCodeList)).in(!CollectionUtils.isEmpty(functionCodeList), MdmButtonRoleEntity::getFunctionCode, functionCodeList)).remove();
        List collect = mdmRoleSubButtonVos.stream().filter(x -> !StringUtils.isEmpty((Object)x.getButtonSelect()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(x.getButtonSelect())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(collect)) {
            List mdmButtonRoleEntities = collect.stream().map(x -> {
                MdmButtonRoleEntity mdmButtonRoleEntity = new MdmButtonRoleEntity();
                mdmButtonRoleEntity.setButtonCode(x.getButtonCode());
                mdmButtonRoleEntity.setFunctionCode(x.getFunctionCode());
                mdmButtonRoleEntity.setParentCode(x.getParentCode());
                mdmButtonRoleEntity.setRoleCode(roleCode);
                mdmButtonRoleEntity.setId(UUID.randomUUID().toString());
                return mdmButtonRoleEntity;
            }).collect(Collectors.toList());
            this.saveBatch(mdmButtonRoleEntities);
        }
    }
}

