/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.bpmrole.model.MdmBpmRoleEntity;
import com.biz.crm.bpmrole.service.MdmBpmRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRespVo;
import com.biz.crm.nebular.mdm.constant.PositionOperationEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionSelectTransportReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionDetailRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgPageRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.position.mapper.MdmPositionMapper;
import com.biz.crm.position.model.MdmPositionBpmRoleEntity;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.model.MdmPositionRoleEntity;
import com.biz.crm.position.model.MdmPositionUserEntity;
import com.biz.crm.position.service.MdmPositionBpmRoleService;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.position.service.MdmPositionUserService;
import com.biz.crm.positionlevel.service.MdmPositionLevelService;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.user.model.MdmUserEntity;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.TreeRuleCodeUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmPositionServiceExpandImpl"})
public class MdmPositionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionMapper, MdmPositionEntity>
implements MdmPositionService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionServiceImpl.class);
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmUserService mdmUserService;
    @Resource
    private MdmPositionLevelService mdmPositionLevelService;
    @Resource
    private MdmPositionUserService mdmPositionUserService;
    @Resource
    private MdmPositionRoleService mdmPositionRoleService;
    @Resource
    private MdmRoleService mdmRoleService;
    @Resource
    private MdmPositionBpmRoleService mdmPositionBpmRoleService;
    @Resource
    private MdmBpmRoleService mdmBpmRoleService;

    @Override
    public PageResult<MdmPositionPageRespVo> findList(MdmPositionPageReqVo reqVo) {
        MdmOrgRespVo org;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)reqVo.getCode()) && (org = this.mdmOrgService.detail(null, reqVo.getCode())) != null) {
            reqVo.setOrgRuleCode(org.getRuleCode());
        }
        List<MdmPositionPageRespVo> list = this.mdmPositionMapper.findList((Page<MdmPositionPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionRespVo detail(String id, String positionCode) {
        MdmPositionEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (one = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one())) != null) {
            MdmPositionRespVo resp = (MdmPositionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmPositionRespVo.class);
            List<MdmPositionUserOrgRespVo> positionUserOrgList = this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(one.getPositionCode()));
            if (CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList)) {
                resp.setUnionName(this.generateUnionName(positionUserOrgList.get(0).getOrgName(), positionUserOrgList.get(0).getPositionName(), positionUserOrgList.get(0).getFullName()));
            }
            resp.setRoleList(this.mdmPositionRoleService.getPositionRoleList(one.getPositionCode()));
            resp.setBpmRoleList(this.mdmPositionBpmRoleService.getPositionBpmRoleList(one.getPositionCode()));
            return resp;
        }
        return null;
    }

    @Override
    public MdmPositionDetailRespVo getPositionDetail(String id, String positionCode) {
        MdmPositionEntity one;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (one = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(!StringUtils.isEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one())) != null) {
            MdmUserEntity userEntity;
            String userName;
            MdmPositionDetailRespVo resp = (MdmPositionDetailRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmPositionDetailRespVo.class);
            if (StringUtils.isNotEmpty((String)resp.getOrgCode())) {
                resp.setOrg(this.mdmOrgService.detail(null, resp.getOrgCode()));
            }
            if (StringUtils.isNotEmpty((String)(userName = this.mdmPositionUserService.getUserNameByPositionCode(resp.getPositionCode()))) && (userEntity = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).one())) != null) {
                userEntity.setUserPassword(null);
                resp.setUser((MdmUserRespVo)CrmBeanUtil.copy((Object)((Object)userEntity), MdmUserRespVo.class));
            }
            resp.setRoleList(this.mdmPositionRoleService.getPositionRoleList(one.getPositionCode()));
            resp.setBpmRoleList(this.mdmPositionBpmRoleService.getPositionBpmRoleList(one.getPositionCode()));
            return resp;
        }
        return null;
    }

    @Override
    public List<MdmPositionUserOrgRespVo> detailBatch(List<String> ids, List<String> positionCodeList) {
        List positionList;
        ArrayList<MdmPositionUserOrgRespVo> list = new ArrayList<MdmPositionUserOrgRespVo>();
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(positionCodeList), MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list()))) {
            list.addAll(this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCodeList(positionList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList()))));
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String save(MdmPositionReqVo reqVo) {
        reqVo.setId(null);
        MdmPositionEntity entity = (MdmPositionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPositionEntity.class));
        if (StringUtils.isEmpty((String)entity.getPositionName())) {
            Assert.hasText((String)reqVo.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
            entity.setPositionName(this.mdmPositionLevelService.generatePositionNameByPositionLevelCode(reqVo.getPositionLevelCode()));
        }
        if (StringUtils.isEmpty((String)entity.getPositionCode())) {
            entity.setPositionCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u804c\u4f4d\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            MdmPositionEntity parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getParentCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(levelNum);
        entity.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        this.save((Object)entity);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRoleCodeList())) {
            this.mdmPositionRoleService.addRole(reqVo.getRoleCodeList(), entity.getPositionCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getBpmRoleCodeList())) {
            this.mdmPositionBpmRoleService.addPositionBpmRole(entity.getPositionCode(), reqVo.getBpmRoleCodeList());
        }
        this.updatePositionRoleRedundancy(Collections.singletonList(entity.getPositionCode()));
        return entity.getPositionCode();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPositionReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getPositionName(), (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPositionEntity entity = (MdmPositionEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)entity.getPositionCode().equals(reqVo.getPositionCode()), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        String entityRuleCode = entity.getRuleCode();
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getPositionCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u4e3a\u5f53\u524d\u804c\u4f4d");
            if (!parentCode.equals(entity.getParentCode())) {
                reloadRuleCode = true;
                MdmPositionEntity parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one());
                Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u804c\u4f4druleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u5f53\u524d\u804c\u4f4d\u7684\u4e0b\u7ea7\u804c\u4f4d");
                levelNum = parent.getLevelNum() + 1;
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentCode())) {
            reloadRuleCode = true;
            reqVo.setParentCode("");
        }
        this.mdmPositionRoleService.removePositionCode(reqVo.getPositionCode());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getRoleCodeList())) {
            this.mdmPositionRoleService.addRole(reqVo.getRoleCodeList(), entity.getPositionCode());
        }
        this.mdmPositionBpmRoleService.removeByPosition(reqVo.getPositionCode());
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getBpmRoleCodeList())) {
            this.mdmPositionBpmRoleService.addPositionBpmRole(entity.getPositionCode(), reqVo.getBpmRoleCodeList());
        }
        if (!entity.getEnableStatus().equals(reqVo.getEnableStatus()) && CrmEnableStatusEnum.DISABLE.getCode().equals(reqVo.getEnableStatus())) {
            this.disableBatch(Collections.singletonList(entity.getId()));
        }
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmPositionEntity.class));
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getPositionCode(), ruleCode, levelNum);
        }
        this.updatePositionRoleRedundancy(Collections.singletonList(entity.getPositionCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changePositionParent(String positionCode, String parentPositionCode) {
        MdmPositionEntity position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).one());
        Assert.notNull((Object)((Object)position), (String)("\u7f16\u7801" + positionCode + "\u4e0d\u5b58\u5728"));
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentPositionCode)) {
            MdmPositionEntity parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentPositionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{BaseIdEntity::getId, CrmTreeTenEntity::getLevelNum}).one());
            Assert.notNull((Object)((Object)parent), (String)("\u7f16\u7801" + parentPositionCode + "\u65e0\u6548"));
            levelNum = parent.getLevelNum() + 1;
        }
        String ruleCode = this.generateRuleCodeByParentCode(parentPositionCode);
        position.setRuleCode(ruleCode);
        position.setLevelNum(levelNum);
        position.setParentCode(parentPositionCode);
        this.updateById((Object)position);
        this.updateCurAndChildren(positionCode, ruleCode, levelNum);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateByPositionCode(MdmPositionReqVo reqVo) {
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPositionEntity entity = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).one());
        Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
        String entityRuleCode = entity.getRuleCode();
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getPositionCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u4e3a\u5f53\u524d\u804c\u4f4d");
            if (!parentCode.equals(entity.getParentCode())) {
                reloadRuleCode = true;
                MdmPositionEntity parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one());
                Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u804c\u4f4druleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u5f53\u524d\u804c\u4f4d\u7684\u4e0b\u7ea7\u804c\u4f4d");
                levelNum = parent.getLevelNum() + 1;
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentCode())) {
            reloadRuleCode = true;
            entity.setParentCode("");
        }
        entity.setPrimaryFlag(reqVo.getPrimaryFlag());
        entity.setOrgCode(reqVo.getOrgCode());
        entity.setParentCode(reqVo.getParentCode());
        this.updateById((Object)entity);
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getPositionCode(), ruleCode, levelNum);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        List mdmPositionEntities = this.mdmPositionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionEntities)) {
            mdmPositionEntities.forEach(o -> {
                MdmUserEntity userEntity;
                MdmPositionUserEntity positionUser;
                List children = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)o.getPositionCode())).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)children), (String)("\u804c\u4f4d[" + o.getPositionName() + "]\u5b58\u5728\u4e0b\u7ea7\uff0c\u4e0d\u80fd\u5220\u9664"));
                if (YesNoEnum.yesNoEnum.ONE.getValue().equals(o.getPrimaryFlag()) && (positionUser = (MdmPositionUserEntity)((Object)((Object)((LambdaQueryChainWrapper)this.mdmPositionUserService.lambdaQuery().eq(MdmPositionUserEntity::getPositionCode, (Object)o.getPositionCode())).select(new SFunction[]{MdmPositionUserEntity::getUserName}).one()))) != null && (userEntity = (MdmUserEntity)((Object)((Object)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)positionUser.getUserName())).select(new SFunction[]{MdmUserEntity::getFullName}).one()))) != null) {
                    throw new BusinessException("\u804c\u4f4d[" + o.getPositionName() + "]\u662f\u7528\u6237[" + userEntity.getFullName() + "]\u7684\u4e3b\u804c\u4f4d\uff0c\u4e0d\u80fd\u5220\u9664");
                }
                o.setDelFlag(CrmDelFlagEnum.DELETE.getCode());
                o.setRuleCode(o.getId());
            });
            this.mdmPositionUserService.removeByPositionCodes(mdmPositionEntities.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList()));
            this.updateBatchById(mdmPositionEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        List mdmPositionEntities = this.mdmPositionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionEntities)) {
            mdmPositionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmPositionEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        List mdmPositionEntities = this.mdmPositionMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)mdmPositionEntities)) {
            mdmPositionEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmPositionEntities);
    }

    @Override
    public List<MdmPositionRespVo> findAllParentPositionList(String id, String positionCode) {
        MdmPositionEntity position;
        ArrayList<MdmPositionRespVo> list = new ArrayList<MdmPositionRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one())) != null) {
            Set ruleCodeSet = TreeRuleCodeUtil.splitParentRuleCodes((String)position.getRuleCode());
            List parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)ruleCodeSet)).list();
            list.addAll(CrmBeanUtil.copyList((List)parentList, MdmPositionRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmPositionRespVo> findAllChildrenPositionList(String id, String positionCode) {
        MdmPositionEntity position;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).likeRight(CrmTreeTenEntity::getRuleCode, (Object)position.getRuleCode())).list();
            return CrmBeanUtil.copyList((List)list, MdmPositionRespVo.class);
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    @Override
    public List<String> findAllChildrenPositionCodeList(String id, String positionCode) {
        MdmPositionEntity position;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)position.getRuleCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
            return list.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmPositionRespVo> findAllChildrenPositionListByList(List<String> ids, List<String> positionCodeList) {
        List list;
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(positionCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(positionCodeList), MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionEntity::getPositionCode, CrmTreeTenEntity::getRuleCode}).list()))) {
            List<String> likeRightRuleCodeList = list.stream().map(item -> item.getRuleCode() + "%").collect(Collectors.toList());
            return this.mdmPositionMapper.findPositionChildrenByRuleCodeList(new MdmPositionReqVo(), likeRightRuleCodeList);
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    @Override
    public List<MdmPositionRespVo> findSingleChildrenPositionList(String id, String positionCode) {
        List children;
        MdmPositionEntity position;
        ArrayList<MdmPositionRespVo> list = new ArrayList<MdmPositionRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one())) != null && CollectionUtil.listNotEmptyNotSizeZero((List)(children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)position.getPositionCode())).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)children, MdmPositionRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmPositionSelectRespVo> findPositionSelectList(MdmPositionSelectReqVo reqVo) {
        List<String> childrenOrgCodeList;
        MdmPositionEntity position;
        MdmOrgEntity org;
        MdmPositionSelectTransportReqVo transportReqVo = new MdmPositionSelectTransportReqVo();
        HashSet excludeOrgCodeList = new HashSet(16);
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode()) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getAllUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            transportReqVo.setAllUnderOrgRuleCode(org.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode()) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getAllUnderThisPositionCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            transportReqVo.setAllUnderPositionRuleCode(position.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisPositionCode()) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getNotUnderThisPositionCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            transportReqVo.setNotUnderPositionRuleCode(position.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllAboveThisOrgCode())) {
            List<MdmOrgRespVo> allParentOrgList = this.mdmOrgService.findAllParentOrgList(null, reqVo.getAllAboveThisOrgCode());
            if (CollectionUtil.listEmpty(allParentOrgList)) {
                return new ArrayList<MdmPositionSelectRespVo>();
            }
            transportReqVo.setOrgCodeList(allParentOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList()));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisOrgCodeExcludeSelf()) && CollectionUtil.listNotEmptyNotSizeZero(childrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, reqVo.getNotUnderThisOrgCodeExcludeSelf()))) {
            excludeOrgCodeList.addAll(childrenOrgCodeList.stream().filter(item -> !item.equals(reqVo.getNotUnderThisOrgCodeExcludeSelf())).collect(Collectors.toSet()));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getExcludeChildOrgOfThisPositionCode()) && StringUtils.isNotEmpty((String)reqVo.getExcludeChildOrgOfThisPositionCode()) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getExcludeChildOrgOfThisPositionCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getOrgCode}).one())) != null) {
            List<String> excludeChildrenOrgCodeList;
            Set collect;
            List<MdmPositionRespVo> allChildrenPositionCodeList;
            HashSet<String> includeOrgCodeSet = new HashSet<String>(16);
            if (StringUtils.isNotEmpty((String)position.getOrgCode())) {
                includeOrgCodeSet.add(position.getOrgCode());
            }
            if (CollectionUtil.listNotEmptyNotSizeZero(allChildrenPositionCodeList = this.findAllChildrenPositionList(null, position.getPositionCode())) && !(collect = allChildrenPositionCodeList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet())).isEmpty() && CollectionUtil.listNotEmptyNotSizeZero(excludeChildrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeListByList(null, new ArrayList<String>(collect)))) {
                excludeOrgCodeList.addAll(excludeChildrenOrgCodeList.stream().filter(item -> !includeOrgCodeSet.contains(item)).collect(Collectors.toList()));
            }
        }
        transportReqVo.setExcludeOrgCodeList(new ArrayList(excludeOrgCodeList));
        ArrayList<MdmPositionSelectRespVo> list = new ArrayList<MdmPositionSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmPositionMapper.findPositionSelectList2((Page<MdmPositionSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, transportReqVo));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName())));
        }
        return list;
    }

    @Override
    public List<MdmPositionSelectRespVo> positionCanUsedToRelateUserList(MdmPositionSelectReqVo reqVo) {
        MdmPositionEntity position;
        MdmOrgEntity org;
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode()) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getAllUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            reqVo.setAllUnderOrgRuleCode(org.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode()) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getAllUnderThisPositionCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            reqVo.setAllUnderPositionRuleCode(position.getRuleCode());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisPositionCode()) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getNotUnderThisPositionCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            reqVo.setNotUnderPositionRuleCode(position.getRuleCode());
        }
        ArrayList<MdmPositionSelectRespVo> list = new ArrayList<MdmPositionSelectRespVo>();
        ArrayList<String> codeList = new ArrayList<String>();
        if (StringUtils.isNotEmpty((String)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
            List<MdmPositionSelectRespVo> selectedList = this.mdmPositionMapper.positionCanUsedToRelateUserList((Page<MdmPositionSelectRespVo>)new Page(1L, (long)codeList.size(), false), reqVo, codeList, null);
            if (CollectionUtil.listNotEmptyNotSizeZero(selectedList)) {
                list.addAll(selectedList);
                pageSize = pageSize - selectedList.size();
            }
        }
        if (pageSize > 0) {
            list.addAll(this.mdmPositionMapper.positionCanUsedToRelateUserList((Page<MdmPositionSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo, null, codeList));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName())));
        }
        return list;
    }

    @Override
    public MdmPositionRespVo getUserPrimaryPosition(MdmUserReqVo reqVo) {
        List<MdmPositionRespVo> positionRelation = this.mdmPositionMapper.findPositionRelation(new MdmPositionReqVo().setUserName(reqVo.getUserName()).setUserId(reqVo.getId()));
        if (CollectionUtil.listNotEmptyNotSizeZero(positionRelation)) {
            for (MdmPositionRespVo positionItem : positionRelation) {
                if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(positionItem.getPrimaryFlag())) continue;
                return positionItem;
            }
        }
        return null;
    }

    @Override
    public MdmPositionRespVo getUserCurrentPosition(MdmUserReqVo reqVo) {
        MdmUserRespVo userRespVo = this.mdmUserService.detail(null, reqVo.getUserName());
        if (userRespVo != null && UserTypeEnum.USER.getCode().equals(userRespVo.getUserType()) && CollectionUtil.listNotEmptyNotSizeZero((List)userRespVo.getPositionList())) {
            MdmPositionRespVo primaryPosition = null;
            for (MdmPositionRespVo positionItem : userRespVo.getPositionList()) {
                if (YesNoEnum.yesNoEnum.ONE.getValue().equals(positionItem.getPrimaryFlag())) {
                    primaryPosition = positionItem;
                }
                if (!YesNoEnum.yesNoEnum.ONE.getValue().equals(positionItem.getCurrentFlag())) continue;
                return positionItem;
            }
            if (primaryPosition != null) {
                this.changeUserCurrentPosition(new MdmPositionReqVo().setPositionCode(primaryPosition.getPositionCode()).setUserName(userRespVo.getUserName()));
                return primaryPosition;
            }
        }
        return null;
    }

    @Override
    public MdmPositionRespVo getUserCurrentPositionForLogin(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            MdmUserEntity user = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).select(new SFunction[]{BaseIdEntity::getId, MdmUserEntity::getUserName}).one());
            Assert.notNull((Object)((Object)user), (String)"\u672a\u627e\u5230\u7528\u6237");
            String currentPositionCode = this.getCurrentPositionCodeByUserName(userName);
            Assert.hasText((String)currentPositionCode, (String)"\u7528\u6237\u804c\u4f4d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            MdmPositionEntity one = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)currentPositionCode)).one());
            if (one != null) {
                return (MdmPositionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmPositionRespVo.class);
            }
        }
        return null;
    }

    @Override
    public MdmPositionUserOrgRespVo getCurrentPositionByUserName(String userName) {
        if (StringUtils.isNotEmpty((String)userName)) {
            MdmUserEntity user = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserName, (Object)userName)).select(new SFunction[]{BaseIdEntity::getId, MdmUserEntity::getUserName}).one());
            Assert.notNull((Object)((Object)user), (String)"\u672a\u627e\u5230\u7528\u6237");
            String currentPositionCode = this.getCurrentPositionCodeByUserName(userName);
            Assert.hasText((String)currentPositionCode, (String)"\u7528\u6237\u804c\u4f4d\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
            return this.getPositionUserOrgByPositionCode(currentPositionCode);
        }
        return null;
    }

    @Override
    public List<MdmPositionRespVo> getUserAllPositionList(MdmUserReqVo reqVo) {
        return this.getUserAllPositionList(reqVo.getUserName());
    }

    @Override
    public List<MdmPositionRespVo> getUserAllPositionList(String userName) {
        List<MdmPositionRespVo> list = this.mdmPositionMapper.findPositionRelation(new MdmPositionReqVo().setUserName(userName));
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> {
                item.setRoleList(this.mdmPositionRoleService.getPositionRoleList(item.getPositionCode()));
                item.setOperationType(PositionOperationEnum.HISTORY.getCode());
                item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName()));
                item.setBpmRoleList(new ArrayList());
                List positionBpmRoleList = ((LambdaQueryChainWrapper)this.mdmPositionBpmRoleService.lambdaQuery().eq(MdmPositionBpmRoleEntity::getPositionCode, (Object)item.getPositionCode())).select(new SFunction[]{MdmPositionBpmRoleEntity::getBpmRoleCode}).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)positionBpmRoleList)) {
                    List bpmRoleList = ((LambdaQueryChainWrapper)this.mdmBpmRoleService.lambdaQuery().in(MdmBpmRoleEntity::getBpmRoleCode, (Collection)positionBpmRoleList.stream().map(MdmPositionBpmRoleEntity::getBpmRoleCode).collect(Collectors.toList()))).select(new SFunction[]{BaseIdEntity::getId, MdmBpmRoleEntity::getBpmRoleCode, MdmBpmRoleEntity::getBpmRoleName}).list();
                    item.setBpmRoleList(CrmBeanUtil.copyList((List)bpmRoleList, MdmBpmRoleRespVo.class));
                }
            });
        }
        return list;
    }

    @Override
    public List<MdmPositionRespVo> getUserPositionByUserCode(String userCode) {
        MdmUserEntity one;
        if (StringUtils.isNotEmpty((String)userCode) && (one = (MdmUserEntity)((Object)((LambdaQueryChainWrapper)this.mdmUserService.lambdaQuery().eq(MdmUserEntity::getUserCode, (Object)userCode)).select(new SFunction[]{MdmUserEntity::getUserName}).one())) != null) {
            return this.getUserAllPositionList(one.getUserName());
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserPrimaryPosition(MdmPositionReqVo reqVo) {
        MdmUserRespVo userRespVo;
        if (StringUtils.isNotEmpty((String)reqVo.getUserName()) && StringUtils.isNotEmpty((String)reqVo.getPositionCode()) && (userRespVo = this.mdmUserService.detail(null, reqVo.getUserName())) != null && UserTypeEnum.USER.getCode().equals(userRespVo.getUserType()) && CollectionUtil.listNotEmptyNotSizeZero((List)userRespVo.getPositionList())) {
            List positionCodeList = userRespVo.getPositionList().stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (positionCodeList.contains(reqVo.getPositionCode())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().ne(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).set(MdmPositionEntity::getPrimaryFlag, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).set(MdmPositionEntity::getPrimaryFlag, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
            } else {
                throw new BusinessException("\u8be5\u7528\u6237\u6ca1\u6709\u5173\u8054\u8be5\u804c\u4f4d");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserCurrentPosition(MdmPositionReqVo reqVo) {
        Assert.hasText((String)reqVo.getUserName(), (String)"\u7f3a\u5931\u7528\u6237\u540d");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        MdmUserRespVo userRespVo = this.mdmUserService.detail(null, reqVo.getUserName());
        Assert.notNull((Object)userRespVo, (String)"\u7528\u6237\u540d\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)UserTypeEnum.USER.getCode().equals(userRespVo.getUserType()), (String)"\u8be5\u7528\u6237\u4e0d\u662f\u4f01\u4e1a\u7528\u6237");
        if (CollectionUtil.listNotEmptyNotSizeZero((List)userRespVo.getPositionList())) {
            List positionCodeList = userRespVo.getPositionList().stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (!positionCodeList.contains(reqVo.getPositionCode())) {
                throw new BusinessException("\u8be5\u7528\u6237\u6ca1\u6709\u5173\u8054\u8be5\u804c\u4f4d");
            }
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().ne(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).set(MdmPositionEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).set(MdmPositionEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
            UserRedis user = UserUtils.getUser();
            String token = UserUtils.getToken();
            if (user != null && user.getUsername().equals(reqVo.getUserName()) && StringUtils.isNotEmpty((String)token)) {
                UserRedis userRedis = new UserRedis();
                List<MdmPositionUserOrgRespVo> positionUserOrgList = this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(reqVo.getPositionCode()));
                if (CollectionUtil.listNotEmptyNotSizeZero(positionUserOrgList)) {
                    MdmPositionUserOrgRespVo positionUserOrg = positionUserOrgList.get(0);
                    userRedis.setUsername(positionUserOrg.getUserName());
                    userRedis.setRealname(positionUserOrg.getFullName());
                    userRedis.setPoscode(positionUserOrg.getPositionCode());
                    userRedis.setPosname(positionUserOrg.getPositionName());
                    userRedis.setOrgcode(positionUserOrg.getOrgCode());
                    userRedis.setOrgname(positionUserOrg.getOrgName());
                    UserUtils.setUser((String)token, (UserRedis)userRedis);
                }
            }
        }
    }

    @Override
    public MdmPositionUserOrgRespVo getPositionUserOrgByPositionCode(String positionCode) {
        List<MdmPositionUserOrgRespVo> list;
        if (StringUtils.isNotEmpty((String)positionCode) && CollectionUtil.listNotEmptyNotSizeZero(list = this.findPositionUserOrgList(new MdmPositionUserOrgReqVo().setPositionCode(positionCode)))) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<MdmPositionUserOrgRespVo> findPositionUserOrgList(MdmPositionUserOrgReqVo reqVo) {
        List childrenPositionCodeList;
        List<MdmPositionRespVo> childrenPositionList;
        List childrenOrgCodeList;
        List<MdmOrgRespVo> childrenOrgList;
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCode());
            if (CollectionUtil.listEmpty(childrenOrgList)) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenOrgCodeList = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCodeExcludeSelf())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenOrgList) || childrenOrgList.size() == 1) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenOrgCodeList = childrenOrgList.stream().filter(item -> !item.getOrgCode().equals(reqVo.getAllUnderThisOrgCodeExcludeSelf())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCode());
            if (CollectionUtil.listEmpty(childrenPositionList)) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenPositionCodeList = childrenPositionList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCodeExcludeSelf())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenPositionList) || childrenPositionList.size() == 1) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenPositionCodeList = childrenPositionList.stream().filter(item -> !item.getPositionCode().equals(reqVo.getAllUnderThisPositionCodeExcludeSelf())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        return this.mdmPositionMapper.findPositionUserOrgList(null, reqVo);
    }

    @Override
    public PageResult<MdmPositionUserOrgPageRespVo> findPositionUserOrgPageList(MdmPositionUserOrgPageReqVo reqVo) {
        List childrenPositionCodeList;
        List<MdmPositionRespVo> childrenPositionList;
        List childrenOrgCodeList;
        List<MdmOrgRespVo> childrenOrgList;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCode());
            if (CollectionUtil.listEmpty(childrenOrgList)) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenOrgCodeList = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCodeExcludeSelf())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenOrgList) || childrenOrgList.size() == 1) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenOrgCodeList = childrenOrgList.stream().filter(item -> !item.getOrgCode().equals(reqVo.getAllUnderThisOrgCodeExcludeSelf())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCode());
            if (CollectionUtil.listEmpty(childrenPositionList)) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenPositionCodeList = childrenPositionList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCodeExcludeSelf())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenPositionList) || childrenPositionList.size() == 1) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenPositionCodeList = childrenPositionList.stream().filter(item -> !item.getPositionCode().equals(reqVo.getAllUnderThisPositionCodeExcludeSelf())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        List<MdmPositionUserOrgPageRespVo> list = this.mdmPositionMapper.findPositionUserOrgPageList((Page<MdmPositionUserOrgPageRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdatePositionOrg(MdmPositionUserOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getPositionCodeList(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        Assert.notNull((Object)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.detail(null, reqVo.getOrgCode());
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        List positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, (Collection)reqVo.getPositionCodeList())).select(new SFunction[]{MdmPositionEntity::getPositionCode, MdmPositionEntity::getPositionName, MdmPositionEntity::getOrgCode}).list();
        Assert.notEmpty((Collection)positionList, (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7f16\u7801");
        Map<String, MdmPositionEntity> positionMap = positionList.stream().collect(Collectors.toMap(MdmPositionEntity::getPositionCode, v -> v));
        reqVo.getPositionCodeList().forEach(positionCode -> {
            List<String> childrenOrgCodeList;
            Set collect;
            Assert.isTrue((boolean)positionMap.containsKey(positionCode), (String)("\u804c\u4f4d\u7f16\u7801[" + positionCode + "]\u65e0\u6548"));
            MdmPositionEntity position = (MdmPositionEntity)((Object)((Object)positionMap.get(positionCode)));
            List<MdmPositionRespVo> childrenPositionList = this.findAllChildrenPositionList(null, (String)positionCode);
            Set childrenPositionOrgCodeSet = childrenPositionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet());
            if (!childrenPositionOrgCodeSet.isEmpty() && !(collect = (childrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeListByList(null, new ArrayList<String>(childrenPositionOrgCodeSet))).stream().filter(item -> !StringUtils.isNotEmpty((String)position.getOrgCode()) || !item.equals(position.getOrgCode())).collect(Collectors.toSet())).isEmpty() && collect.contains(org.getOrgCode())) {
                throw new BusinessException("\u7ec4\u7ec7[" + org.getOrgName() + "]\u662f\u804c\u4f4d[" + position.getPositionName() + "]\u7684\u4e0b\u7ea7\u804c\u4f4d\u7684\u7ec4\u7ec7\uff08\u6216\u4e0b\u7ea7\u7ec4\u7ec7\uff09\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5f53\u524d\u804c\u4f4d\u7684\u7ec4\u7ec7");
            }
            List<MdmPositionRespVo> parentPositionList = this.findAllParentPositionList(null, (String)positionCode);
            Set parentPositionOrgCodeSet = parentPositionList.stream().filter(item -> StringUtils.isNotEmpty((String)item.getOrgCode())).map(MdmPositionRespVo::getOrgCode).collect(Collectors.toSet());
            if (!parentPositionOrgCodeSet.isEmpty()) {
                List orgList = ((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().in(MdmOrgEntity::getOrgCode, parentPositionOrgCodeSet)).select(new SFunction[]{MdmOrgEntity::getOrgCode, CrmTreeTenEntity::getRuleCode}).list();
                Set parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(orgList.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()));
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)parentRuleCodes)).ne(StringUtils.isNotEmpty((String)position.getOrgCode()), MdmOrgEntity::getOrgCode, (Object)position.getOrgCode())).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)list) && list.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toSet()).contains(org.getOrgCode())) {
                    throw new BusinessException("\u7ec4\u7ec7[" + org.getOrgName() + "]\u662f\u804c\u4f4d[" + position.getPositionName() + "]\u7684\u4e0a\u7ea7\u804c\u4f4d\u7684\u7ec4\u7ec7\uff08\u6216\u4e0a\u7ea7\u7ec4\u7ec7\uff09\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5f53\u524d\u804c\u4f4d\u7684\u7ec4\u7ec7");
                }
            }
        });
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionEntity::getPositionCode, (Collection)reqVo.getPositionCodeList())).set(MdmPositionEntity::getOrgCode, (Object)org.getOrgCode())).update();
    }

    @Override
    @Klock
    @Transactional(rollbackFor={Exception.class})
    public void resetPositionRuleCode() {
        this.mdmPositionMapper.copyIdToRuleCode();
        this.mdmPositionMapper.setNullNotExistParentCode();
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        wrapper.and(x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
        });
        List list = this.mdmPositionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), 1);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void resetPositionRoleRedundancy() {
        List positionList = this.lambdaQuery().select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionList)) {
            List<String> positionCodeList = positionList.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList());
            List<List<String>> lists = this.listGroupBySize(positionCodeList, 500);
            for (List<String> item : lists) {
                this.updatePositionRoleRedundancy(item);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updatePositionRoleRedundancy(List<String> positionCodeList) {
        List positionList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmPositionEntity::getPositionCode, positionCodeList)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionList)) {
            Map<Object, Object> roleEntityTempMap = new HashMap(16);
            Map<Object, Object> relationTempMap = new HashMap(16);
            List relationList = ((LambdaQueryChainWrapper)this.mdmPositionRoleService.lambdaQuery().in(MdmPositionRoleEntity::getPositionCode, positionCodeList)).select(new SFunction[]{MdmPositionRoleEntity::getRoleCode, MdmPositionRoleEntity::getPositionCode}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)relationList)) {
                relationTempMap = relationList.stream().collect(Collectors.groupingBy(MdmPositionRoleEntity::getPositionCode));
                List roleList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)relationList.stream().map(MdmPositionRoleEntity::getRoleCode).distinct().collect(Collectors.toList()))).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName}).list();
                if (CollectionUtil.listNotEmptyNotSizeZero((List)roleList)) {
                    roleEntityTempMap = roleList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, v -> v));
                }
            }
            HashMap relationMap = relationTempMap;
            HashMap roleEntityMap = roleEntityTempMap;
            positionList.forEach(item -> {
                ArrayList roleEntityList = new ArrayList();
                if (relationMap.containsKey(item.getPositionCode())) {
                    List positionRelationList = (List)relationMap.get(item.getPositionCode());
                    for (MdmPositionRoleEntity relationItem : positionRelationList) {
                        if (!roleEntityMap.containsKey(relationItem.getRoleCode())) continue;
                        roleEntityList.add(roleEntityMap.get(relationItem.getRoleCode()));
                    }
                }
                if (CollectionUtil.listNotEmptyNotSizeZero(roleEntityList)) {
                    List collect = roleEntityList.stream().sorted(Comparator.comparing(MdmRoleEntity::getRoleCode)).collect(Collectors.toList());
                    item.setRoleCodeRedundancy(collect.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.joining(",")));
                    item.setRoleNameRedundancy(collect.stream().map(MdmRoleEntity::getRoleName).collect(Collectors.joining(",")));
                } else {
                    item.setRoleCodeRedundancy("");
                    item.setRoleNameRedundancy("");
                }
            });
            this.updateBatchById(positionList);
        }
    }

    @Override
    public List<MdmPositionUserOrgRespVo> findPositionListByBpmRoleStartUpByOrgCode(String orgCode, String bpmRoleCode) {
        Assert.hasText((String)orgCode, (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.hasText((String)bpmRoleCode, (String)"\u7f3a\u5931\u6d41\u7a0b\u89d2\u8272\u7f16\u7801");
        MdmOrgEntity org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one());
        Assert.notNull((Object)((Object)org), (String)"\u7ec4\u7ec7\u7f16\u7801\u65e0\u6548");
        Set parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes((String)org.getRuleCode());
        List parentOrgList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, (Collection)parentRuleCodes)).select(new SFunction[]{MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName}).orderByDesc(CrmTreeTenEntity::getLevelNum)).list();
        List<String> collect = parentOrgList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList());
        List<MdmPositionUserOrgRespVo> list = this.mdmPositionMapper.findPositionListByBpmRole(CrmDelFlagEnum.NORMAL.getCode(), CrmEnableStatusEnum.ENABLE.getCode(), bpmRoleCode, collect);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            Map<String, List<MdmPositionUserOrgRespVo>> groupByOrgMap = list.stream().collect(Collectors.groupingBy(MdmPositionUserOrgRespVo::getOrgCode));
            for (MdmOrgEntity parentOrg : parentOrgList) {
                if (!groupByOrgMap.containsKey(parentOrg.getOrgCode())) continue;
                return groupByOrgMap.get(parentOrg.getOrgCode());
            }
        }
        return new ArrayList<MdmPositionUserOrgRespVo>();
    }

    @Override
    public List<String> findPositionExcludeOrgCodeList(List<String> positionCodeList) {
        return new ArrayList<String>();
    }

    private String generateUnionName(String orgName, String positionName, String fullName) {
        return (orgName == null ? "" : orgName) + "/" + (positionName == null ? "" : positionName) + "/" + (fullName == null ? "" : fullName);
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmPositionEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one())) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"del_flag", (Object)CrmDelFlagEnum.NORMAL.getCode());
        if (top) {
            wrapper.and(x -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.eq((Object)"parent_code", (Object)"")).or()).isNull((Object)"parent_code");
            });
        } else {
            wrapper.eq((Object)"parent_code", (Object)parentCode);
        }
        list = this.mdmPositionMapper.selectList((Wrapper)wrapper);
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmPositionEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                Integer integer = TreeRuleCodeUtil.getCurLevelCodeValue((String)item.getRuleCode());
                set.add(integer);
            }
            for (int i = 1; i <= TreeRuleCodeUtil.getMaxRuleCodeValueInLevel(); ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode((Integer)i);
                break;
            }
        }
        return ruleCode;
    }

    private void updateCurAndChildren(String positionCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)positionCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)positionCode)).eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), curCode + TreeRuleCodeUtil.numToSingleCode((Integer)(i + 1)), levelNum + 1);
            }
        }
    }

    private String getCurrentPositionCodeByUserName(String userName) {
        List list;
        if (StringUtils.isNotEmpty((String)userName) && CollectionUtil.listNotEmptyNotSizeZero((List)(list = ((LambdaQueryChainWrapper)this.mdmPositionUserService.lambdaQuery().eq(MdmPositionUserEntity::getUserName, (Object)userName)).select(new SFunction[]{MdmPositionUserEntity::getUserName, MdmPositionUserEntity::getPositionCode}).list()))) {
            List positionCodeList = list.stream().map(MdmPositionUserEntity::getPositionCode).collect(Collectors.toList());
            List positionList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getDelFlag, (Object)CrmDelFlagEnum.NORMAL.getCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).select(new SFunction[]{BaseIdEntity::getId, MdmPositionEntity::getPositionCode, CrmBaseEntity::getEnableStatus, MdmPositionEntity::getPrimaryFlag, MdmPositionEntity::getCurrentFlag}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionList)) {
                String currentPositionCode = "";
                List currentCodeList = positionList.stream().filter(item -> CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus()) && YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getCurrentFlag())).map(MdmPositionEntity::getPositionCode).collect(Collectors.toList());
                if (currentCodeList.size() == 1) {
                    currentPositionCode = (String)currentCodeList.get(0);
                } else if (currentCodeList.size() > 1) {
                    currentPositionCode = (String)currentCodeList.get(0);
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionEntity::getPositionCode, positionCodeList)).ne(MdmPositionEntity::getPositionCode, (Object)currentPositionCode)).set(MdmPositionEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ZERO.getValue())).update();
                } else {
                    List primaryList = positionList.stream().filter(item -> YesNoEnum.yesNoEnum.ONE.getValue().equals(item.getPrimaryFlag())).collect(Collectors.toList());
                    Assert.notEmpty(primaryList, (String)"\u7528\u6237\u6ca1\u6709\u4e3b\u804c\u4f4d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    Assert.isTrue((primaryList.size() == 1 ? 1 : 0) != 0, (String)"\u7528\u6237\u5b58\u5728\u591a\u4e2a\u4e3b\u804c\u4f4d\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
                    Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(((MdmPositionEntity)((Object)primaryList.get(0))).getEnableStatus()), (String)"\u7528\u6237\u4e3b\u804c\u4f4d\u88ab\u505c\u7528\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406");
                    currentPositionCode = ((MdmPositionEntity)((Object)primaryList.get(0))).getPositionCode();
                    ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)currentPositionCode)).set(MdmPositionEntity::getCurrentFlag, (Object)YesNoEnum.yesNoEnum.ONE.getValue())).update();
                }
                return currentPositionCode;
            }
        }
        return null;
    }

    private List<List<String>> listGroupBySize(List<String> list, int size) {
        ArrayList<List<String>> groupList = new ArrayList<List<String>>();
        int i = 0;
        ArrayList<String> itemList = new ArrayList<String>();
        for (String item : list) {
            itemList.add(item);
            if (++i < size) continue;
            groupList.add(new ArrayList(itemList));
            i = 0;
            itemList.clear();
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(itemList)) {
            groupList.add(itemList);
        }
        return groupList;
    }
}

