/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customermaterial.provider;

import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;

public class MdmCustomerMaterialProvider {
    public String findListProvider(final MdmCustomerMaterialReqVo vo) {
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*,b.material_name,c.customer_org_name");
                this.FROM("mdm_customer_material a");
                this.JOIN("mdm_material b on a.material_code=b.material_code");
                this.JOIN("mdm_cus_org c on c.customer_org_code=a.customer_org_code");
                if (StringUtils.isNotEmpty((String)vo.getCustomerOrgCode())) {
                    this.WHERE("a.customer_org_code like " + ProviderUtil.bindPercent(vo.getCustomerOrgCode(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getCustomerOrgName())) {
                    this.WHERE("c.customer_org_name like " + ProviderUtil.bindPercent(vo.getCustomerOrgName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getMaterialName())) {
                    this.WHERE("b.material_name like " + ProviderUtil.bindPercent(vo.getMaterialName(), MdmProviderEnum.SQL_JOIN_ALL));
                }
                if (StringUtils.isNotEmpty((String)vo.getDelFlag())) {
                    this.WHERE("a.del_flag =#{vo.delFlag}");
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("create_date desc,create_date_second desc");
            }
        }.toString();
    }
}

