/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.provider;

import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ProviderUtil;
import java.util.List;
import java.util.Objects;
import org.apache.ibatis.jdbc.SQL;

public class MdmPriceConditionProvider {
    public String findListGroup(final MdmPriceConditionGroupReqVo vo) {
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*");
                this.FROM("mdm_price_condition_group a");
                if (StringUtils.isNotEmpty((String)vo.getConditionGroupCode())) {
                    this.WHERE("a.condition_group_code like concat('%',#{vo.conditionGroupCode},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionGroupDesc())) {
                    this.WHERE("a.condition_group_desc like concat('%',#{vo.conditionGroupDesc},'%')");
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }

    public String findListType(final MdmPriceConditionTypeReqVo vo) {
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*");
                this.FROM("mdm_price_condition_type a");
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeCode())) {
                    this.WHERE("a.condition_type_code like concat('%',#{vo.conditionTypeCode},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeDesc())) {
                    this.WHERE("a.condition_type_desc like concat('%',#{vo.conditionTypeDesc},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeType())) {
                    this.WHERE("a.condition_type_type = #{vo.conditionTypeType}");
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }

    public String findListSetting(final MdmPriceSettingReqVo vo) {
        final List<MdmColumnConfigRespVo> cvo = ProviderUtil.gainConfigVo();
        return new SQL(){
            {
                this.SELECT("a.*,b.condition_type_desc conditionTypeDesc,mpcg.condition_group_desc conditionGroupDesc");
                this.FROM("mdm_price_setting a");
                this.LEFT_OUTER_JOIN("mdm_price_condition_type b on a.condition_type_code = b.condition_type_code");
                this.LEFT_OUTER_JOIN("mdm_price_condition_group mpcg on a.condition_group_code = mpcg.condition_group_code");
                if (StringUtils.isNotEmpty((String)vo.getPriceSettingCode())) {
                    this.WHERE("a.price_setting_code like concat('%',#{vo.priceSettingCode},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeCode())) {
                    this.WHERE("a.condition_type_code like concat('%',#{vo.conditionTypeCode},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getConditionTypeDesc())) {
                    this.WHERE("b.condition_type_desc like concat('%',#{vo.conditionTypeDesc},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getOrgCode())) {
                    this.WHERE("a.org_code like concat('%',#{vo.orgCode},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getOrgName())) {
                    this.WHERE("a.org_name like concat('%',#{vo.orgName},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getCustomerCode())) {
                    this.WHERE("a.customer_code like concat('%',#{vo.customerCode},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getCustomerName())) {
                    this.WHERE("a.customer_name like concat('%',#{vo.customerName},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getChannel())) {
                    this.WHERE("a.channel = #{vo.channel}");
                }
                if (StringUtils.isNotEmpty((String)vo.getProductCode())) {
                    this.WHERE("a.product_code like concat('%',#{vo.productCode},'%')");
                }
                if (StringUtils.isNotEmpty((String)vo.getProductName())) {
                    this.WHERE("a.product_name like concat('%',#{vo.productName},'%')");
                }
                if (!Objects.isNull(vo.getPrice())) {
                    this.WHERE("a.price = #{vo.price}");
                }
                if (StringUtils.isNotEmpty((String)vo.getCurrencyType())) {
                    this.WHERE("a.currency_type = #{vo.currencyType}");
                }
                if (StringUtils.isNotEmpty((String)vo.getBeginDate())) {
                    this.WHERE("a.begin_date &gt;= #{vo.beginDate}");
                }
                if (StringUtils.isNotEmpty((String)vo.getEndDate())) {
                    this.WHERE("a.end_date &lt;= #{vo.endDate}");
                }
                if (CollectionUtil.listNotEmptyNotSizeZero((List)cvo)) {
                    this.WHERE(ProviderUtil.gainExtendSql(cvo, "a"));
                }
                this.ORDER_BY("a.create_date desc,a.create_date_second desc");
            }
        }.toString();
    }
}

