/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.utils;

import com.biz.crm.eunm.mdm.MdmColumnSearchTypeEnum;
import com.biz.crm.eunm.mdm.MdmProviderEnum;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmColumnConfigRespVo;
import com.biz.crm.tableconfig.service.IMdmColumnConfigService;
import com.biz.crm.util.HttpServletRequestUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;

@Component
public class ProviderUtil {
    @Resource
    private IMdmColumnConfigService iMdmColumnConfigService;
    private static ProviderUtil providerUtil;

    @PostConstruct
    public void init() {
        providerUtil = this;
        ProviderUtil.providerUtil.iMdmColumnConfigService = this.iMdmColumnConfigService;
    }

    public static List<MdmColumnConfigRespVo> gainConfigVo() {
        HttpServletRequest request = HttpServletRequestUtil.getRequest();
        String functionCode = request.getHeader("functionCode");
        String menuCode = request.getHeader("menuCode");
        MdmColumnConfigReqVo configReqVo = new MdmColumnConfigReqVo();
        configReqVo.setFunctionCode(functionCode);
        configReqVo.setParentCode(menuCode);
        return ProviderUtil.providerUtil.iMdmColumnConfigService.listCondition(configReqVo);
    }

    public static List<MdmColumnConfigRespVo> getTestList() {
        ArrayList<MdmColumnConfigRespVo> vos = new ArrayList<MdmColumnConfigRespVo>();
        MdmColumnConfigRespVo vo = new MdmColumnConfigRespVo();
        vo.setField("1f");
        vo.setEntityFieldName("ext1");
        vo.setSearchType("1");
        MdmColumnConfigRespVo vo1 = new MdmColumnConfigRespVo();
        vo1.setField("2f");
        vo1.setEntityFieldName("ext2");
        vo1.setSearchType("0");
        vos.add(vo);
        vos.add(vo1);
        return vos;
    }

    public static String bindPercent(String itself, MdmProviderEnum mdmProviderEnum) {
        if (Objects.isNull(itself)) {
            itself = "";
        }
        switch (mdmProviderEnum) {
            case SQL_JOIN_LEFT: {
                itself = "%".concat(itself);
                break;
            }
            case SQL_JOIN_RIGHT: {
                itself = itself.concat("%");
                break;
            }
            case SQL_JOIN_ALL: {
                itself = "%".concat(itself).concat("%");
            }
        }
        return "'".concat(itself).concat("'");
    }

    public static String gainForeach(String open, String separator, String close, List<String> list) {
        StringBuffer buffer = new StringBuffer();
        if (StringUtils.isNotEmpty((String)open)) {
            buffer.append(open);
        }
        if (StringUtils.isEmpty((String)separator)) {
            separator = "";
        }
        for (String str : list) {
            buffer.append("'" + str + "'" + separator);
        }
        buffer.delete(buffer.length() - 1, buffer.length());
        if (StringUtils.isNotEmpty((String)close)) {
            buffer.append(close);
        }
        return buffer.toString();
    }

    public static String gainDynamicSql(String entityFieldName, String field, String searchType) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(entityFieldName);
        MdmColumnSearchTypeEnum typeEnum = MdmColumnSearchTypeEnum.getEnumByCode((String)searchType);
        switch (typeEnum) {
            case ACCURATE: {
                buffer.append(" = '" + field + "'");
                break;
            }
            case VAGUE: {
                buffer.append(" like '%" + field + "%'");
                break;
            }
        }
        String result = buffer.toString();
        return result.length() == entityFieldName.length() ? "" : result;
    }

    public static String gainExtendSql(List<MdmColumnConfigRespVo> cvo, String alias) {
        StringBuffer buffer = new StringBuffer();
        cvo.stream().filter(mdm -> StringUtils.isNotEmpty((String)mdm.getField()) && StringUtils.isNotEmpty((String)mdm.getEntityFieldName()) && StringUtils.isNotEmpty((String)mdm.getSearchType())).forEach(mdm -> {
            String sql = ProviderUtil.gainDynamicSql(mdm.getEntityFieldName(), mdm.getField(), mdm.getSearchType());
            if (StringUtils.isNotEmpty((String)sql)) {
                buffer.append(StringUtils.isEmpty((String)alias) ? sql : alias.concat(".").concat(sql));
                buffer.append(" AND ");
            }
        });
        if (buffer.length() > 3) {
            buffer.delete(buffer.lastIndexOf("AND"), buffer.length());
        }
        return buffer.toString();
    }
}

