/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.permission.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.mdm.MdmPermissionLevelEnum;
import com.biz.crm.eunm.mdm.MdmPermissionObjEnum;
import com.biz.crm.eunm.mdm.PermissionResourceEnum;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmCurrentUserPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionOrgVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionPositionVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionReqVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmListConfigRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjRespVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.permission.mapper.MdmDataPermissionMapper;
import com.biz.crm.permission.model.MdmDataPermissionEntity;
import com.biz.crm.permission.model.MdmDataPermissionExtendEntity;
import com.biz.crm.permission.service.IMdmDataPermissionExtendService;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DatabaseTypeUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmDataPermissionServiceExpandImpl"})
public class MdmDataPermissionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDataPermissionMapper, MdmDataPermissionEntity>
implements IMdmDataPermissionService {
    private static final Logger log = LoggerFactory.getLogger(MdmDataPermissionServiceImpl.class);
    @Resource
    private MdmDataPermissionMapper mdmDataPermissionMapper;
    @Autowired
    private MdmFunctionService mdmFunctionService;
    @Autowired
    private MdmFunctionRoleService mdmFunctionRoleService;
    @Autowired
    private MdmRoleService mdmRoleService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Autowired
    private IMdmDataPermissionExtendService mdmDataPermissionExtendService;
    @Autowired
    private MdmOrgService mdmOrgService;
    @Autowired
    private MdmPositionService mdmPositionService;
    @Autowired
    private MdmPositionRoleService mdmPositionRoleService;

    @Override
    @CrmDictMethod
    public PageResult<MdmDataPermissionRespVo> findList(MdmDataPermissionReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmDataPermissionRespVo> list = this.mdmDataPermissionMapper.findList((Page<MdmDataPermissionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmDataPermissionRespVo query(MdmDataPermissionReqVo reqVo) {
        MdmDataPermissionEntity one = (MdmDataPermissionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)reqVo.getId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (MdmDataPermissionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDataPermissionRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDataPermissionReqVo reqVo) {
        String listConfigCode = reqVo.getListConfigCode();
        Assert.hasText((String)listConfigCode, (String)"\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String functionCode = reqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleCode = reqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmDataPermissionEntity::getRoleCode, (Object)roleCode)).eq(MdmDataPermissionEntity::getFunctionCode, (Object)functionCode)).eq(MdmDataPermissionEntity::getListConfigCode, (Object)listConfigCode)).remove();
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.mdmDataPermissionExtendService.lambdaUpdate().eq(MdmDataPermissionExtendEntity::getRoleCode, (Object)roleCode)).eq(MdmDataPermissionExtendEntity::getFunctionCode, (Object)functionCode)).eq(MdmDataPermissionExtendEntity::getListConfigCode, (Object)listConfigCode)).remove();
        String permissionResource = reqVo.getPermissionResource();
        String permissionObjCode = reqVo.getPermissionObjCode();
        if (StringUtils.isEmpty((String)permissionResource) || StringUtils.isEmpty((String)permissionObjCode)) {
            return;
        }
        Assert.isTrue((boolean)MdmPermissionObjEnum.contain((String)permissionObjCode), (String)"\u6743\u9650\u5bf9\u8c61\u4f20\u53c2\u9519\u8bef");
        Assert.isTrue((boolean)PermissionResourceEnum.contain((String)permissionResource), (String)"\u6743\u9650\u6570\u636e\u6765\u6e90\u9519\u8bef");
        switch (MdmPermissionObjEnum.convertEnum((String)permissionObjCode)) {
            case POSITION: {
                this.storePosition(reqVo);
                break;
            }
            case ORG: {
                this.storeOrg(reqVo);
                break;
            }
            case CUSTOMER: {
                this.storeCustomer(reqVo);
                break;
            }
            case CUSTOMER_ORG: {
                this.storeCustomerOrg(reqVo);
                break;
            }
            case CHANNEL: {
                this.storeChannel(reqVo);
                break;
            }
            case TERMINAL: {
                this.storeTerminal(reqVo);
                break;
            }
        }
    }

    protected void storeTerminal(MdmDataPermissionReqVo reqVo) {
    }

    protected void storeChannel(MdmDataPermissionReqVo reqVo) {
    }

    protected void storeCustomerOrg(MdmDataPermissionReqVo reqVo) {
    }

    protected void storeCustomer(MdmDataPermissionReqVo reqVo) {
    }

    protected void storeOrg(MdmDataPermissionReqVo reqVo) {
        log.info("\u6570\u636e\u6743\u9650\uff1a\u4fdd\u5b58\u7ec4\u7ec7:{}", (Object)reqVo);
        String permissionResource = reqVo.getPermissionResource();
        String permissionObjCode = reqVo.getPermissionObjCode();
        String roleCode = reqVo.getRoleCode();
        String functionCode = reqVo.getFunctionCode();
        String listConfigCode = reqVo.getListConfigCode();
        List dataPermissionOrgVos = reqVo.getDataPermissionOrgVos();
        switch (PermissionResourceEnum.convertEnum((String)permissionResource)) {
            case PRESUPPOSITION: {
                String permissionSearchType = reqVo.getPermissionSearchType();
                Assert.hasText((String)permissionSearchType, (String)"\u67e5\u8be2\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                MdmDataPermissionExtendEntity mdmDataPermissionExtendEntity = new MdmDataPermissionExtendEntity();
                mdmDataPermissionExtendEntity.setRoleCode(roleCode);
                mdmDataPermissionExtendEntity.setFunctionCode(functionCode);
                mdmDataPermissionExtendEntity.setListConfigCode(listConfigCode);
                mdmDataPermissionExtendEntity.setPermissionObjCode(permissionObjCode);
                mdmDataPermissionExtendEntity.setPermissionResource(permissionResource);
                mdmDataPermissionExtendEntity.setPermissionSearchType(permissionSearchType);
                this.mdmDataPermissionExtendService.save((Object)mdmDataPermissionExtendEntity);
                break;
            }
            case FIXED: {
                Assert.isTrue((!CollectionUtils.isEmpty((Collection)dataPermissionOrgVos) ? 1 : 0) != 0, (String)"\u804c\u4f4d\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                List collect = dataPermissionOrgVos.stream().map(x -> {
                    MdmDataPermissionExtendEntity mdmDataPermissionFixedExtendEntity = new MdmDataPermissionExtendEntity();
                    mdmDataPermissionFixedExtendEntity.setRoleCode(roleCode);
                    mdmDataPermissionFixedExtendEntity.setFunctionCode(functionCode);
                    mdmDataPermissionFixedExtendEntity.setListConfigCode(listConfigCode);
                    mdmDataPermissionFixedExtendEntity.setPermissionObjCode(permissionObjCode);
                    mdmDataPermissionFixedExtendEntity.setPermissionResource(permissionResource);
                    mdmDataPermissionFixedExtendEntity.setPermissionSearchType(x.getPermissionSearchType());
                    mdmDataPermissionFixedExtendEntity.setCode(x.getOrgCode());
                    return mdmDataPermissionFixedExtendEntity;
                }).collect(Collectors.toList());
                this.mdmDataPermissionExtendService.saveBatch(collect);
                break;
            }
        }
        MdmDataPermissionEntity entity = (MdmDataPermissionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDataPermissionEntity.class));
        this.saveOrUpdate((Object)entity);
    }

    protected void storePosition(MdmDataPermissionReqVo reqVo) {
        log.info("\u6570\u636e\u6743\u9650\uff1a\u4fdd\u5b58\u804c\u4f4d:{}", (Object)reqVo);
        String permissionResource = reqVo.getPermissionResource();
        String permissionObjCode = reqVo.getPermissionObjCode();
        String roleCode = reqVo.getRoleCode();
        String functionCode = reqVo.getFunctionCode();
        String listConfigCode = reqVo.getListConfigCode();
        List dataPermissionPositionVos = reqVo.getDataPermissionPositionVos();
        switch (PermissionResourceEnum.convertEnum((String)permissionResource)) {
            case PRESUPPOSITION: {
                String permissionSearchType = reqVo.getPermissionSearchType();
                Assert.hasText((String)permissionSearchType, (String)"\u67e5\u8be2\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
                MdmDataPermissionExtendEntity mdmDataPermissionExtendEntity = new MdmDataPermissionExtendEntity();
                mdmDataPermissionExtendEntity.setRoleCode(roleCode);
                mdmDataPermissionExtendEntity.setFunctionCode(functionCode);
                mdmDataPermissionExtendEntity.setListConfigCode(listConfigCode);
                mdmDataPermissionExtendEntity.setPermissionObjCode(permissionObjCode);
                mdmDataPermissionExtendEntity.setPermissionResource(permissionResource);
                mdmDataPermissionExtendEntity.setPermissionSearchType(permissionSearchType);
                this.mdmDataPermissionExtendService.save((Object)mdmDataPermissionExtendEntity);
                break;
            }
            case FIXED: {
                Assert.isTrue((!CollectionUtils.isEmpty((Collection)dataPermissionPositionVos) ? 1 : 0) != 0, (String)"\u804c\u4f4d\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
                List collect = dataPermissionPositionVos.stream().map(x -> {
                    MdmDataPermissionExtendEntity mdmDataPermissionFixedExtendEntity = new MdmDataPermissionExtendEntity();
                    mdmDataPermissionFixedExtendEntity.setRoleCode(roleCode);
                    mdmDataPermissionFixedExtendEntity.setFunctionCode(functionCode);
                    mdmDataPermissionFixedExtendEntity.setListConfigCode(listConfigCode);
                    mdmDataPermissionFixedExtendEntity.setPermissionObjCode(permissionObjCode);
                    mdmDataPermissionFixedExtendEntity.setPermissionResource(permissionResource);
                    mdmDataPermissionFixedExtendEntity.setPermissionSearchType(MdmPermissionLevelEnum.CURRENT.getCode());
                    mdmDataPermissionFixedExtendEntity.setCode(x.getPositionCode());
                    return mdmDataPermissionFixedExtendEntity;
                }).collect(Collectors.toList());
                this.mdmDataPermissionExtendService.saveBatch(collect);
                break;
            }
        }
        MdmDataPermissionEntity entity = (MdmDataPermissionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDataPermissionEntity.class));
        this.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDataPermissionReqVo reqVo) {
        this.save(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmDataPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmDataPermissionReqVo reqVo) {
        List<String> ids = this.valid(reqVo);
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    private List<String> valid(MdmDataPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        String id = (String)ids.get(0);
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmDataPermissionReqVo reqVo) {
        List<String> ids = this.valid(reqVo);
        Assert.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).ne(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public MdmDataPermissionRespVo queryCondition(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        String permissionObjCode;
        String functionCode = mdmDataPermissionReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String listConfigCode = mdmDataPermissionReqVo.getListConfigCode();
        Assert.hasText((String)listConfigCode, (String)"\u5217\u8868\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String roleCode = mdmDataPermissionReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDataPermissionRespVo mdmDataPermissionRespVo = this.mdmDataPermissionMapper.queryCondition(mdmDataPermissionReqVo);
        if (mdmDataPermissionRespVo == null) {
            return null;
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDataPermissionExtendService.lambdaQuery().eq(MdmDataPermissionExtendEntity::getRoleCode, (Object)roleCode)).eq(MdmDataPermissionExtendEntity::getFunctionCode, (Object)functionCode)).eq(MdmDataPermissionExtendEntity::getListConfigCode, (Object)listConfigCode)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return mdmDataPermissionRespVo;
        }
        MdmDataPermissionExtendEntity mdmDataPermissionExtendEntity = (MdmDataPermissionExtendEntity)((Object)list.get(0));
        String permissionResource = mdmDataPermissionExtendEntity.getPermissionResource();
        if (PermissionResourceEnum.PRESUPPOSITION.getCode().equals(permissionResource)) {
            String subDictTypeCode;
            String permissionObjCode2 = mdmDataPermissionExtendEntity.getPermissionObjCode();
            mdmDataPermissionRespVo.setPermissionObjCode(permissionObjCode2);
            mdmDataPermissionRespVo.setPermissionResource(mdmDataPermissionExtendEntity.getPermissionResource());
            String permissionSearchType = mdmDataPermissionRespVo.getPermissionSearchType();
            mdmDataPermissionRespVo.setPermissionSearchType(permissionSearchType);
            if (!(StringUtils.isEmpty((String)permissionObjCode2) || StringUtils.isEmpty((String)permissionSearchType) || StringUtils.isEmpty((String)(subDictTypeCode = MdmPermissionObjEnum.getSubDictTypeCode((String)permissionObjCode2))))) {
                mdmDataPermissionRespVo.setPermissionSearchTypeName(DictUtil.dictValue((String)subDictTypeCode, (String)permissionSearchType));
            }
            return mdmDataPermissionRespVo;
        }
        if (PermissionResourceEnum.FIXED.getCode().equals(permissionResource) && !StringUtils.isEmpty((String)(permissionObjCode = mdmDataPermissionExtendEntity.getPermissionObjCode()))) {
            switch (MdmPermissionObjEnum.convertEnum((String)permissionObjCode)) {
                case POSITION: {
                    mdmDataPermissionRespVo.setDataPermissionPositionVos(this.setUpPosition(list));
                    break;
                }
                case ORG: {
                    mdmDataPermissionRespVo.setDataPermissionOrgVos(this.setUpOrg(list));
                    break;
                }
            }
        }
        return mdmDataPermissionRespVo;
    }

    protected List<MdmDataPermissionOrgVo> setUpOrg(List<MdmDataPermissionExtendEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List collect = list.stream().filter(x -> !StringUtils.isEmpty((String)x.getCode())).map(MdmDataPermissionExtendEntity::getCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return Collections.emptyList();
        }
        Map mdmOrgEntityMap = ((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().in(MdmOrgEntity::getOrgCode, collect)).select(new SFunction[]{MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName, MdmOrgEntity::getOrgType}).list().stream().collect(Collectors.toMap(MdmOrgEntity::getOrgCode, Function.identity(), (x1, x2) -> x1));
        if (CollectionUtils.isEmpty(mdmOrgEntityMap)) {
            return Collections.emptyList();
        }
        return list.stream().filter(x -> !StringUtils.isEmpty((String)x.getCode())).map(x -> {
            String subDictTypeCode;
            MdmDataPermissionOrgVo mdmDataPermissionOrgVo = new MdmDataPermissionOrgVo();
            MdmOrgEntity mdmOrgEntity = (MdmOrgEntity)((Object)((Object)mdmOrgEntityMap.get(x.getCode())));
            if (mdmOrgEntity == null) {
                return null;
            }
            mdmDataPermissionOrgVo.setOrgCode(mdmOrgEntity.getOrgCode());
            mdmDataPermissionOrgVo.setOrgName(mdmOrgEntity.getOrgName());
            mdmDataPermissionOrgVo.setOrgType(mdmOrgEntity.getOrgType());
            mdmDataPermissionOrgVo.setOrgTypeName(DictUtil.dictValue((String)"mdm_org_type", (String)mdmOrgEntity.getOrgType()));
            String permissionSearchType = x.getPermissionSearchType();
            mdmDataPermissionOrgVo.setPermissionSearchType(permissionSearchType);
            String permissionObjCode = x.getPermissionObjCode();
            if (!(StringUtils.isEmpty((String)permissionSearchType) || StringUtils.isEmpty((String)permissionObjCode) || StringUtils.isEmpty((String)(subDictTypeCode = MdmPermissionObjEnum.getSubDictTypeCode((String)permissionObjCode))))) {
                mdmDataPermissionOrgVo.setPermissionSearchTypeName(DictUtil.dictValue((String)subDictTypeCode, (String)permissionSearchType));
            }
            return mdmDataPermissionOrgVo;
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    protected List<MdmDataPermissionPositionVo> setUpPosition(List<MdmDataPermissionExtendEntity> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List<String> collect = list.stream().filter(x -> !StringUtils.isEmpty((String)x.getCode())).map(MdmDataPermissionExtendEntity::getCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return Collections.emptyList();
        }
        return this.mdmPositionService.findPositionAndOrgList(collect);
    }

    @Override
    public MdmCurrentPermissionRespVo currentUserDataPermission(String competenceCode, String listConfigCode) {
        MdmCurrentPermissionRespVo mdmCurrentPermissionRespVo = new MdmCurrentPermissionRespVo();
        mdmCurrentPermissionRespVo.setUserPermissionList(new ArrayList());
        mdmCurrentPermissionRespVo.setPermissionObjCodeList(new ArrayList());
        if (StringUtils.isEmpty((String)competenceCode) || StringUtils.isEmpty((String)listConfigCode)) {
            return mdmCurrentPermissionRespVo;
        }
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728");
        log.info("[\u6570\u636e\u6743\u9650]\u83b7\u53d6\u5f53\u524d\u7528\u6237\u6743\u9650,\u7528\u6237\u4fe1\u606f:{}", (Object)user);
        String username = user.getUsername();
        Assert.hasText((String)username, (String)"\u7528\u6237\u5e10\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String positionCode = user.getPoscode();
        Assert.hasText((String)positionCode, (String)"\u7528\u6237\u6ca1\u6709\u5f53\u524d\u804c\u4f4d\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        if ("admin".equals(username)) {
            return mdmCurrentPermissionRespVo;
        }
        List permissionExtendEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmDataPermissionExtendService.lambdaQuery().eq(MdmDataPermissionExtendEntity::getFunctionCode, (Object)competenceCode)).eq(MdmDataPermissionExtendEntity::getListConfigCode, (Object)listConfigCode)).list();
        if (CollectionUtils.isEmpty((Collection)permissionExtendEntities)) {
            return mdmCurrentPermissionRespVo;
        }
        List functionPermissionObjCodeList = permissionExtendEntities.stream().filter(x -> !StringUtils.isEmpty((String)x.getPermissionObjCode())).map(MdmDataPermissionExtendEntity::getPermissionObjCode).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(functionPermissionObjCodeList)) {
            return mdmCurrentPermissionRespVo;
        }
        mdmCurrentPermissionRespVo.setPermissionObjCodeList(functionPermissionObjCodeList);
        List<String> roleCodeList = this.mdmPositionRoleService.findRoleCodeByPosition(Collections.singletonList(positionCode));
        log.info("\u7528\u6237\u89d2\u8272\u7f16\u7801:{}\uff0c\u804c\u4f4d:{}", roleCodeList, (Object)positionCode);
        List<MdmDataPermissionExtendEntity> userRolePermissions = permissionExtendEntities.stream().filter(x -> !StringUtils.isEmpty((String)x.getRoleCode())).filter(x -> roleCodeList.contains(x.getRoleCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userRolePermissions)) {
            return mdmCurrentPermissionRespVo;
        }
        this.handlePosition(userRolePermissions, mdmCurrentPermissionRespVo, positionCode);
        this.handleOrg(userRolePermissions, mdmCurrentPermissionRespVo, user);
        return mdmCurrentPermissionRespVo;
    }

    protected void handleOrg(List<MdmDataPermissionExtendEntity> userRolePermissions, MdmCurrentPermissionRespVo mdmCurrentPermissionRespVo, UserRedis user) {
        List fixedPermissions;
        String orgCode = user.getOrgcode();
        if (StringUtils.isEmpty((String)orgCode)) {
            return;
        }
        ArrayList<String> orgCodeList = new ArrayList<String>();
        List presuppositionPermissions = userRolePermissions.stream().filter(x -> MdmPermissionObjEnum.ORG.getCode().equals(x.getPermissionObjCode())).filter(x -> PermissionResourceEnum.PRESUPPOSITION.getCode().equals(x.getPermissionResource())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(presuppositionPermissions)) {
            for (Object presuppositionPermission : presuppositionPermissions) {
                switch (MdmPermissionLevelEnum.convertEnum((String)((MdmDataPermissionExtendEntity)((Object)presuppositionPermission)).getPermissionSearchType())) {
                    case ALL: {
                        mdmCurrentPermissionRespVo.getPermissionObjCodeList().remove(MdmPermissionObjEnum.ORG.getCode());
                        return;
                    }
                    case CURRENT: {
                        orgCodeList.add(orgCode);
                        break;
                    }
                    case CURRENT_SUB: {
                        List<String> allChildrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, orgCode);
                        if (CollectionUtils.isEmpty(allChildrenOrgCodeList)) break;
                        orgCodeList.addAll(allChildrenOrgCodeList);
                        break;
                    }
                    case CURRENT_UP: {
                        List<String> allParentOrgCodeList = this.mdmOrgService.findAllParentOrgCodeList(null, orgCode);
                        if (CollectionUtils.isEmpty(allParentOrgCodeList)) break;
                        orgCodeList.addAll(allParentOrgCodeList);
                        break;
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(fixedPermissions = userRolePermissions.stream().filter(x -> MdmPermissionObjEnum.ORG.getCode().equals(x.getPermissionObjCode())).filter(x -> PermissionResourceEnum.FIXED.getCode().equals(x.getPermissionResource())).collect(Collectors.toList()))) {
            for (MdmDataPermissionExtendEntity fixedPermission : fixedPermissions) {
                switch (MdmPermissionLevelEnum.convertEnum((String)fixedPermission.getPermissionSearchType())) {
                    case CURRENT: {
                        orgCodeList.add(fixedPermission.getCode());
                        break;
                    }
                    case CURRENT_SUB: {
                        List<String> allChildrenOrgCodeList = this.mdmOrgService.findAllChildrenOrgCodeList(null, fixedPermission.getCode());
                        if (CollectionUtils.isEmpty(allChildrenOrgCodeList)) break;
                        orgCodeList.addAll(allChildrenOrgCodeList);
                        break;
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(orgCodeList)) {
            MdmCurrentUserPermissionRespVo mdmCurrentUserPermissionRespVo = new MdmCurrentUserPermissionRespVo();
            mdmCurrentUserPermissionRespVo.setPermissionObjCode(MdmPermissionObjEnum.ORG.getCode());
            mdmCurrentUserPermissionRespVo.setPermissionValueList(orgCodeList);
            mdmCurrentPermissionRespVo.getUserPermissionList().add(mdmCurrentUserPermissionRespVo);
        }
    }

    protected void handlePosition(List<MdmDataPermissionExtendEntity> userRolePermissions, MdmCurrentPermissionRespVo mdmCurrentPermissionRespVo, String positionCode) {
        List fixedPositionCodeList;
        ArrayList<String> positionCodeList = new ArrayList<String>();
        List presuppositionPermissions = userRolePermissions.stream().filter(x -> MdmPermissionObjEnum.POSITION.getCode().equals(x.getPermissionObjCode())).filter(x -> PermissionResourceEnum.PRESUPPOSITION.getCode().equals(x.getPermissionResource())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(presuppositionPermissions)) {
            for (MdmDataPermissionExtendEntity presuppositionPermission : presuppositionPermissions) {
                switch (MdmPermissionLevelEnum.convertEnum((String)presuppositionPermission.getPermissionSearchType())) {
                    case ALL: {
                        mdmCurrentPermissionRespVo.getPermissionObjCodeList().remove(MdmPermissionObjEnum.POSITION.getCode());
                        return;
                    }
                    case CURRENT: {
                        positionCodeList.add(positionCode);
                        break;
                    }
                    case CURRENT_SUB: {
                        List<String> allSubPositionCodeList = this.mdmPositionService.findAllChildrenPositionCodeList(null, positionCode);
                        if (CollectionUtils.isEmpty(allSubPositionCodeList)) break;
                        positionCodeList.addAll(allSubPositionCodeList);
                        break;
                    }
                    case CURRENT_UP: {
                        List<String> allParentPositionCodeList = this.mdmPositionService.findAllParentPositionCodeList(null, positionCode);
                        if (CollectionUtils.isEmpty(allParentPositionCodeList)) break;
                        positionCodeList.addAll(allParentPositionCodeList);
                        break;
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(fixedPositionCodeList = userRolePermissions.stream().filter(x -> MdmPermissionObjEnum.POSITION.getCode().equals(x.getPermissionObjCode())).filter(x -> PermissionResourceEnum.FIXED.getCode().equals(x.getPermissionResource())).filter(x -> !StringUtils.isEmpty((String)x.getCode())).map(MdmDataPermissionExtendEntity::getCode).distinct().collect(Collectors.toList()))) {
            positionCodeList.addAll(fixedPositionCodeList);
        }
        if (!CollectionUtils.isEmpty(positionCodeList)) {
            MdmCurrentUserPermissionRespVo mdmCurrentUserPermissionRespVo = new MdmCurrentUserPermissionRespVo();
            mdmCurrentUserPermissionRespVo.setPermissionObjCode(MdmPermissionObjEnum.POSITION.getCode());
            mdmCurrentUserPermissionRespVo.setPermissionValueList(positionCodeList);
            mdmCurrentPermissionRespVo.getUserPermissionList().add(mdmCurrentUserPermissionRespVo);
        }
    }

    @Override
    public List<MdmPermissionObjRespVo> objList(String functionCode, String listConfigCode) {
        List permissionTree = DictUtil.tree((String)"permission_obj");
        if (CollectionUtils.isEmpty((Collection)permissionTree)) {
            return Collections.emptyList();
        }
        MdmFunctionSubEntity mdmFunctionSubEntity = (MdmFunctionSubEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().eq(MdmFunctionSubEntity::getParentCode, (Object)functionCode)).eq(MdmFunctionSubEntity::getFunctionCode, (Object)listConfigCode)).select(new SFunction[]{MdmFunctionSubEntity::getPermissionObj}).one());
        log.info("[\u529f\u80fd\u5217\u8868][\u5df2\u914d\u7f6e\u7684\u6743\u9650\u5bf9\u8c61]:{}", (Object)mdmFunctionSubEntity);
        if (mdmFunctionSubEntity == null) {
            return Collections.emptyList();
        }
        String permissionObj = mdmFunctionSubEntity.getPermissionObj();
        if (StringUtils.isEmpty((String)permissionObj)) {
            return Collections.emptyList();
        }
        List<String> permissionObjList = Arrays.asList(permissionObj.split(","));
        return permissionTree.stream().filter(x -> x != null && !StringUtils.isEmpty((String)x.getDictCode()) && permissionObjList.contains(x.getDictCode())).map(x -> {
            MdmPermissionObjRespVo mdmPermissionObjRespVo = new MdmPermissionObjRespVo();
            mdmPermissionObjRespVo.setPermissionObjCode(x.getDictCode());
            mdmPermissionObjRespVo.setPermissionObjName(x.getDictValue());
            return mdmPermissionObjRespVo;
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> searchTypeList(String permissionObjCode) {
        return DictUtil.dictMap((String)MdmPermissionObjEnum.getSubDictTypeCode((String)permissionObjCode));
    }

    @Override
    public List<MdmFunctionRespVo> functionSelect(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        MdmFunctionReqVo mdmFunctionReqVo = new MdmFunctionReqVo();
        if (!StringUtils.isEmpty((String)mdmDataPermissionReqVo.getRoleCode())) {
            List<String> relationFunctionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(mdmDataPermissionReqVo.getRoleCode());
            mdmFunctionReqVo.setFunctionCodeList(relationFunctionCodeList);
        }
        return this.mdmFunctionService.systemList(mdmFunctionReqVo);
    }

    @Override
    public List<MdmRoleRespVo> roleSelectList(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        MdmRoleReqVo mdmRoleReqVo = new MdmRoleReqVo();
        if (!StringUtils.isEmpty((String)mdmDataPermissionReqVo.getFunctionCode())) {
            List<String> roleCodeList = this.mdmFunctionRoleService.findRoleCodeByFunction(mdmDataPermissionReqVo.getFunctionCode());
            mdmRoleReqVo.setRoleCodeList(roleCodeList);
        }
        mdmRoleReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        return this.mdmRoleService.roleList(mdmRoleReqVo);
    }

    @Override
    public List<MdmListConfigRespVo> configList(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        String functionCode = mdmDataPermissionReqVo.getFunctionCode();
        Assert.hasText((String)functionCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionSubReqVo mdmFunctionSubReqVo = new MdmFunctionSubReqVo();
        mdmFunctionSubReqVo.setParentCode(functionCode);
        List<MdmFunctionSubRespVo> subList = this.mdmFunctionSubService.findSubList(mdmFunctionSubReqVo);
        if (CollectionUtils.isEmpty(subList)) {
            return Collections.emptyList();
        }
        return subList.stream().map(x -> {
            MdmListConfigRespVo mdmListConfigRespVo = new MdmListConfigRespVo();
            mdmListConfigRespVo.setListConfigCode(x.getFunctionCode());
            mdmListConfigRespVo.setListConfigName(x.getFunctionName());
            return mdmListConfigRespVo;
        }).collect(Collectors.toList());
    }
}

