/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.service.impl;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.service.BaseLazyTreeService;
import com.biz.crm.cusorg.entity.MdmCusOrgEntity;
import com.biz.crm.cusorg.mapper.MdmCusOrgMapper;
import com.biz.crm.cusorg.service.MdmCusOrgService;
import com.biz.crm.function.mapper.MdmFunctionMapper;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeReqVo;
import com.biz.crm.nebular.mdm.common.BaseLazyTreeRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.productlevel.mapper.MdmProductLevelMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.TreeRuleCodeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BaseLazyTreeServiceImpl
implements BaseLazyTreeService {
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmFunctionService mdmFunctionService;
    @Resource
    private MdmProductLevelService mdmProductLevelService;
    @Resource
    private MdmCusOrgService mdmCusOrgService;
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private MdmFunctionMapper mdmFunctionMapper;
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private MdmCusOrgMapper mdmCusOrgMapper;

    @Override
    public List<BaseLazyTreeRespVo> orgLazyTree(BaseLazyTreeReqVo reqVo) {
        MdmOrgEntity one;
        ArrayList<BaseLazyTreeRespVo> list = new ArrayList<BaseLazyTreeRespVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((String)reqVo.getExcludeCodeAndChildren()) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getExcludeCodeAndChildren())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
            list.addAll(this.mdmOrgMapper.findOrgLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null, null, excludeRuleCode));
        } else if (!StringUtils.isEmpty((String)reqVo.getName())) {
            List likeList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getEnableStatus()), CrmBaseEntity::getEnableStatus, (Object)reqVo.getEnableStatus())).like(MdmOrgEntity::getOrgName, (Object)reqVo.getName())).select(new SFunction[]{MdmOrgEntity::getOrgCode, CrmTreeTenEntity::getRuleCode}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)likeList)) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(likeList.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(this.mdmOrgMapper.findOrgLazyTreeList(reqVo.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode));
            }
        } else {
            list.addAll(this.mdmOrgMapper.findOrgLazyTreeList(reqVo.getEnableStatus(), true, null, null, null, excludeRuleCode));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return this.generateTreeByParentCode(list);
        }
        return new ArrayList<BaseLazyTreeRespVo>();
    }

    @Override
    public List<BaseLazyTreeRespVo> menuLazyTree(BaseLazyTreeReqVo reqVo) {
        ArrayList<BaseLazyTreeRespVo> list = new ArrayList<BaseLazyTreeRespVo>();
        if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
            list.addAll(this.mdmFunctionMapper.findFunctionLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null));
        } else if (!StringUtils.isEmpty((String)reqVo.getName())) {
            List likeList = ((LambdaQueryChainWrapper)this.mdmFunctionService.lambdaQuery().like(MdmFunctionEntity::getFunctionName, (Object)reqVo.getName())).select(new SFunction[]{MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getParentCode}).list();
            HashSet set = new HashSet(16);
            if (CollectionUtil.listNotEmptyNotSizeZero((List)likeList)) {
                set.addAll(likeList.stream().map(MdmFunctionEntity::getFunctionCode).collect(Collectors.toSet()));
                List parentCodeList = likeList.stream().map(MdmFunctionEntity::getParentCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
                for (int index = 0; CollectionUtil.listNotEmptyNotSizeZero(parentCodeList) && index < 10; ++index) {
                    List parentList = ((LambdaQueryChainWrapper)this.mdmFunctionService.lambdaQuery().in(MdmFunctionEntity::getFunctionCode, parentCodeList)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode, MdmFunctionEntity::getParentCode}).list();
                    parentCodeList.clear();
                    if (!CollectionUtil.listNotEmptyNotSizeZero((List)parentList)) continue;
                    set.addAll(parentList.stream().map(MdmFunctionEntity::getFunctionCode).collect(Collectors.toSet()));
                    parentCodeList = parentList.stream().map(MdmFunctionEntity::getParentCode).filter(StringUtils::isNotEmpty).distinct().collect(Collectors.toList());
                }
                list.addAll(this.mdmFunctionMapper.findFunctionLazyTreeList(reqVo.getEnableStatus(), null, null, new ArrayList<String>(set)));
            }
        } else {
            list.addAll(this.mdmFunctionMapper.findFunctionLazyTreeList(reqVo.getEnableStatus(), true, null, null));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return this.generateTreeByParentCode(list);
        }
        return new ArrayList<BaseLazyTreeRespVo>();
    }

    @Override
    public List<BaseLazyTreeRespVo> productLevelLazyTree(BaseLazyTreeReqVo reqVo) {
        MdmProductLevelEntity one;
        ArrayList<BaseLazyTreeRespVo> list = new ArrayList<BaseLazyTreeRespVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((String)reqVo.getExcludeCodeAndChildren()) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)reqVo.getExcludeCodeAndChildren())).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
            list.addAll(this.mdmProductLevelMapper.findProductLevelLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null, null, excludeRuleCode));
        } else if (!StringUtils.isEmpty((String)reqVo.getName())) {
            List likeList = ((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().like(MdmProductLevelEntity::getProductLevelName, (Object)reqVo.getName())).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode, CrmTreeEntity::getRuleCode}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)likeList)) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(likeList.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(this.mdmProductLevelMapper.findProductLevelLazyTreeList(reqVo.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode));
            }
        } else {
            list.addAll(this.mdmProductLevelMapper.findProductLevelLazyTreeList(reqVo.getEnableStatus(), true, null, null, null, excludeRuleCode));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return this.generateTreeByParentCode(list);
        }
        return new ArrayList<BaseLazyTreeRespVo>();
    }

    @Override
    public List<BaseLazyTreeRespVo> customerOrgLazyTree(BaseLazyTreeReqVo reqVo) {
        MdmCusOrgEntity one;
        ArrayList<BaseLazyTreeRespVo> list = new ArrayList<BaseLazyTreeRespVo>();
        String excludeRuleCode = "";
        if (StringUtils.isNotEmpty((String)reqVo.getExcludeCodeAndChildren()) && (one = (MdmCusOrgEntity)((Object)((LambdaQueryChainWrapper)this.mdmCusOrgService.lambdaQuery().eq(MdmCusOrgEntity::getCustomerOrgCode, (Object)reqVo.getExcludeCodeAndChildren())).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one())) != null) {
            excludeRuleCode = one.getRuleCode();
        }
        if (!StringUtils.isEmpty((String)reqVo.getParentCode())) {
            list.addAll(this.mdmCusOrgMapper.findCusOrgLazyTreeList(reqVo.getEnableStatus(), null, reqVo.getParentCode(), null, null, excludeRuleCode));
        } else if (!StringUtils.isEmpty((String)reqVo.getName())) {
            List likeList = ((LambdaQueryChainWrapper)this.mdmCusOrgService.lambdaQuery().like(MdmCusOrgEntity::getCustomerOrgName, (Object)reqVo.getName())).select(new SFunction[]{MdmCusOrgEntity::getCustomerOrgCode, CrmTreeEntity::getRuleCode}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)likeList)) {
                Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(likeList.stream().map(CrmTreeEntity::getRuleCode).collect(Collectors.toList()));
                list.addAll(this.mdmCusOrgMapper.findCusOrgLazyTreeList(reqVo.getEnableStatus(), null, null, null, new ArrayList<String>(parentRuleCodes), excludeRuleCode));
            }
        } else {
            list.addAll(this.mdmCusOrgMapper.findCusOrgLazyTreeList(reqVo.getEnableStatus(), true, null, null, null, excludeRuleCode));
        }
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            return this.generateTreeByParentCode(list);
        }
        return new ArrayList<BaseLazyTreeRespVo>();
    }

    private List<BaseLazyTreeRespVo> generateTreeByParentCode(List<BaseLazyTreeRespVo> totalList) {
        ArrayList<BaseLazyTreeRespVo> treeList = new ArrayList<BaseLazyTreeRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, BaseLazyTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(BaseLazyTreeRespVo::getCode, v -> v));
        for (BaseLazyTreeRespVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<BaseLazyTreeRespVo> restTempList = new ArrayList<BaseLazyTreeRespVo>();
            ArrayList<BaseLazyTreeRespVo> curLevelTempList = new ArrayList<BaseLazyTreeRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(BaseLazyTreeRespVo::getCode, BaseLazyTreeRespVo::getCode));
            HashMap curLevelChildrenMap = new HashMap(16);
            for (BaseLazyTreeRespVo baseLazyTreeRespVo : restList) {
                if (curLevelMap.containsKey(baseLazyTreeRespVo.getParentCode())) {
                    curLevelTempList.add(baseLazyTreeRespVo);
                    ArrayList<BaseLazyTreeRespVo> childrenList = new ArrayList<BaseLazyTreeRespVo>();
                    if (curLevelChildrenMap.containsKey(baseLazyTreeRespVo.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(baseLazyTreeRespVo.getParentCode()));
                    }
                    childrenList.add(baseLazyTreeRespVo);
                    curLevelChildrenMap.put(baseLazyTreeRespVo.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(baseLazyTreeRespVo);
            }
            for (BaseLazyTreeRespVo baseLazyTreeRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(baseLazyTreeRespVo.getCode())) continue;
                baseLazyTreeRespVo.setChildren((List)curLevelChildrenMap.get(baseLazyTreeRespVo.getCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

