/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.biz.crm.common.PageResult;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgCustomerReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgCustomerRespVo;
import com.biz.crm.org.mapper.MdmOrgCustomerMapper;
import com.biz.crm.org.service.MdmOrgCustomerService;
import com.biz.crm.org.service.MdmOrgService;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class MdmOrgCustomerServiceImpl
implements MdmOrgCustomerService {
    @Resource
    private MdmOrgCustomerMapper mdmOrgCustomerMapper;
    @Resource
    private MdmOrgService mdmOrgService;
    @Resource
    private MdmCustomerMsgService mdmcustomerMsgService;

    @Override
    public PageResult<MdmOrgCustomerRespVo> findOrgCustomerList(MdmOrgCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmCustomerMsgReqVo mdmCustomerMsgReqVo = new MdmCustomerMsgReqVo();
        mdmCustomerMsgReqVo.setOrgCode(reqVo.getOrgCode());
        mdmCustomerMsgReqVo.setCustomerCode(reqVo.getCustomerCode());
        mdmCustomerMsgReqVo.setCustomerName(reqVo.getCustomerName());
        PageResult<MdmCustomerMsgRespVo> pageResult = this.mdmcustomerMsgService.findList(mdmCustomerMsgReqVo);
        if (pageResult == null || CollectionUtils.isEmpty((Collection)pageResult.getData())) {
            return PageResult.builder().data(Collections.emptyList()).count(Long.valueOf(0L)).build();
        }
        List mdmOrgCustomerRespVos = CrmBeanUtil.copyList((List)pageResult.getData(), MdmOrgCustomerRespVo.class);
        return PageResult.builder().data(mdmOrgCustomerRespVos).count(pageResult.getCount()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateCustomerOrg(MdmOrgCustomerReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        Assert.notEmpty((Collection)reqVo.getCustomerCodeList(), (String)"\u7f3a\u5931\u5ba2\u6237\u7f16\u7801");
        MdmOrgCustomerUpdateReqVo mdmOrgCustomerReqVo = new MdmOrgCustomerUpdateReqVo();
        mdmOrgCustomerReqVo.setCustomerCodeList(reqVo.getCustomerCodeList());
        mdmOrgCustomerReqVo.setOrgCode(reqVo.getOrgCode());
        this.mdmcustomerMsgService.batchUpdateCustomerOrg(mdmOrgCustomerReqVo);
    }
}

