/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positionlevel.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelSelectReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelSelectRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.MdmPositionService;
import com.biz.crm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.positionlevel.model.MdmPositionLevelEntity;
import com.biz.crm.positionlevel.model.MdmPositionLevelRoleEntity;
import com.biz.crm.positionlevel.service.MdmPositionLevelRoleService;
import com.biz.crm.positionlevel.service.MdmPositionLevelService;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.MdmRoleService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.ParamUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmPositionLevelServiceExpandImpl"})
public class MdmPositionLevelServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionLevelMapper, MdmPositionLevelEntity>
implements MdmPositionLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelServiceImpl.class);
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private MdmPositionLevelRoleService mdmPositionLevelRoleService;
    @Resource
    private MdmRoleService mdmRoleService;
    @Resource
    private MdmPositionService mdmPositionService;

    @Override
    public PageResult<MdmPositionLevelRespVo> findList(MdmPositionLevelReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPositionLevelRespVo> list = this.mdmPositionLevelMapper.findList((Page<MdmPositionLevelRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List roleEntityList;
            List positionLevelCodeList = list.stream().map(MdmPositionLevelRespVo::getPositionLevelCode).collect(Collectors.toList());
            List positionLevelRoleEntityList = ((LambdaQueryChainWrapper)this.mdmPositionLevelRoleService.lambdaQuery().in(MdmPositionLevelRoleEntity::getPositionLevelCode, positionLevelCodeList)).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelRoleEntityList) && CollectionUtil.listNotEmptyNotSizeZero((List)(roleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toSet()))).select(new SFunction[]{MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName}).list()))) {
                Map<String, MdmRoleEntity> roleMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, v -> v));
                Map<String, List<MdmPositionLevelRoleEntity>> roleGroupMap = positionLevelRoleEntityList.stream().collect(Collectors.groupingBy(MdmPositionLevelRoleEntity::getPositionLevelCode));
                list.forEach(item -> {
                    if (roleGroupMap.containsKey(item.getPositionLevelCode())) {
                        List roleItemList = (List)roleGroupMap.get(item.getPositionLevelCode());
                        ArrayList roleList = new ArrayList();
                        roleItemList.forEach(roleItem -> {
                            if (roleMap.containsKey(roleItem.getRoleCode())) {
                                roleList.add(roleMap.get(roleItem.getRoleCode()));
                            }
                        });
                        item.setRoleCode(roleList.stream().map(MdmRoleEntity::getRoleCode).collect(Collectors.joining(",")));
                        item.setRoleName(roleList.stream().map(MdmRoleEntity::getRoleName).collect(Collectors.joining(",")));
                    }
                });
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionLevelRespVo queryForUpdate(String id) {
        if (StringUtils.isNotEmpty((String)id)) {
            MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
            MdmPositionLevelRespVo respVo = (MdmPositionLevelRespVo)CrmBeanUtil.copy((Object)((Object)entity), MdmPositionLevelRespVo.class);
            List positionLevelRoleEntityList = ((LambdaQueryChainWrapper)this.mdmPositionLevelRoleService.lambdaQuery().eq(MdmPositionLevelRoleEntity::getPositionLevelCode, (Object)entity.getPositionLevelCode())).select(new SFunction[]{MdmPositionLevelRoleEntity::getRoleCode}).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelRoleEntityList)) {
                List roleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toList()))).list();
                List roleList = CrmBeanUtil.copyList((List)roleEntityList, MdmRoleRespVo.class);
                respVo.setRoleCode(roleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.joining(",")));
                respVo.setRoleName(roleList.stream().map(MdmRoleRespVo::getRoleName).collect(Collectors.joining(",")));
                respVo.setRoleList(roleList);
            }
            return respVo;
        }
        return null;
    }

    @Override
    public MdmPositionLevelRespVo detail(String id, String positionLevelCode) {
        if (StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionLevelCode)) {
            MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionLevelCode), MdmPositionLevelEntity::getPositionLevelCode, (Object)positionLevelCode)).one());
            Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
            MdmPositionLevelRespVo respVo = (MdmPositionLevelRespVo)CrmBeanUtil.copy((Object)((Object)entity), MdmPositionLevelRespVo.class);
            List positionLevelRoleEntityList = ((LambdaQueryChainWrapper)this.mdmPositionLevelRoleService.lambdaQuery().eq(MdmPositionLevelRoleEntity::getPositionLevelCode, (Object)entity.getPositionLevelCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelRoleEntityList)) {
                List roleEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).in(MdmRoleEntity::getRoleCode, (Collection)positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toList()))).list();
                List roleList = CrmBeanUtil.copyList((List)roleEntityList, MdmRoleRespVo.class);
                respVo.setRoleCode(roleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.joining(",")));
                respVo.setRoleName(roleList.stream().map(MdmRoleRespVo::getRoleName).collect(Collectors.joining(",")));
                respVo.setRoleList(roleList);
            }
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPositionLevelReqVo reqVo) {
        reqVo.setId(null);
        Assert.hasText((String)reqVo.getPositionLevelName(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        String nameNum = this.mdmPositionLevelMapper.queryPositionLevelNameOnlyOne(reqVo.getPositionLevelName());
        AssertUtils.isTrue((boolean)StringUtils.getZero().equals(nameNum), (String)"\u5f53\u524d\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPositionLevelEntity.class));
        if (StringUtils.isEmpty((String)entity.getPositionLevelCode())) {
            entity.setPositionLevelCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_LEVEL_CODE.getCode()));
        } else {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionLevelEntity::getPositionLevelCode, (Object)entity.getPositionLevelCode())).select(new SFunction[]{MdmPositionLevelEntity::getPositionLevelCode}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
            Integer count = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionLevelEntity::getPositionLevelName, (Object)reqVo.getPositionLevelName())).count();
            Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u5df2\u5b58\u5728");
        }
        entity.setSuffixSequence(0);
        this.save((Object)entity);
        this.mdmPositionLevelRoleService.replacePositionLevelRole(entity.getPositionLevelCode(), Arrays.asList(reqVo.getRoleCode().split(",")));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPositionLevelReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
        Assert.hasText((String)reqVo.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
        Assert.hasText((String)reqVo.getPositionLevelName(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Assert.isTrue((boolean)entity.getPositionLevelCode().equals(reqVo.getPositionLevelCode()), (String)"\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(BaseIdEntity::getId, (Object)reqVo.getId())).eq(MdmPositionLevelEntity::getPositionLevelName, (Object)reqVo.getPositionLevelName())).count();
        Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u804c\u4f4d\u7ea7\u522b\u540d\u79f0\u5df2\u5b58\u5728");
        this.updateById((Object)entity);
        this.mdmPositionLevelRoleService.replacePositionLevelRole(entity.getPositionLevelCode(), Arrays.asList(reqVo.getRoleCode().split(",")));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"\u8bf7\u4f20\u5165\u53c2\u6570");
        List list = this.mdmPositionLevelMapper.selectBatchIds(ids);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                List positionList = ((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionLevelCode, (Object)o.getPositionLevelCode())).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)positionList), (String)("\u804c\u4f4d\u7ea7\u522b" + o.getPositionLevelName() + "\u5df2\u7ecf\u5173\u8054\u4e86\u804c\u4f4d\uff0c\u4e0d\u80fd\u5220\u9664"));
                this.mdmPositionLevelRoleService.removePositionLevel(o.getPositionLevelCode());
                this.removeById((Serializable)((Object)o.getId()));
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(List<String> ids) {
        Assert.notEmpty(ids, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmPositionLevelSelectRespVo> selectList(MdmPositionLevelSelectReqVo reqVo) {
        Integer pageSize = reqVo.getPageSize();
        if (pageSize == null || pageSize == 0) {
            pageSize = Integer.valueOf(ParamUtil.getParameterValue((String)"select_box_option_size"));
        }
        ArrayList<MdmPositionLevelSelectRespVo> list = new ArrayList<MdmPositionLevelSelectRespVo>();
        HashSet<String> codeList = new HashSet<String>(16);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getSelectedCode())) {
            codeList.add(reqVo.getSelectedCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)reqVo.getSelectedCodeList())) {
            codeList.addAll(reqVo.getSelectedCodeList());
        }
        if (!codeList.isEmpty()) {
            reqVo.setSelectedCodeList(new ArrayList(codeList));
        }
        if (pageSize > 0) {
            list.addAll(this.mdmPositionLevelMapper.positionLevelSelectList((Page<MdmPositionLevelSelectRespVo>)new Page(1L, (long)pageSize.intValue(), false), reqVo));
        }
        return list;
    }

    @Override
    @Klock(keys={"position_level_generate_position_name", "#positionLevelCode"}, waitTime=5L, leaseTime=5L)
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public String generatePositionNameByPositionLevelCode(String positionLevelCode) {
        Assert.hasText((String)positionLevelCode, (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
        MdmPositionLevelEntity positionLevel = (MdmPositionLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionLevelEntity::getPositionLevelCode, (Object)positionLevelCode)).select(new SFunction[]{MdmPositionLevelEntity::getPositionLevelCode, MdmPositionLevelEntity::getPositionLevelName, MdmPositionLevelEntity::getSuffixSequence, CrmBaseEntity::getEnableStatus}).one());
        Assert.notNull((Object)((Object)positionLevel), (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(positionLevel.getEnableStatus()), (String)"\u8be5\u804c\u4f4d\u7ea7\u522b\u5df2\u505c\u7528");
        Integer suffixSequence = positionLevel.getSuffixSequence();
        if (suffixSequence == null) {
            suffixSequence = 0;
        }
        HashSet positionNameSet = new HashSet(16);
        List positionList = ((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().like(MdmPositionEntity::getPositionName, (Object)positionLevel.getPositionLevelName())).select(new SFunction[]{MdmPositionEntity::getPositionName}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)positionList)) {
            positionNameSet.addAll(positionList.stream().map(MdmPositionEntity::getPositionName).collect(Collectors.toSet()));
        }
        suffixSequence = suffixSequence + 1;
        String positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
        while (!positionNameSet.isEmpty() && positionNameSet.contains(positionName)) {
            suffixSequence = suffixSequence + 1;
            positionName = positionLevel.getPositionLevelName() + "_" + suffixSequence;
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionLevelEntity::getPositionLevelCode, (Object)positionLevelCode)).set(MdmPositionLevelEntity::getSuffixSequence, (Object)suffixSequence)).update();
        return positionName;
    }
}

