/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.function.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.YesNoEnum;
import com.biz.crm.function.mapper.MdmFunctionMapper;
import com.biz.crm.function.model.MdmFunctionEntity;
import com.biz.crm.function.service.MdmFunctionRoleService;
import com.biz.crm.function.service.MdmFunctionService;
import com.biz.crm.icon.service.IMdmIconService;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionSearchReqVo;
import com.biz.crm.nebular.mdm.icon.MdmIconReqVo;
import com.biz.crm.nebular.mdm.icon.MdmIconRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleFunctionTreeVo;
import com.biz.crm.position.service.MdmPositionRoleService;
import com.biz.crm.tableconfig.model.MdmFunctionSubEntity;
import com.biz.crm.tableconfig.service.IMdmFunctionSubService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.util.cache.TableConfigUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmFunctionServiceExpandImpl"})
public class MdmFunctionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmFunctionMapper, MdmFunctionEntity>
implements MdmFunctionService {
    private static final Logger log = LoggerFactory.getLogger(MdmFunctionServiceImpl.class);
    @Autowired
    private MdmFunctionMapper mdmFunctionMapper;
    @Autowired
    private MdmFunctionRoleService mdmFunctionRoleService;
    @Autowired
    private IMdmIconService mdmIconService;
    @Autowired
    private MdmPositionRoleService mdmPositionRoleService;
    @Autowired
    private IMdmFunctionSubService mdmFunctionSubService;
    @Value(value="${whiteFunctionCodeList:}")
    private String whiteFunctionCodeList;

    @Override
    public MdmFunctionRespVo query(MdmFunctionReqVo mdmFunctionReqVo) {
        MdmFunctionEntity one = (MdmFunctionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getId()), BaseIdEntity::getId, (Object)mdmFunctionReqVo.getId())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).in(!CollectionUtils.isEmpty((Collection)mdmFunctionReqVo.getFunctionCodeList()), MdmFunctionEntity::getFunctionCode, (Collection)mdmFunctionReqVo.getFunctionCodeList())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).one());
        return (MdmFunctionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmFunctionRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmFunctionReqVo reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getFunctionCode())) {
            reqVo.setFunctionCode(CodeUtil.generateCode());
        }
        this.valid(reqVo);
        this.save(CrmBeanUtil.copy((Object)reqVo, MdmFunctionEntity.class));
    }

    private void valid(MdmFunctionReqVo reqVo) {
        if (StringUtils.isEmpty((Object)reqVo.getFunctionOrder())) {
            reqVo.setFunctionOrder(Integer.valueOf(1));
        }
        Assert.hasText((String)reqVo.getFunctionCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionName(), (String)"\u83dc\u5355\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionModule(), (String)"\u83dc\u5355\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getFunctionConfig(), (String)"\u83dc\u5355\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmFunctionReqVo reqVo) {
        this.valid(reqVo);
        Assert.hasText((String)reqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionEntity entity = (MdmFunctionEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u83dc\u5355\u4e0d\u5b58\u5728");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmFunctionEntity.class));
        String functionCode = entity.getFunctionCode();
        if (!StringUtils.isEmpty((Object)functionCode)) {
            TableConfigUtil.removeFunction((String)functionCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmFunctionReqVo reqVo) {
        List currentFunctionCodeList;
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list();
        ArrayList functionCodeList = new ArrayList();
        while (!CollectionUtils.isEmpty((Collection)list) && !CollectionUtils.isEmpty(currentFunctionCodeList = list.stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).collect(Collectors.toList()))) {
            functionCodeList.addAll(currentFunctionCodeList);
            list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmFunctionEntity::getParentCode, currentFunctionCodeList)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list();
        }
        if (!CollectionUtils.isEmpty(functionCodeList)) {
            List subIdList;
            List subList = ((LambdaQueryChainWrapper)this.mdmFunctionSubService.lambdaQuery().in(MdmFunctionSubEntity::getParentCode, functionCodeList)).select(new SFunction[]{BaseIdEntity::getId}).list();
            if (!CollectionUtils.isEmpty((Collection)subList) && !CollectionUtils.isEmpty(subIdList = subList.stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getId())).map(BaseIdEntity::getId).collect(Collectors.toList()))) {
                MdmFunctionSubReqVo mdmFunctionSubReqVo = new MdmFunctionSubReqVo();
                mdmFunctionSubReqVo.setIds(subIdList);
                this.mdmFunctionSubService.deleteBatch(mdmFunctionSubReqVo);
            }
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmFunctionEntity::getFunctionCode, functionCodeList)).remove();
            TableConfigUtil.removeAll();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmFunctionReqVo reqVo) {
        String functionCode = reqVo.getFunctionCode();
        List ids = reqVo.getIds();
        Assert.isTrue((!StringUtils.isEmpty((Object)functionCode) || !CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u6216id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!StringUtils.isEmpty((Object)functionCode), MdmFunctionEntity::getFunctionCode, (Object)functionCode)).in(!CollectionUtils.isEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        TableConfigUtil.removeAll();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmFunctionReqVo reqVo) {
        String functionCode = reqVo.getFunctionCode();
        List ids = reqVo.getIds();
        Assert.isTrue((!StringUtils.isEmpty((Object)functionCode) || !CollectionUtils.isEmpty((Collection)ids) ? 1 : 0) != 0, (String)"\u83dc\u5355\u7f16\u7801\u6216id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!StringUtils.isEmpty((Object)functionCode), MdmFunctionEntity::getFunctionCode, (Object)functionCode)).in(!CollectionUtils.isEmpty((Collection)ids), BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        TableConfigUtil.removeAll();
    }

    @Override
    public List<MdmFunctionRespVo> systemList(MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionReqVo.setFunctionConfig("0");
        return this.listCondition(mdmFunctionReqVo);
    }

    @Override
    public List<MdmFunctionRespVo> systemTree(MdmFunctionReqVo mdmFunctionReqVo) {
        mdmFunctionReqVo.setFunctionConfig("0");
        return this.functionTree(mdmFunctionReqVo);
    }

    @Override
    public List<String> findUserFunctionCodeList() {
        UserRedis user = UserUtils.getUser();
        Assert.notNull((Object)user, (String)"\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        String username = user.getUsername();
        if (!"admin".equals(username)) {
            String positionCode = user.getPoscode();
            Assert.hasText((String)positionCode, (String)"\u5f53\u524d\u804c\u4f4d\u672a\u6307\u5b9a");
            List<String> roleCodeList = this.mdmPositionRoleService.findRoleCodeByPosition(Collections.singletonList(positionCode));
            Assert.notEmpty(roleCodeList, (String)("\u5f53\u524d\u804c\u4f4d[" + positionCode + "]\u672a\u5206\u914d\u89d2\u8272"));
            List<String> functionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(roleCodeList);
            if (CollectionUtils.isEmpty(functionCodeList)) {
                functionCodeList = new ArrayList<String>();
            }
            functionCodeList.addAll(this.functionWhiteList());
            return functionCodeList.stream().distinct().collect(Collectors.toList());
        }
        return this.lambdaQuery().select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).distinct().collect(Collectors.toList());
    }

    protected void setUpFunctionIcon(List<MdmFunctionEntity> list) {
        List iconCodeList = list.stream().filter(x -> !StringUtils.isEmpty((Object)x.getIconCode())).map(MdmFunctionEntity::getIconCode).distinct().collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(iconCodeList)) {
            MdmIconReqVo mdmIconReqVo = new MdmIconReqVo();
            mdmIconReqVo.setIconCodeList(iconCodeList);
            List<MdmIconRespVo> mdmIconRespVos = this.mdmIconService.listCondition(mdmIconReqVo);
            if (!CollectionUtils.isEmpty(mdmIconRespVos)) {
                Map<String, String> iconMap = mdmIconRespVos.stream().collect(Collectors.toMap(MdmIconRespVo::getIconCode, MdmIconRespVo::getIconStyle));
                for (MdmFunctionEntity mdmFunctionEntity : list) {
                    if (!StringUtils.isEmpty((Object)mdmFunctionEntity.getFunctionIcon())) continue;
                    mdmFunctionEntity.setFunctionIcon(iconMap.get(mdmFunctionEntity.getIconCode()));
                }
            }
        }
    }

    private void setUpChildren(MdmFunctionRespVo mdmFunctionRespVo, List<MdmFunctionRespVo> list, List<MdmFunctionRespVo> result, List<MdmFunctionRespVo> subList) {
        if (StringUtils.isEmpty((Object)mdmFunctionRespVo.getParentCode())) {
            if (!result.contains(mdmFunctionRespVo)) {
                result.add(mdmFunctionRespVo);
            }
            if (!subList.contains(mdmFunctionRespVo)) {
                subList.add(mdmFunctionRespVo);
            }
            return;
        }
        if (subList.contains(mdmFunctionRespVo)) {
            return;
        }
        Optional<MdmFunctionRespVo> any = list.stream().filter(x -> mdmFunctionRespVo.getParentCode().equals(x.getFunctionCode())).findAny();
        if (!any.isPresent()) {
            return;
        }
        MdmFunctionRespVo parentTreeRespVo = any.get();
        ArrayList<MdmFunctionRespVo> children = parentTreeRespVo.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            children = new ArrayList<MdmFunctionRespVo>();
        }
        children.add(mdmFunctionRespVo);
        children.sort(Comparator.comparing(x -> x.getFunctionOrder()));
        parentTreeRespVo.setChildren(children);
        subList.add(mdmFunctionRespVo);
        this.setUpChildren(parentTreeRespVo, list, result, subList);
    }

    @Override
    public List<MdmFunctionRespVo> listCondition(MdmFunctionReqVo mdmFunctionReqVo) {
        List<String> functionCodeList = this.findUserFunctionCodeList();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionCode()), MdmFunctionEntity::getFunctionCode, (Object)mdmFunctionReqVo.getFunctionCode())).like(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionName()), MdmFunctionEntity::getFunctionName, (Object)mdmFunctionReqVo.getFunctionName())).in(!CollectionUtils.isEmpty(functionCodeList), MdmFunctionEntity::getFunctionCode, functionCodeList)).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getParentCode()), MdmFunctionEntity::getParentCode, (Object)mdmFunctionReqVo.getParentCode())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionModule()), MdmFunctionEntity::getFunctionModule, (Object)mdmFunctionReqVo.getFunctionModule())).eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionReqVo.getFunctionConfig())).orderByAsc(MdmFunctionEntity::getFunctionOrder)).list();
        if (!CollectionUtils.isEmpty((Collection)list)) {
            this.setUpFunctionIcon(list);
        }
        return CrmBeanUtil.copyList((List)list, MdmFunctionRespVo.class);
    }

    @Override
    public List<MdmFunctionRespVo> listMdmFunctionByMenuConfig() {
        List entities = this.mdmFunctionMapper.selectList((Wrapper)Wrappers.lambdaQuery(MdmFunctionEntity.class).eq(MdmFunctionEntity::getMenuConfig, (Object)YesNoEnum.yesNoEnum.Y.getValue()));
        List mdmFunctionRespVos = CrmBeanUtil.copyList((List)entities, MdmFunctionRespVo.class);
        return mdmFunctionRespVos;
    }

    @Override
    public PageResult<MdmFunctionRespVo> functionPage(MdmFunctionReqVo mdmFunctionReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmFunctionReqVo.getPageNum(), (Integer)mdmFunctionReqVo.getPageSize());
        List<MdmFunctionRespVo> list = this.mdmFunctionMapper.findList((Page<MdmFunctionRespVo>)page, mdmFunctionReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmRoleFunctionTreeVo> roleFunctionTree(MdmRoleFunctionReqVo mdmRoleFunctionReqVo) {
        String roleCode = mdmRoleFunctionReqVo.getRoleCode();
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmFunctionReqVo mdmFunctionReqVo = new MdmFunctionReqVo();
        mdmFunctionReqVo.setFunctionConfig(mdmFunctionReqVo.getFunctionConfig());
        List<Object> functionList = this.mdmFunctionMapper.roleFunctionTree(mdmFunctionReqVo);
        if (CollectionUtils.isEmpty(functionList)) {
            return Collections.emptyList();
        }
        List<String> functionCodeList = this.mdmFunctionRoleService.findFunctionCodeByRole(roleCode);
        if (!CollectionUtils.isEmpty(functionCodeList)) {
            functionList = functionList.stream().peek(x -> {
                if (functionCodeList.contains(x.getFunctionCode())) {
                    x.setFunctionSelect(YesNoEnum.yesNoEnum.ONE.getValue());
                }
            }).collect(Collectors.toList());
        }
        ArrayList<MdmRoleFunctionTreeVo> rootList = new ArrayList<MdmRoleFunctionTreeVo>();
        for (MdmRoleFunctionTreeVo mdmRoleFunctionTreeVo : functionList) {
            ArrayList<MdmRoleFunctionTreeVo> children;
            if (StringUtils.isEmpty((Object)mdmRoleFunctionTreeVo.getParentCode())) {
                rootList.add(mdmRoleFunctionTreeVo);
            }
            if ((children = mdmRoleFunctionTreeVo.getChildren()) == null) {
                children = new ArrayList<MdmRoleFunctionTreeVo>();
            }
            for (MdmRoleFunctionTreeVo mdmRoleFunctionTreeVo2 : functionList) {
                String parentCode = mdmRoleFunctionTreeVo2.getParentCode();
                if (StringUtils.isEmpty((Object)parentCode) || !parentCode.equals(mdmRoleFunctionTreeVo.getFunctionCode())) continue;
                children.add(mdmRoleFunctionTreeVo2);
            }
            mdmRoleFunctionTreeVo.setChildren(children);
        }
        return rootList;
    }

    @Override
    public List<MdmFunctionRespVo> functionTree(MdmFunctionReqVo mdmFunctionReqVo) {
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionReqVo.getFunctionConfig())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        this.setUpFunctionIcon(list);
        List mdmFunctionRespVos = CrmBeanUtil.copyList((List)list, MdmFunctionRespVo.class);
        ArrayList result = new ArrayList();
        ArrayList subList = new ArrayList();
        List<String> finalFunctionCodeList = this.findUserFunctionCodeList();
        mdmFunctionRespVos.stream().filter(x -> StringUtils.isEmpty((Object)mdmFunctionReqVo.getFunctionName()) || x.getFunctionName().contains(mdmFunctionReqVo.getFunctionName())).filter(x -> StringUtils.isEmpty((Object)x.getParentCode()) || finalFunctionCodeList.contains(x.getFunctionCode())).forEach(x -> this.setUpChildren((MdmFunctionRespVo)x, mdmFunctionRespVos, result, subList));
        List<MdmFunctionRespVo> collect = result.stream().filter(x -> !CollectionUtils.isEmpty((Collection)x.getChildren()) || finalFunctionCodeList.contains(x.getFunctionCode())).sorted(Comparator.comparing(x -> x.getFunctionOrder())).collect(Collectors.toList());
        String excludeFunctionCode = mdmFunctionReqVo.getExcludeFunctionCode();
        if (!StringUtils.isEmpty((Object)excludeFunctionCode)) {
            this.excludeCodeAndChildren(collect, excludeFunctionCode);
        }
        return collect;
    }

    protected void excludeCodeAndChildren(List<MdmFunctionRespVo> tree, String excludeFunctionCode) {
        if (!CollectionUtils.isEmpty(tree) && !StringUtils.isEmpty((Object)excludeFunctionCode)) {
            Iterator<MdmFunctionRespVo> iterator = tree.iterator();
            while (iterator.hasNext()) {
                MdmFunctionRespVo item = iterator.next();
                if (item.getFunctionCode().equals(excludeFunctionCode)) {
                    iterator.remove();
                    return;
                }
                this.excludeCodeAndChildren(item.getChildren(), excludeFunctionCode);
            }
        }
    }

    @Override
    public List<String> findCurrentAndSubFunctionCodeList(String functionCode) {
        List currentFunctionCodeList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmFunctionEntity::getFunctionCode, (Object)functionCode)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).distinct().collect(Collectors.toList());
        ArrayList<String> result = new ArrayList<String>();
        while (!CollectionUtils.isEmpty(currentFunctionCodeList)) {
            result.addAll(currentFunctionCodeList);
            currentFunctionCodeList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmFunctionEntity::getParentCode, currentFunctionCodeList)).select(new SFunction[]{MdmFunctionEntity::getFunctionCode}).list().stream().filter(x -> x != null && !StringUtils.isEmpty((Object)x.getFunctionCode())).map(MdmFunctionEntity::getFunctionCode).distinct().collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<MdmFunctionRespVo> functionSearchTree(MdmFunctionSearchReqVo mdmFunctionSearchReqVo) {
        List<String> userFunctionCodeList = this.findUserFunctionCodeList();
        if (CollectionUtils.isEmpty(userFunctionCodeList)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmFunctionSearchReqVo.getFunctionConfig()), MdmFunctionEntity::getFunctionConfig, (Object)mdmFunctionSearchReqVo.getFunctionConfig())).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List mdmFunctionRespVos = CrmBeanUtil.copyList((List)list, MdmFunctionRespVo.class);
        ArrayList<MdmFunctionRespVo> root = new ArrayList<MdmFunctionRespVo>();
        String specificRootCode = mdmFunctionSearchReqVo.getSpecificRootCode();
        for (MdmFunctionRespVo mdmFunctionRespVo : mdmFunctionRespVos) {
            ArrayList<MdmFunctionRespVo> children;
            if (userFunctionCodeList.contains(mdmFunctionRespVo.getFunctionCode())) {
                if (!StringUtils.isEmpty((Object)specificRootCode)) {
                    if (specificRootCode.equals(mdmFunctionRespVo.getFunctionCode())) {
                        root.add(mdmFunctionRespVo);
                    }
                } else if (StringUtils.isEmpty((Object)mdmFunctionRespVo.getParentCode())) {
                    root.add(mdmFunctionRespVo);
                }
            }
            if ((children = mdmFunctionRespVo.getChildren()) == null) {
                children = new ArrayList<MdmFunctionRespVo>();
            }
            for (MdmFunctionRespVo functionRespVo : mdmFunctionRespVos) {
                if (!mdmFunctionRespVo.getFunctionCode().equals(functionRespVo.getParentCode())) continue;
                children.add(functionRespVo);
            }
            children.sort(Comparator.comparing(x -> Optional.ofNullable(x).map(MdmFunctionRespVo::getFunctionOrder).orElse(100)));
            mdmFunctionRespVo.setChildren(children);
        }
        this.excludeCodeAndChildren(root, mdmFunctionSearchReqVo.getExcludeFunctionCode());
        return root;
    }

    protected List<String> functionWhiteList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("CRM20201128000000156");
        if (!StringUtils.isEmpty((Object)this.whiteFunctionCodeList)) {
            list.addAll(Arrays.asList(this.whiteFunctionCodeList.split(",")));
        }
        return list;
    }
}

