/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.manager;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.BaseBuilder;
import com.biz.crm.customer.model.MdmCustomerEntity;
import com.biz.crm.customer.service.MdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.tpm.ActApproveStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.user.service.MdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.Collections;

public class MdmCustomerMsgBuilder
extends BaseBuilder<MdmCustomerMsgReqVo> {
    private MdmCustomerEntity mdmCustomerMsgEntity;
    private boolean isSave;
    private MdmCustomerMsgService mdmCustomerMsgService;
    private MdmUserService mdmUserService;

    public static MdmCustomerMsgBuilder builder(boolean isSave, MdmCustomerMsgService mdmCustomerMsgService, MdmUserService mdmUserService) {
        MdmCustomerMsgBuilder builder = new MdmCustomerMsgBuilder();
        builder.isSave = isSave;
        builder.mdmCustomerMsgService = mdmCustomerMsgService;
        builder.mdmUserService = mdmUserService;
        return builder;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> valid() {
        Assert.hasText((String)((MdmCustomerMsgReqVo)this.t).getCustomerName(), (String)"\u5ba2\u6237\u4fe1\u606f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((this.isSave || !StringUtils.isEmpty((String)((MdmCustomerMsgReqVo)this.t).getId()) ? 1 : 0) != 0, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> convert() {
        if (this.isSave) {
            if (StringUtils.isEmpty((String)((MdmCustomerMsgReqVo)this.t).getCustomerCode())) {
                ((MdmCustomerMsgReqVo)this.t).setCustomerCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_CUSTOMER.getCode()));
            } else {
                Integer count = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerEntity::getCustomerCode, (Object)((MdmCustomerMsgReqVo)this.t).getCustomerCode())).select(new SFunction[]{BaseIdEntity::getId}).count();
                Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u5b58\u5728");
            }
        } else {
            Integer count = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().ne(BaseIdEntity::getId, (Object)((MdmCustomerMsgReqVo)this.t).getId())).eq(MdmCustomerEntity::getCustomerCode, (Object)((MdmCustomerMsgReqVo)this.t).getCustomerCode())).count();
            Assert.isTrue((count == null || count < 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7f16\u7801\u5df2\u5b58\u5728");
        }
        this.mdmCustomerMsgEntity = (MdmCustomerEntity)((Object)CrmBeanUtil.copy((Object)this.t, MdmCustomerEntity.class));
        if (StringUtils.isEmpty((String)this.mdmCustomerMsgEntity.getActApproveStatus())) {
            this.mdmCustomerMsgEntity.setActApproveStatus(ActApproveStatusEnum.CREATE.getCode());
        }
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> after() {
        String userName;
        this.mdmCustomerMsgService.setUpCollateral((MdmCustomerMsgReqVo)this.t);
        if (!this.isSave && StringUtils.isNotEmpty((String)(userName = this.mdmCustomerMsgEntity.getUserName()))) {
            this.mdmUserService.updateUserCustomerRedundancyByUser(null, Collections.singletonList(userName));
        }
        this.mdmCustomerMsgService.sendCustomerChangeMsg(Collections.singletonList(((MdmCustomerMsgReqVo)this.t).getCustomerCode()));
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> persistence() {
        if (this.isSave) {
            this.mdmCustomerMsgService.save((Object)this.mdmCustomerMsgEntity);
        } else {
            this.mdmCustomerMsgService.updateById((Object)this.mdmCustomerMsgEntity);
        }
        return this;
    }
}

