/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelSelectRespVo;
import com.biz.crm.productlevel.service.MdmProductLevelService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmProductLevelController"})
@Api(tags={"MDM-\u4ea7\u54c1\u5c42\u7ea7"})
@CrmGlobalLog
public class MdmProductLevelController {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelController.class);
    @Autowired
    private MdmProductLevelService mdmProductLevelService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868(\u5206\u9875)")
    @PostMapping(value={"/pageList"})
    @CrmDictMethod
    public Result<PageResult<MdmProductLevelRespVo>> pageList(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        PageResult<MdmProductLevelRespVo> result = this.mdmProductLevelService.findList(mdmProductLevelReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u4ea7\u54c1\u5c42\u7ea7\u516c\u7528\u5206\u9875\u5f39\u6846")
    @PostMapping(value={"/commonPageList"})
    @CrmDictMethod
    public Result<PageResult<MdmProductLevelRespVo>> commonPageList(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        mdmProductLevelReqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        PageResult<MdmProductLevelRespVo> result = this.mdmProductLevelService.findList(mdmProductLevelReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8be6\u60c5", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="productLevelCode", value="\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    @CrmDictMethod
    public Result<MdmProductLevelRespVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="productLevelCode", required=false) String productLevelCode) {
        return Result.ok((Object)this.mdmProductLevelService.detail(id, productLevelCode));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.save(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.update(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.mdmProductLevelService.deleteBatch(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.mdmProductLevelService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.mdmProductLevelService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u91cd\u7f6e\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/resetRuleCode"})
    public Result resetRuleCode() {
        this.mdmProductLevelService.resetRuleCode();
        return Result.ok();
    }

    @ApiOperation(value="\u6839\u636e\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801\u67e5\u8be2\u8be5\u4ea7\u54c1\u5c42\u7ea7\u53ca\u5168\u90e8\u4e0b\u7ea7\u5c42\u7ea7\u7684\u7f16\u7801", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="productLevelCode", value="\u4ea7\u54c1\u5c42\u7ea7\u7f16\u7801", required=true, dataType="String", paramType="query")})
    @GetMapping(value={"/getAllChildrenProductLevelCodeList"})
    public Result<List<String>> getAllChildrenProductLevelCodeList(@RequestParam(value="productLevelCode") String productLevelCode) {
        return Result.ok(this.mdmProductLevelService.getAllChildrenProductLevelCodeList(null, productLevelCode));
    }

    @ApiOperation(value="\u4ea7\u54c1\u5c42\u7ea7\u4e0b\u62c9\u6846(\u9650\u5236\u6570\u91cf)")
    @PostMapping(value={"/productLevelSelectList"})
    @CrmDictMethod
    public Result<List<MdmProductLevelSelectRespVo>> productLevelSelectList(@RequestBody MdmProductLevelSelectReqVo reqVo) {
        return Result.ok(this.mdmProductLevelService.productLevelSelectList(reqVo));
    }
}

