/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cusorg.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.cusorg.entity.CusOrgEntity;
import com.biz.crm.cusorg.mapper.CusOrgMapper;
import com.biz.crm.cusorg.service.CusOrgService;
import com.biz.crm.cusorg.util.CusOrgUtil;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Transactional
@Service(value="cusOrgService")
public class CusOrgServiceImpl
extends ServiceImpl<CusOrgMapper, CusOrgEntity>
implements CusOrgService {
    @Autowired
    private CusOrgMapper cusOrgMapper;

    @Override
    public void add(final CusOrgVo cusOrgVo) {
        CrmEnableStatusEnum.validateEnableStatus((String)cusOrgVo.getEnableStatus());
        CusOrgEntity parent = null;
        int brothersNum = 0;
        if (!StringUtils.isEmpty((Object)cusOrgVo.getParentId())) {
            parent = (CusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)cusOrgVo.getParentId())));
            if (null == parent || !parent.isNormal()) {
                throw new BusinessException("\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u8005\u5df2\u7ecf\u88ab\u5220\u9664!");
            }
            List brothers = this.cusOrgMapper.selectByMap(new HashMap<String, Object>(){
                {
                    this.put("parent_id", cusOrgVo.getParentId());
                }
            });
            brothersNum = CollectionUtils.isEmpty((Collection)brothers) ? 0 : brothers.size();
        } else {
            List brothers = this.cusOrgMapper.selectByMap(new HashMap<String, Object>(){
                {
                    this.put("level_num", 1);
                }
            });
            brothersNum = CollectionUtils.isEmpty((Collection)brothers) ? 0 : brothers.size();
        }
        this.cusOrgMapper.insert((Object)CusOrgUtil.voToEntity(cusOrgVo, parent, brothersNum));
    }

    @Override
    public void edit(CusOrgVo cusOrgVo) {
        CusOrgEntity entity;
        ValidateUtils.validate((Object)cusOrgVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u5ba2\u6237\u7ec4\u7ec7!");
        if (!StringUtils.isEmpty((Object)cusOrgVo.getEnableStatus())) {
            CrmEnableStatusEnum.validateEnableStatus((String)cusOrgVo.getEnableStatus());
        }
        if (null == (entity = (CusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)cusOrgVo.getId()))))) {
            throw new BusinessException("\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664\uff01");
        }
        BeanUtils.copyProperties((Object)cusOrgVo, (Object)((Object)entity));
        this.cusOrgMapper.updateById((Object)entity);
    }

    @Override
    public PageResult<CusOrgVo> list(CusOrgVo cusOrgVo) {
        cusOrgVo.setDelFlag(CrmDelFlagEnum.NORMAL.getCode());
        Page page = new Page((long)cusOrgVo.getPageNum().intValue(), (long)cusOrgVo.getPageSize().intValue());
        List<CusOrgVo> list = this.cusOrgMapper.list(page, cusOrgVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public CusOrgVo getById(String id) {
        CusOrgEntity entity = (CusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)id)));
        if (null != entity) {
            return (CusOrgVo)JSON.parseObject((String)JSON.toJSONString((Object)((Object)entity)), CusOrgVo.class);
        }
        return null;
    }

    @Override
    public void ableBatch(ArrayList<String> ids, CrmEnableStatusEnum crmEnableStatusEnum) {
        this.cusOrgMapper.ableBatch(ids, crmEnableStatusEnum.getCode());
    }

    @Override
    public void stateBatch(ArrayList<String> ids, CrmDelFlagEnum crmDelFlagEnum) {
        this.cusOrgMapper.stateBatch(ids, crmDelFlagEnum.getCode());
    }

    @Override
    public void ableByParam(CusOrgVo cusOrgVo, CrmEnableStatusEnum crmEnableStatusEnum) {
        this.cusOrgMapper.ableByParam(cusOrgVo, crmEnableStatusEnum.getCode());
    }

    @Override
    public void stateByParam(CusOrgVo cusOrgVo, CrmDelFlagEnum crmDelFlagEnum) {
        this.cusOrgMapper.stateByParam(cusOrgVo, crmDelFlagEnum.getCode());
    }

    @Override
    public CusOrgVo findDetailsByFormInstanceId(String formInstanceId) {
        if (StringUtils.isEmpty((Object)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        List cusOrgEntities = this.cusOrgMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)cusOrgEntities)) {
            return null;
        }
        CusOrgVo cusOrgVo = new CusOrgVo();
        BeanUtils.copyProperties(cusOrgEntities.get(0), (Object)cusOrgVo);
        return cusOrgVo;
    }
}

