/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customermaterial.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.customermaterial.mapper.MdmCustomerMaterialMapper;
import com.biz.crm.customermaterial.model.MdmCustomerMaterialEntity;
import com.biz.crm.customermaterial.service.IMdmCustomerMaterialService;
import com.biz.crm.customermaterial.service.impl.MdmCustomerMaterialServiceHelper;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.mdm.MdmCusMaterialException;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="iMdmCustomerMaterialService")
public class MdmCustomerMaterialServiceImpl
extends ServiceImpl<MdmCustomerMaterialMapper, MdmCustomerMaterialEntity>
implements IMdmCustomerMaterialService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMaterialServiceImpl.class);
    @Autowired
    private MdmCustomerMaterialMapper mdmCustomerMaterialMapper;
    @Autowired
    private MdmCustomerMaterialServiceHelper customerMaterialServiceHelper;

    @Override
    public PageResult<MdmCustomerMaterialRespVo> findList(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        Page page = new Page((long)mdmCustomerMaterialReqVo.getPageNum().intValue(), (long)mdmCustomerMaterialReqVo.getPageSize().intValue());
        List<MdmCustomerMaterialRespVo> list = this.mdmCustomerMaterialMapper.findList((Page<MdmCustomerMaterialRespVo>)page, mdmCustomerMaterialReqVo);
        this.customerMaterialServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmCustomerMaterialRespVo query(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        List list = this.findList(mdmCustomerMaterialReqVo).getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new BusinessException((CrmExceptionType)MdmCusMaterialException.DATA_NOT_EXIST);
        }
        return (MdmCustomerMaterialRespVo)list.get(0);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        MdmCustomerMaterialEntity entity = (MdmCustomerMaterialEntity)((Object)CrmBeanUtil.copy((Object)mdmCustomerMaterialReqVo, MdmCustomerMaterialEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        MdmCustomerMaterialEntity entity = (MdmCustomerMaterialEntity)((Object)this.getById((Serializable)((Object)mdmCustomerMaterialReqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        List mdmCustomerMaterialEntities = this.mdmCustomerMaterialMapper.selectBatchIds(mdmCustomerMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmCustomerMaterialEntities)) {
            mdmCustomerMaterialEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmCustomerMaterialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        List mdmCustomerMaterialEntities = this.mdmCustomerMaterialMapper.selectBatchIds(mdmCustomerMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmCustomerMaterialEntities)) {
            mdmCustomerMaterialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmCustomerMaterialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
        List mdmCustomerMaterialEntities = this.mdmCustomerMaterialMapper.selectBatchIds(mdmCustomerMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmCustomerMaterialEntities)) {
            mdmCustomerMaterialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmCustomerMaterialEntities);
    }
}

