/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.dict.entity.MdmDictDataEntity;
import com.biz.crm.dict.entity.MdmDictTypeEntity;
import com.biz.crm.dict.mapper.MdmDictDataMapper;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.dict.utils.MdmDictTypeMap;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataPageReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataSearchReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.resp.MdmDictDataPageRespVo;
import com.biz.crm.nebular.mdm.dict.dictdata.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.dicttype.req.MdmDictTypePageReqVo;
import com.biz.crm.nebular.mdm.dict.dicttype.resp.MdmDictTypePageRespVo;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import java.io.Serializable;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmDictDataServiceImpl
extends ServiceImpl<MdmDictDataMapper, MdmDictDataEntity>
implements MdmDictDataService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictDataServiceImpl.class);
    @Lazy
    @Autowired
    private MdmDictTypeService mdmDictTypeService;

    @Override
    @Transactional(rollbackFor={BusinessException.class})
    public Boolean addOrUpdate(MdmDictDataReqVo mdmDictDataReqVo) {
        MdmDictTypeEntity one = (MdmDictTypeEntity)((Object)this.mdmDictTypeService.getById((Serializable)((Object)mdmDictDataReqVo.getDictTypeId())));
        ValidateUtils.validate((Object)((Object)one), (String)("\u6570\u636e\u5206\u7c7b\u4e0d\u5b58\u5728,\u5206\u7c7b\u7f16\u7801:" + mdmDictDataReqVo.getDictTypeCode()));
        if (!StringUtils.isEmpty((String)mdmDictDataReqVo.getParentId()) && StringUtils.isEmpty((String)mdmDictDataReqVo.getId())) {
            MdmDictDataEntity parentEntity = (MdmDictDataEntity)((Object)this.getById((Serializable)((Object)mdmDictDataReqVo.getParentId())));
            ValidateUtils.validate((Object)((Object)parentEntity), (String)("\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728,\u4e0a\u7ea7\u5b57\u5178\u7f16\u7801:" + mdmDictDataReqVo.getParentDictCode()));
            mdmDictDataReqVo.setParentId(parentEntity.getId());
            parentEntity.setIsLeaf(0);
            this.updateById((Object)parentEntity);
            mdmDictDataReqVo.setIsLeaf(Integer.valueOf(1));
        }
        return this.saveOrUpdate((Object)MdmDictTypeMap.INSTANCE.toMdmDictDataEntity(mdmDictDataReqVo));
    }

    @Override
    public Page<MdmDictDataPageRespVo> pageCondition(MdmDictDataPageReqVo mdmDictDataPageReqVo) {
        MdmDictTypePageRespVo one;
        if (!StringUtils.isEmpty((String)mdmDictDataPageReqVo.getDictTypeCode()) && StringUtils.isEmpty((String)mdmDictDataPageReqVo.getDictTypeId()) && (one = this.mdmDictTypeService.one(new MdmDictTypePageReqVo().setDictTypeCode(mdmDictDataPageReqVo.getDictTypeCode()))) != null) {
            mdmDictDataPageReqVo.setDictTypeId(one.getId());
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(!StringUtils.isEmpty((String)mdmDictDataPageReqVo.getDictCode()), MdmDictDataEntity::getDictCode, (Object)mdmDictDataPageReqVo.getDictCode())).eq(!StringUtils.isEmpty((String)mdmDictDataPageReqVo.getDictTypeId()), MdmDictDataEntity::getDictTypeId, (Object)mdmDictDataPageReqVo.getDictTypeId());
        Page page = (Page)this.page((IPage)new Page((long)mdmDictDataPageReqVo.getPageNum().intValue(), (long)mdmDictDataPageReqVo.getPageSize().intValue()), (Wrapper)wrapper);
        return MdmDictTypeMap.INSTANCE.toMdmDictDataPageRespVo((Page<MdmDictDataEntity>)page);
    }

    @Override
    public Boolean removeCondition(String id, String dictCode) {
        if (StringUtils.isEmpty((String)id) && StringUtils.isEmpty((String)dictCode)) {
            throw new BusinessException("id\u6216\u7f16\u7801\u5fc5\u4f20");
        }
        return ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!StringUtils.isEmpty((String)id), BaseIdEntity::getId, (Object)id)).or()).eq(!StringUtils.isEmpty((String)dictCode), MdmDictDataEntity::getDictCode, (Object)dictCode)).remove();
    }

    @Override
    public Boolean removeType(String dictTypeId) {
        return ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(!StringUtils.isEmpty((String)dictTypeId), MdmDictDataEntity::getDictTypeId, (Object)dictTypeId)).remove();
    }

    @Override
    public List<MdmDictDataRespVo> condition(MdmDictDataSearchReqVo mdmDictDataSearchReqVo) {
        MdmDictTypePageRespVo one;
        if (StringUtils.isEmpty((String)mdmDictDataSearchReqVo.getDictTypeId()) && !StringUtils.isEmpty((String)mdmDictDataSearchReqVo.getDictTypeCode()) && (one = this.mdmDictTypeService.one(new MdmDictTypePageReqVo().setDictTypeCode(mdmDictDataSearchReqVo.getDictTypeCode()))) != null) {
            mdmDictDataSearchReqVo.setDictTypeId(one.getId());
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)mdmDictDataSearchReqVo.getDictTypeId()), MdmDictDataEntity::getDictTypeId, (Object)mdmDictDataSearchReqVo.getDictTypeId())).eq(!StringUtils.isEmpty((String)mdmDictDataSearchReqVo.getDictCode()), MdmDictDataEntity::getDictCode, (Object)mdmDictDataSearchReqVo.getDictCode())).eq(!StringUtils.isEmpty((String)mdmDictDataSearchReqVo.getParentId()), MdmDictDataEntity::getParentId, (Object)mdmDictDataSearchReqVo.getParentId())).list();
        return MdmDictTypeMap.INSTANCE.toMdmDictDataRespVo(list);
    }
}

