/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.eunm.ProductTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.mdm.MdmProductException;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.impl.MdmProductServiceHelper;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmProductBuilder {
    private static final Logger log = LoggerFactory.getLogger(MdmProductBuilder.class);
    private MdmProductServiceHelper helper;
    private MdmProductReqVo reqVo;
    private MdmProductEntity productEntity;
    private MdmProductIntroductionEntity introductionEntity;
    private List<MdmProductMediaEntity> mediaEntities = Lists.newArrayList();
    private List<MdmProductMaterialEntity> materialEntities = Lists.newArrayList();

    public MdmProductBuilder(MdmProductServiceHelper helper, MdmProductReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static MdmProductBuilder builder(MdmProductServiceHelper helper, MdmProductReqVo reqVo) {
        return new MdmProductBuilder(helper, reqVo);
    }

    public MdmProductBuilder init() {
        return this;
    }

    public MdmProductBuilder check() {
        List<MdmProductEntity> products = this.helper.findProductsByParam(this.reqVo);
        if (CollectionUtils.isNotEmpty(products)) {
            new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_CODE_EXIST);
        }
        if (StringUtils.equals((CharSequence)ProductTypeEnum.STANDARD.getCode(), (CharSequence)this.reqVo.getProductType()) && this.reqVo.getMaterialList().size() > 1) {
            new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_MATERIAL_ERROR);
        }
        return this;
    }

    public MdmProductBuilder convert() {
        List videoList;
        MdmProductEntity mdmProductEntity = new MdmProductEntity();
        CrmBeanUtil.copyProperties((Object)this.reqVo, (Object)((Object)mdmProductEntity));
        this.productEntity = mdmProductEntity;
        this.materialEntities = this.reqVo.getMaterialList().stream().map(o -> {
            MdmProductMaterialEntity materialEntity = new MdmProductMaterialEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)materialEntity));
            materialEntity.setProductCode(mdmProductEntity.getProductCode());
            return materialEntity;
        }).collect(Collectors.toList());
        List pictureList = this.reqVo.getPictureList().stream().filter(Objects::nonNull).map(o -> {
            MdmProductMediaEntity mediaEntity = new MdmProductMediaEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)mediaEntity));
            mediaEntity.setType(FileTypeEnum.PICTURE.getCode());
            mediaEntity.setProductCode(mdmProductEntity.getProductCode());
            return mediaEntity;
        }).collect(Collectors.toList());
        if (CollectionUtil.listNotEmpty(pictureList)) {
            this.mediaEntities.addAll(pictureList);
        }
        if (CollectionUtil.listNotEmpty(videoList = this.reqVo.getVideoList().stream().filter(Objects::nonNull).map(o -> {
            MdmProductMediaEntity mediaEntity = new MdmProductMediaEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)mediaEntity));
            mediaEntity.setProductCode(mdmProductEntity.getProductCode());
            mediaEntity.setType(FileTypeEnum.VIDEO.getCode());
            return mediaEntity;
        }).collect(Collectors.toList()))) {
            this.mediaEntities.addAll(videoList);
        }
        if (Objects.nonNull(this.reqVo.getIntroductionVo())) {
            MdmProductIntroductionEntity introductionEntity = new MdmProductIntroductionEntity();
            CrmBeanUtil.copyProperties((Object)this.reqVo.getIntroductionVo(), (Object)((Object)introductionEntity));
            introductionEntity.setProductCode(mdmProductEntity.getProductCode());
            this.introductionEntity = introductionEntity;
        }
        return this;
    }

    public void save() {
        this.helper.saveProductEntity(this.productEntity);
        this.helper.saveProductIntroduction(this.introductionEntity);
        this.helper.saveProductMaterials(this.materialEntities);
        this.helper.saveProductMedias(this.mediaEntities);
    }
}

